<?php
// vim: foldmethod=marker
/**
CREATE TABLE bb_posts (
  post_id int(8) unsigned NOT NULL auto_increment,
  pid int(8) NOT NULL default '0',
  topic_id int(8) NOT NULL default '0',
  forum_id int(4) NOT NULL default '0',
  post_time int(10) NOT NULL default '0',
  uid int(5) unsigned NOT NULL default '0',
  poster_ip varchar(15) NOT NULL default '',
  subject varchar(255) NOT NULL default '',
  nohtml tinyint(1) NOT NULL default '0',
  nosmiley tinyint(1) NOT NULL default '0',
  icon varchar(25) NOT NULL default '',
  attachsig tinyint(1) NOT NULL default '0',
  PRIMARY KEY  (post_id),
  KEY uid (uid),
  KEY pid (pid),
  KEY subject (subject(40)),
  KEY forumid_uid (forum_id, uid),
  KEY topicid_uid (topic_id, uid),
  KEY topicid_postid_pid (topic_id, post_id, pid),
  FULLTEXT KEY search (subject)
) TYPE=MyISAM;
 *	
 *
 *	@author		ITOH Takashi
 *	@package	Sample
 *	@version	$Id: Sample_Rss.php,v 1.1 2005/01/23 13:46:58 masaki-f Exp $
 */

// {{{ Xanhte_NewbbPosts
/**
 *	XanhteץꥱΥ桼饹
 *
 *	@author		ITOH Takashi
 *	@access		public
 *	@package	Sample
 */

class Xanhte_NewbbPostsManager extends Xanhte_AppManager
{


	/***
	 * POST_IDƤ
	 * @access public
	 * @param int $post_id POST_ID
	 * @return array $prop ץѥƥ
	 */
	function getPostByPostId($post_id){
		$filter = array(
			'post_id' => new Ethna_AppSearchObject($post_id, OBJECT_CONDITION_EQ),
			'post_text' => new Ethna_AppSearchObject('', OBJECT_CONDITION_NE),
		);
		
		$post = $this->getObjectProp('NewbbPosts', null, $filter);
		
		return $post;
	}
	
	/***
	 * Ƥɲ
	 * @access public
	 * @param string $cat_title ƥΥȥ
	 * @return array $prop ץѥƥ
	 */
	function addPosts($cat_title){
	}
	
	
	
	/***
	 * ȥԥåIDƤ
	 * af->topicpage / af->viewmode / af->postorder ˰¸
	 *
	 * @access public
	 * @param int $topic_id ȥԥåID
	 * @param int $posts_per_page 1ڡ˽Фƿ
	 * @return array 0 => ƿ 1=> Array
	 */
	function getPostsByTopicId($topic_id, $posts_per_page){
		
		if ($this->af->get('viewmode')=='flat'){
			// եåɽξ
			$limit = $posts_per_page ;
			$offset = $this->af->get('topicpage') ? $limit * ($this->af->get('topicpage')-1) : 0 ;
			$filter = array('topic_id' => new Ethna_AppSearchObject($topic_id, OBJECT_CONDITION_EQ)); 
			$order = array('post_time' => $this->af->get('postorder')=='DESC' ? OBJECT_SORT_DESC : OBJECT_SORT_ASC );
			$posts = $this->getObjectPropList('NewbbPosts', null, $filter, $order, $offset , $limit);
		} else {
			// åɽξ
			$post_id = $this->af->get('post_id');
			if ($post_id){
				$filter = array('post_id' => new Ethna_AppSearchObject($post_id, OBJECT_CONDITION_EQ)); 
				$post = $this->getObjectProp('NewbbPosts', null, $filter);
				$posts = array(1, array($post));
			} else {
				$filter = array('topic_id' => new Ethna_AppSearchObject($topic_id, OBJECT_CONDITION_EQ)); 
				$order = array('post_time' => OBJECT_SORT_ASC);
				$posts = $this->getObjectPropList('NewbbPosts', null, $filter, $order, 0, 1);
			}
		}
		
		return $posts ;
	}
	
	
	
	
	/***
	 * ƿΤ
	 
	 * @access public
	 * @return int
	 */
	function getTotalPosts(){
	
		global $xoopsDB ;
		
		$db =& $this->backend->getDB();
		$sql = sprintf('select count(*) as c from %s', $xoopsDB->prefix('bb_posts'));
		if ($re = $db->query($sql)){
			$ret = $re->fetchRow();
			return $ret['c'];
		}
		return 0 ;
	}
	
	/***
	 * Ƥɤ
	 * NewbbƤ3ĤΥơ֥뤫Ƥ뤿ˡexportFormȯǤ̵
	 *
	 * @access public
	 * @param int $post_id POST ID
	 * @return null
	 */
	function loadPost2Form($post_id){
	
		if (!$post_id) return null ;
		
		$filter = array(
			'post_id' => new Ethna_AppSearchObject($post_id, OBJECT_CONDITION_EQ),
//			'level' => new Ethna_AppSearchObject(0, OBJECT_CONDITION_GE),
			'post_text' => new Ethna_AppSearchObject('', OBJECT_CONDITION_NE),
		);
		
		$post = $this->getObjectProp('NewbbPosts', null, $filter);
		$post_o = new Xanhte_NewbbPosts(&$this->backend, null, null, $post);
		// Main
		$post_o->exportForm();
		// post_text
		$this->af->set('post_text', $post['post_text']);
		// notification
		$notice = $this->notification->getNotice($post['topic_id'], 'thread', 'new_post');
		if ($notice){
			$this->af->set('notify', 1);
		}
		
	}
	
	
	
	/***
	 * ȥԥåκǽƤȤ
	 *
	 * @access public
	 * @param int $topic_id ȥԥåID
	 * @return array Prop
	 */
	function getTopicRootPost($topic_id){
		
		$filter = array(
			'topic_id' => new Ethna_AppSearchObject($topic_id, OBJECT_CONDITION_EQ),
			'pid' => new Ethna_AppSearchObject(0, OBJECT_CONDITION_EQ),
		);
		$root_post = $this->getObjectProp('NewbbPosts', null, $filter);
		return $root_post ;
	}


	/***
	 * ƤȥԥåIDǳع¤ǼФ
	 *
	 * array( array('prefix'=>'0', 'title'=>'cate1'), array('prefix'=>'1', 'title'=>'cate2'.....),
	 * @access public
	 * @param int    $topic_id ȥԥåID
	 * @param int    no use
	 * @param array  no use
	 * @param string no use
	 * @return object or array
	 */
	function getNewbbPostTreeArray($topic_id, $prefix_str='.', $pid=0, $tree=array(), $prefix=''){
		
		$filter = array(
			'pid'=> new Ethna_AppSearchObject($pid, OBJECT_CONDITION_EQ),
			'topic_id'=> new Ethna_AppSearchObject($topic_id, OBJECT_CONDITION_EQ)
			);
		$order = array('post_time' => OBJECT_SORT_ASC);
		$prop = $this->getObjectPropList('NewbbPosts', null, $filter, $order);
        
        if($prop[0] == 0){
			return $tree ;
        } else {
			foreach ($prop[1] as $key=>$property) {
				$property['prefix'] = $prefix.$prefix_str ;
				$tree[] = $property ;
				$tree = $this->getNewbbPostTreeArray($topic_id, $prefix_str, $property['post_id'], $tree, $property['prefix']);
			}
		}
		return $tree ;
	}
	
	
	/***
	 * IDǲڡܤ
	 *
	 * @access public
	 * @param int    $post_id ID
	 * @return object or array
	 */
	function getPostOffset($post_id){
		
		$asc = $this->af->get('postorder')=='DESC' ? OBJECT_SORT_DESC : OBJECT_SORT_ASC;
		$order = array('post_time'=> $asc);
		
		$condition = $this->af->get('postorder')=='DESC' ? OBJECT_CONDITION_GT : OBJECT_CONDITION_LT ;
		$post = new Xanhte_NewbbPosts(&$this->backend, 'post_id', $post_id);
		$filter = array(
			'post_time' => new Ethna_AppSearchObject($post->get('post_time'), $condition),
			'topic_id'  => new Ethna_AppSearchObject($post->get('topic_id'), OBJECT_CONDITION_EQ)
			);
		
		$postnum = $this->getObjectPropList('NewbbPosts', 'post_id', $filter, $order);
		
		return $postnum[0] ;
	}
	
	/**
	 * ȥԥåIDǤNotificationϿƻΥץν˻ȤäƤޤ
	 *
	 * @param int $topic_id ȥԥåID
	 * @access public
	 * @return 0 or Ethna_Error
	 */
	function registerNotification($topic_id, $category='thread', $event='new_post'){
	
		$ret = 0;
		
		$reg_notice = $this->notification->getNotice($topic_id, $category, $event);
		
		if (is_null($reg_notice) && $this->af->get('notify')){ // register
			$not_prop = array(
				'not_id'		=> '',
				'not_modid'		=> $this->mod->getMid(),
				'not_itemid'	=> $topic_id,
				'not_category'	=> $category,
				'not_event'		=> $event,
				'not_uid'		=> $this->user->getUid(),
				'not_mode'		=> 0,
			);
			$method = 'add' ;
		} elseif (!is_null($reg_notice) && !$this->af->get('notify')){ // unregister
			$not_prop = $reg_notice ;
			$method = 'remove';
		}
		
		if (isset($not_prop) && isset($method)){
			$notify =& new Xanhte_Notification(&$this->backend, null, null, $not_prop);
			$ret = $notify->$method();
		}
		
		return $ret ;
	}
	
	
	
	
	/**
	 * searchη̤֤
	 *
	 * @access public
	 * @param array  $query ʸ
	 * @param int    $start եå
	 * @param int    $limit 
	 * @param string $andor 
	 * @param int    $uid   桼ID
	 * @param int    $forum_id   եID
	 * @param array  $search_field оݥե
	 * @param array  $order ɽ
	 * @return array 
	 */
	function searchPosts($query, $start, $limit, $andor,
						 $uid=false,
						 $forum_id=false,
						 $search_field=array('post_text', 'subject'),
						 $order = array('post_time' => OBJECT_SORT_DESC) ){
		
		$cond = strtoupper($andor)=='AND' ? OBJECT_CONDITION_AND : OBJECT_CONDITION_OR ;
		if (is_array($query)){
			$query = implode(' ', $query);
		}
		$filter = array();
		if (trim($query)){
			$so =& Xanhte_Util::getFilterbySearchWord($query, $search_field, $cond);
			$filter['post_id'] = $so;
		}
		if ($uid && $uid!==-1){
			$filter['uid'] = new Ethna_AppSearchObject($uid, OBJECT_CONDITION_EQ);
		}
		if ($forum_id){
			$filter['forum_id'] = new Ethna_AppSearchObject($forum_id, OBJECT_CONDITION_EQ);
		}
		
		$posts = $this->getObjectPropList('NewbbPosts', null, $filter, $order, $start, $limit);
		
		if (Ethna::isError($posts)){
			$posts = array();
		}
		
		foreach($posts[1] as $key=>$p){
			$posts[1][$key]['title'] = $p['subject'];
			$posts[1][$key]['time'] = $p['post_time'];
			$posts[1][$key]['link'] = sprintf('viewtopic.php?post_id=%d&amp;topic_id=%d&amp;forum_id=%d#forumpost%d', $p['post_id'], $p['topic_id'], $p['forum_id'], $p['post_id']);
		}
		
		return $posts[1];
	}
	
	
	
	
	/**
	 * notificationǻȤ$tag
	 *
	 * @access public
	 * @param object $post_text NewbbPostsText֥
	 * @param object $post NewbbPosts֥
	 * @param object $topic NewbbTopic֥
	 * @param object $forum NewbbForum֥
	 * @return array $tag
	 */
	function getNotificationTag($post_text, $post, $topic, $forum){
		// Define tags for notification message
		$tags = array();
		$tags['THREAD_NAME'] = $topic->get('topic_title');
		$tags['THREAD_URL'] = sprintf('%s/modules/%s/viewtopic.php?forum_id=%d&post_id=%d&topic_id=%d',
									  XOOPS_URL, $this->mod->getModuleDirname(), $forum->get('forum_id'), $post->get('post_id'), $post->get('topic_id'));
		$tags['POST_URL'] = $tags['THREAD_URL'] . '#forumpost' . $post->get('post_id');
		$tags['POST_CONTENT'] = $post_text->get('post_text');
		$tags['POST_NAME'] = $post->get('subject');
		$tags['FORUM_NAME'] = $forum->get('forum_name');
		$tags['FORUM_URL'] = sprintf('%s/modules/%s/viewforum.php?forum_id=%d', XOOPS_URL,  $this->mod->getModuleDirname(), $forum->get('forum_id'));
		$tags['EDITOR'] = $this->user->getUname();
		
		return $tags ;
	}

}
// }}}

// {{{ Xanhte_Posts
/**
 *	XanhteץꥱΥ桼饹
 *
 *	@author		Masaki Fujimoto <fujimoto@php.net>
 *	@access		public
 *	@package	Sample
 */
class Xanhte_NewbbPosts extends Xanhte_AppObject
{
	/**#@+
	 *	@access	private
	 */

	/**
	 *	@var	array	ơ֥
	 */
        var $table_def = array(
			'bb_posts' => array(
				'primary' => true 
				)
			);
	
        var $prop_def = array(
			'post_id'=> array(
				'primary' => true,
				'key' => true,
				'seq' => true,
				'type' => VAR_TYPE_INT,
				'form_name' => 'post_id',
				'prop_name' => 'ID' ,
				),
			'pid'=> array(
				'primary' => false,
				'key' => true,
				'type' => VAR_TYPE_INT,
				'form_name' => 'pid',
				'prop_name' => 'ƤΰѸID' ,
				),
			'topic_id'=> array(
				'primary' => false,
				'key' => false,
				'type' => VAR_TYPE_INT,
				'form_name' => 'topic_id',
				'prop_name' => 'ȥԥåID' ,
				),
			'forum_id'=> array(
				'primary' => false,
				'key' => false,
				'type' => VAR_TYPE_INT,
				'form_name' => 'forum_id',
				'prop_name' => 'եID' ,
				),
			'post_time'=> array(
				'primary' => false,
				'key' => false,
				'type' => VAR_TYPE_INT,
				'form_name' => 'post_time',
				'prop_name' => '' ,
				),
			'uid'=> array(
				'primary' => false,
				'key' => false,
				'type' => VAR_TYPE_INT,
				'form_name' => 'uid',
				'prop_name' => '' ,
				),
			'poster_ip'=> array(
				'primary' => false,
				'key' => false,
				'type' => VAR_TYPE_INT,
				'form_name' => 'poster_ip',
				'prop_name' => '' ,
				),
			'subject'=> array(
				'primary' => false,
				'key' => false,
				'type' => VAR_TYPE_STRING,
				'form_name' => 'subject',
				'prop_name' => '' ,
				),
			'nohtml'=> array(
				'primary' => false,
				'key' => false,
				'type' => VAR_TYPE_INT,
				'form_name' => 'nohtml',
				'prop_name' => '' ,
				),
			'nosmiley'=> array(
				'primary' => false,
				'key' => false,
				'type' => VAR_TYPE_INT,
				'form_name' => 'nosmiley',
				'prop_name' => '' ,
				),
			'icon'=> array(
				'primary' => false,
				'key' => false,
				'type' => VAR_TYPE_INT,
				'form_name' => 'icon',
				'prop_name' => '' ,
				),
			'attachsig'=> array(
				'primary' => false,
				'key' => false,
				'type' => VAR_TYPE_INT,
				'form_name' => 'attachsig',
				'prop_name' => '' ,
				),
			);
	
	/**#@-*/	    
	
	/**#@-*/
	
	/**
	 *	Xeblog_Entry饹Υ󥹥ȥ饯
	 *
	 *	@access	public
	 *	@param	object	Ethna_Backend	&$backend	Ethna_Backend֥
	 *	@param	mixed	$key_type					
	 *	@param	mixed	$key						
	 *	@param	array	$prop						ץѥƥ
	 */
	function Xanhte_NewbbPosts(&$backend, $key_type = null, $key = null, $prop = null)
	{
		$this->Xanhte_AppObject(&$backend, $key_type, $key, $prop);
	    // ֥ȼԤϤ˵Ҥޤ
	}

	
	/**
	 * ֥ȸSQLץ饰(ɲþ)
	 *
	 * sample:
	 * <code>
	 * $search_prop_def = array(
	 * 'group_id' => array(
	 * 'primary' => true, 'key' => true, 'type' => VAR_TYPE_INT,
	 * 'form_name' => 'group_id', 'table' => 'group_user_tbl',
	 * ),
	 * );
	 * return $search_prop_def;
	 * </code>
	 *
	 * @access protected
	 * @return array ɲþ
	 */
	function _SQLPlugin_SearchPropDef(){
		$search_prop_def = array(
			'uname' => 
			array(
				'primary'   => false, 
				'key'       => false, 
				'type'      => VAR_TYPE_STRING,
				'table'     => XOOPS_DB_PREFIX.'_users',
				),
			'posts' => 
			array(
				'primary'   => false, 
				'key'       => false, 
				'type'      => VAR_TYPE_STRING,
				'table'     => XOOPS_DB_PREFIX.'_users',
				),
			'user_sig' => 
			array(
				'primary'   => false, 
				'key'       => false, 
				'type'      => VAR_TYPE_STRING,
				'table'     => XOOPS_DB_PREFIX.'_users',
				),
			'rank' => 
			array(
				'primary'   => false, 
				'key'       => false, 
				'type'      => VAR_TYPE_STRING,
				'table'     => XOOPS_DB_PREFIX.'_users',
				),
			'level' => 
			array(
				'primary'   => false, 
				'key'       => false, 
				'type'      => VAR_TYPE_STRING,
				'table'     => XOOPS_DB_PREFIX.'_users',
				),
			'user_regdate' => 
			array(
				'primary'   => false, 
				'key'       => false, 
				'type'      => VAR_TYPE_STRING,
				'table'     => XOOPS_DB_PREFIX.'_users',
				),
			'user_from' => 
			array(
				'primary'   => false, 
				'key'       => false, 
				'type'      => VAR_TYPE_STRING,
				'table'     => XOOPS_DB_PREFIX.'_users',
				),
			'user_avatar' => 
			array(
				'primary'   => false, 
				'key'       => false, 
				'type'      => VAR_TYPE_STRING,
				'table'     => XOOPS_DB_PREFIX.'_users',
				),
			'post_text' => 
			array(
				'primary'   => false, 
				'key'       => false, 
				'type'      => VAR_TYPE_STRING,
				'table'     => XOOPS_DB_PREFIX.'_bb_posts_text',
				),
			);
			
		return $search_prop_def ;
	}
	

	/**
	 * ֥ȸSQLץ饰(ɲåơ֥)
	 *
	 * sample:
	 * <code>
	 * return " LEFT JOIN bar_tbl ON foo_tbl.user_id=bar_tbl.user_id";
	 * </code>
	 *
	 * @access protected
	 * @return string ơ֥JOINSQLʸ
	 */

	 
	function _SQLPlugin_SearchTable(){
		
		global $xoopsDB;
		
		return sprintf("LEFT JOIN %s ON %s.uid=%s.uid LEFT JOIN %s ON %s.post_id=%s.post_id ",
					   $xoopsDB->prefix('users'), $xoopsDB->prefix('bb_posts'), $xoopsDB->prefix('users'),
					   $xoopsDB->prefix('bb_posts_text'), $xoopsDB->prefix('bb_posts'), $xoopsDB->prefix('bb_posts_text')
					   );
	}
	
	
	
	
	function exportForm(){
		parent::exportForm();
		if (!$this->get('icon')){
			$this->set('icon', 'icon1.gif');
		}
	}
	
	
	function importForm($opt){
		parent::importForm($opt);
		
		if (!$this->get('post_time')){
			$this->set('post_time', time());
		}
		if (!$this->get('poster_ip')){
			$this->set('poster_ip', $_SERVER['REMOTE_ADDR']);
		}
		if (!$this->get('uid')){
			$this->set('uid', $this->user->getUid());
		}
		if (!$this->get('icon')){
			$this->set('icon', 'icon1.gif');
		}
		// no posts
		foreach (array('nohtml', 'nosmiley', 'attachsig') as $k){
			if (!$this->get($k)){
				$this->set($k, 0);
			}
		}
	}

}
// }}}

?>
