<?php
// vim: foldmethod=marker
/**
 *	
 *
 *	@author		ITOH Takashi
 *	@package	Sample
 *	@version	$Id: Sample_Rss.php,v 1.1 2005/01/23 13:46:58 masaki-f Exp $
 */

// {{{ Xanhte_NewbbForumMods
/**
 *	XanhteץꥱΥ桼饹
 *
 *	@author		ITOH Takashi
 *	@access		public
 *	@package	Sample
 */

class Xanhte_NewbbForumModsManager extends Xanhte_AppManager
{
	
	/***
	 *	 եǥ졼ɲ
	 * @access public
	 * @param int $forum_id եID
	 * @param array $forum_mods եΥǥ졼
	 * @return bool
	 */
	function addModerator($forum_id, $forum_mods){
	
		if (!$forum_id) return false ;
		
		foreach ($forum_mods as $user_id){
			$forum_mod = new Xanhte_NewbbForumMods(&$this->backend);
			$forum_mod->set('user_id', $user_id);
			$forum_mod->set('forum_id', $forum_id);
			if ($forum_mod->add()!==0){
				return false ;
			}
		}
		
		return true ;
	}
	
	
	
	/***
	 *	եǥ졼Υåץǡ
	 * @access public
	 * @param int $forum_id եID
	 * @param array $forum_mods եΥǥ졼
	 * @return bool
	 */
	function updateModerator($forum_id, $forum_mods){
	
		global $xoopsDB;
	
		if (!$forum_id) return false ;
		
		$db =& $this->backend->getDB();
		$sql = sprintf('delete from %s where forum_id=%d', $xoopsDB->prefix('bb_forum_mods'), $forum_id) ;
		if (Ethna::isError($db->query($sql))) {
			return false ;
		}
		
		return $this->addModerator($forum_id, $forum_mods);
	}
	
	
	
	/***
	 * եǥ졼getObjectPropList֤
	 * @access public
	 * @param int $forum_id եID
	 * @return array
	 */
	function getModsByForumId($forum_id){
		$ret = array();
		
		if (!$forum_id) return $ret ;
		
		$filter = array(
			'forum_id' => new Ethna_AppSearchObject($forum_id, OBJECT_CONDITION_EQ),
			'level' =>  new Ethna_AppSearchObject(0, OBJECT_CONDITION_NE),
			);
		$order = array('user_id' => OBJECT_SORT_ASC);
		$ret = $this->getObjectPropList('NewbbForumMods', null, $filter, $order);
		
		return $ret ;
	}
	
	
	
	/***
	 * եǥ졼array('1'=>'misc', '2'=>'asc')Ȥ֤
	 * @access public
	 * @param int $forum_id եID
	 * @return array
	 */
	function getModsArrayByForumId($forum_id){
		$ret = array();
		
		if (!$forum_id) return $ret ;
		
		$filter = array('forum_id' => new Ethna_AppSearchObject($forum_id, OBJECT_CONDITION_EQ));
		$order = array('user_id' => OBJECT_SORT_ASC);
		$user = $this->getObjectPropList('NewbbForumMods', 'user_id', $filter, $order);
		foreach ($user[1] as $u){
			$ret[] = $u['user_id'] ;
		}
		return $ret ;
	}
	
	/***
	 * եIDȥ桼IDǥǥ졼ɤå
	 *
	 * @access public
	 * @param int $forum_id եID
	 * @param int $uid 桼 ID
	 * @return array
	 */
	function isModerator($forum_id, $uid){
		
		$filter = array(
			'forum_id' => new Ethna_AppSearchObject($forum_id, OBJECT_CONDITION_EQ),
			'user_id' => new Ethna_AppSearchObject($uid, OBJECT_CONDITION_EQ),
		);
		
		$ret = $this->getObjectProp('NewbbForumMods', null, $filter);
		return $ret['user_id'] ? true : false ;
	}
	
	
}
// }}}

// {{{ Xanhte_ForumMods
/**
 *	XanhteץꥱΥ桼饹
 *
 *	@author		Masaki Fujimoto <fujimoto@php.net>
 *	@access		public
 *	@package	Sample
 */
class Xanhte_NewbbForumMods extends Xanhte_AppObject
{
	/**#@+
	 *	@access	private
	 */

	/**
	 *	@var	array	ơ֥
	 */
        var $table_def = array(
			'bb_forum_mods' => array(
				'primary' => true 
				)
			);
	
        var $prop_def = array(
			'forum_id'=> array(
				'primary' => true,
				'key' => false,
				'type' => VAR_TYPE_INT,
				'form_name' => 'forum_id',
				'prop_name' => 'forum ID' ,
				),
			'user_id'=> array(
				'primary' => true,
				'key' => false,
				'type' => VAR_TYPE_INT,
				'form_name' => 'user_id',
				'prop_name' => 'user ID' ,
				),
			);
	
	/**#@-*/	    
	
	/**#@-*/
	
	/**
	 *	Xeblog_Entry饹Υ󥹥ȥ饯
	 *
	 *	@access	public
	 *	@param	object	Ethna_Backend	&$backend	Ethna_Backend֥
	 *	@param	mixed	$key_type					
	 *	@param	mixed	$key						
	 *	@param	array	$prop						ץѥƥ
	 */
	function Xanhte_NewbbForumMods(&$backend, $key_type = null, $key = null, $prop = null)
	{
		$this->Xanhte_AppObject(&$backend, $key_type, $key, $prop);
	    // ֥ȼԤϤ˵Ҥޤ
	}
	
			
	/**
	 * ֥ȸSQLץ饰(ɲþ)
	 *
	 * sample:
	 * <code>
	 * $search_prop_def = array(
	 * 'group_id' => array(
	 * 'primary' => true, 'key' => true, 'type' => VAR_TYPE_INT,
	 * 'form_name' => 'group_id', 'table' => 'group_user_tbl',
	 * ),
	 * );
	 * return $search_prop_def;
	 * </code>
	 *
	 * @access protected
	 * @return array ɲþ
	 */
	function _SQLPlugin_SearchPropDef(){
		$search_prop_def = array(
			'uname' => 
			array(
				'primary'   => false, 
				'key'       => false, 
				'type'      => VAR_TYPE_STRING,
				'table'     => XOOPS_DB_PREFIX.'_users',
				),
			'level' => 
			array(
				'primary'   => false, 
				'key'       => false, 
				'type'      => VAR_TYPE_STRING,
				'table'     => XOOPS_DB_PREFIX.'_users',
				),
			);
			
		return $search_prop_def ;
	}
	

	/**
	 * ֥ȸSQLץ饰(ɲåơ֥)
	 *
	 * sample:
	 * <code>
	 * return " LEFT JOIN bar_tbl ON foo_tbl.user_id=bar_tbl.user_id";
	 * </code>
	 *
	 * @access protected
	 * @return string ơ֥JOINSQLʸ
	 */

	 
	function _SQLPlugin_SearchTable(){
		
		global $xoopsDB;
		
		return sprintf("LEFT JOIN %s ON user_id=uid", $xoopsDB->prefix('users'));
	}

}
// }}}

?>
