<?php
// vim: foldmethod=marker
/**
CREATE TABLE bb_forum_access (

  forum_id int(4) unsigned NOT NULL default '0',

  user_id int(5) unsigned NOT NULL default '0',

  can_post tinyint(1) NOT NULL default '0',

  PRIMARY KEY  (forum_id,user_id)

) TYPE=MyISAM;

 *	
 *
 *	@author		ITOH Takashi
 *	@package	Sample
 *	@version	$Id: Sample_Rss.php,v 1.1 2005/01/23 13:46:58 masaki-f Exp $
 */

// {{{ Xanhte_NewbbForumAccess
/**
 *	XanhteץꥱΥ桼饹
 *
 *	@author		ITOH Takashi
 *	@access		public
 *	@package	Sample
 */

class Xanhte_NewbbForumAccessManager extends Xanhte_AppManager
{
	
	/***
	 *  桼ɲ
	 * @access public
	 * @param int $forum_id եID
	 * @param int $user_id 桼ID
	 * @return bool
	 */
	function addForumAccess($forum_id, $user_id){
		$forum_access = new Xanhte_NewbbForumAccess(&$this->backend);
		$forum_access->set('forum_id', $forum_id);
		$forum_access->set('user_id', $user_id);
		return $forum_access->add()===0 ? true : false ;
	}
	
	
	/***
	 *  桼θѹ
	 * @access public
	 * @param int $forum_id եID
	 * @param int $user_id 桼ID
	 * @return bool
	 */
	function flipForumAccess($forum_id, $user_id){
		$forum_access = new Xanhte_NewbbForumAccess(&$this->backend, array('forum_id', 'user_id'), array($forum_id, $user_id));
		$forum_access->set('can_post', $forum_access->get('can_post')==0?1:0);
		$forum_access->update();
	}
	
	/***
	 *  桼κ
	 * @access public
	 * @param int $forum_id եID
	 * @param int $user_id 桼ID
	 * @return bool
	 */
	function deleteForumAccess($forum_id, $user_id){
		$forum_access = new Xanhte_NewbbForumAccess(&$this->backend, array('forum_id', 'user_id'), array($forum_id, $user_id));
		$forum_access->remove();
	}
	
	
	/***
	 *  桼κ
	 * @access public
	 * @param int $forum_id եID
	 * @return mixed :Ethna_Error or :DB_Result
	 */
	function clearForumAccessByForumId($forum_id){
		global $xoopsDB;
		
		$db =& $this->backend->getDB();
		$sql = sprintf('delete from %s where forum_id=%d', $xoopsDB->prefix('bb_forum_access'), $forum_id);
		$db->query($sql);
	}
	
	/***
	 * ǽ桼եIDǼ
	 * @access public
	 * @param int $forum_id եID
	 * @return array $user 桼ID
	 */
	function getAllowUserByForumId($forum_id){
		
		$user = array();
		
		if (!$forum_id) return $user ;
		
		$order = array('user_id' => OBJECT_SORT_ASC);
		$filter = array(
			'forum_id' => new Ethna_AppSearchObject($forum_id, OBJECT_CONDITION_EQ),
			'level' => new Ethna_AppSearchObject(0, OBJECT_CONDITION_GT),
			);
		$user = $this->getObjectPropList('NewbbForumAccess', null, $filter, $order);
		
		return $user;
	}
	
	/***
	 * ¥å
	 * @access public
	 * @param int $user_id 桼ID
	 * @param int $forum_id եID
	 * @param bool $isWrite trueʤ񤭹߸¤å
	 * @return bool
	 */
	function checkPrivilege($user_id, $forum_id, $isWrite=false ){
		
		$access = new Xanhte_NewbbForumAccess(&$this->backend, array('user_id', 'forum_id'), array($user_id, $forum_id));
		
		if ($isWrite){
			return $access->get('can_post')==1 ? true : false ; 
		}
		return $access->get('user_id') ? true : false ;
	}
	
	

}
// }}}

// {{{ Xanhte_ForumAccess
/**
 *	XanhteץꥱΥ桼饹
 *
 *	@author		Masaki Fujimoto <fujimoto@php.net>
 *	@access		public
 *	@package	Sample
 */
class Xanhte_NewbbForumAccess extends Xanhte_AppObject
{
	/**#@+
	 *	@access	private
	 */

	/**
	 *	@var	array	ơ֥
	 */
        var $table_def = array(
			'bb_forum_access' => array(
				'primary' => true 
				)
			);
	
        var $prop_def = array(
			'forum_id'=> array(
				'primary' => true,
				'key' => false,
				'type' => VAR_TYPE_INT,
				'form_name' => 'forum_id',
				'prop_name' => 'forum ID' ,
				),
			'user_id'=> array(
				'primary' => true,
				'key' => false,
				'type' => VAR_TYPE_INT,
				'form_name' => 'user_id',
				'prop_name' => 'user ID' ,
				),
			'can_post'=> array(
				'primary' => false,
				'key' => false,
				'type' => VAR_TYPE_INT,
				'form_name' => 'can_post',
				'prop_name' => 'Ƥβ' ,
				),
			);
	
	/**#@-*/	    
	
	/**#@-*/
	
	/**
	 *	Xeblog_Entry饹Υ󥹥ȥ饯
	 *
	 *	@access	public
	 *	@param	object	Ethna_Backend	&$backend	Ethna_Backend֥
	 *	@param	mixed	$key_type					
	 *	@param	mixed	$key						
	 *	@param	array	$prop						ץѥƥ
	 */
	function Xanhte_NewbbForumAccess(&$backend, $key_type = null, $key = null, $prop = null)
	{
		$this->Xanhte_AppObject(&$backend, $key_type, $key, $prop);
	    // ֥ȼԤϤ˵Ҥޤ
	}
	
	
		
	/**
	 * ֥ȸSQLץ饰(ɲþ)
	 *
	 * sample:
	 * <code>
	 * $search_prop_def = array(
	 * 'group_id' => array(
	 * 'primary' => true, 'key' => true, 'type' => VAR_TYPE_INT,
	 * 'form_name' => 'group_id', 'table' => 'group_user_tbl',
	 * ),
	 * );
	 * return $search_prop_def;
	 * </code>
	 *
	 * @access protected
	 * @return array ɲþ
	 */
	function _SQLPlugin_SearchPropDef(){
		$search_prop_def = array(
			'uname' => 
			array(
				'primary'   => false, 
				'key'       => false, 
				'type'      => VAR_TYPE_STRING,
				'table'     => XOOPS_DB_PREFIX.'_users',
				),
			'level' => 
			array(
				'primary'   => false, 
				'key'       => false, 
				'type'      => VAR_TYPE_STRING,
				'table'     => XOOPS_DB_PREFIX.'_users',
				),
			);
			
		return $search_prop_def ;
	}
	

	/**
	 * ֥ȸSQLץ饰(ɲåơ֥)
	 *
	 * sample:
	 * <code>
	 * return " LEFT JOIN bar_tbl ON foo_tbl.user_id=bar_tbl.user_id";
	 * </code>
	 *
	 * @access protected
	 * @return string ơ֥JOINSQLʸ
	 */

	 
	function _SQLPlugin_SearchTable(){
		
		global $xoopsDB;
		
		return sprintf("LEFT JOIN %s ON user_id=uid", $xoopsDB->prefix('users'));
	}


}
// }}}

?>
