<?php
// vim: foldmethod=marker
/**
 *	
 *
 *	@author		ITOH Takashi
 *	@package	Sample
 *	@version	$Id: Sample_Rss.php,v 1.1 2005/01/23 13:46:58 masaki-f Exp $
 */

// {{{ Xanhte_NewbbForum
/**
 *	XanhteץꥱΥ桼饹
 *
 *	@author		ITOH Takashi
 *	@access		public
 *	@package	Sample
 */

class Xanhte_NewbbForumManager extends Xanhte_AppManager
{
	
	/**#@+
	 *	@access	private
	 */

	/**	@var	array	եΥå */
	var $__cache_forum ;  
	
	
	
	
	/***
	 *	// եɲ
	 * @access public
	 * @param string $cat_title եΥȥ
	 * @return mixed =>ե४֥  =>false
	 */
	function addForum(){
		// get Max order
		$forum = new Xanhte_NewbbForum(&$this->backend);
		$forum->importForm(OBJECT_IMPORT_IGNORE_NULL);
		if( $forum->add() === 0 ){
			$ret = $forum ;
			// Moderatorɲ
			$this->newbbFM->addModerator($forum->get('forum_id'), $this->af->get('forum_mods'));
		}else{
			$ret = false ;
		}
		
		return $ret ;
	}
	
	/***
	 *	// եΥåץǡ
	 * @access public
	 * @param int $cat_id եID
	 * @param string $cat_title եΥȥ
	 * @return array $prop ץѥƥ
	 */
	function updateForum($forum_id){
		// get cat_obj
		$forum = new Xanhte_NewbbForum(&$this->backend, 'forum_id', $forum_id);
		$forum->importForm(OBJECT_IMPORT_IGNORE_NULL);
		if( $forum->update() === 0 ){
			$ret = true ;
			// Moderatorѹ
			$this->newbbFM->updateModerator($forum->get('forum_id'), $this->af->get('forum_mods'));			
		}else{
			$ret = false ;
		}
		
		return $ret ;
	}
	
	
	/***
	 * եκ
	 * @access public
	 * @param int $forum_id եID
	 *	@return	mixed	DB_Result:̥֥ Ethna_Error:顼	 
	 */
	function removeForumByForumId($forum_id){
		
		global $xoopsDB;
		
		$forum = new Xanhte_NewbbForum(&$this->backend, 'forum_id', $forum_id);
		
		if ($forum->remove()===0){
			$db =& $this->backend->getDB();
			$sql = sprintf('delete from %s where forum_id=%d', $xoopsDB->prefix('bb_forum_access'), $forum_id) ;
			if (!Ethna::isError($db->query($sql))) {
				$sql = sprintf('delete from %s where forum_id=%d', $xoopsDB->prefix('bb_forum_mods'), $forum_id) ;
				return $db->query($sql);
			}
		}
		
		return false ;
	}
	
	
	/***
	 * եࡼarray('1'=>'misc', '2'=>'asc')Ȥ֤
	 * @access public
	 * @return array
	 */
	function getForumArray(){
		$filter = array();
		$order = array('forum_id'=>'ASC');
		$cats =& $this->getObjectPropList('NewbbForum', array('forum_id','forum_name'), $filter, $order);
		$ret = array();
		foreach($cats[1] as $key=>$value){
			$ret[$value['forum_id']] = $value['forum_name'];
		}
		return $ret ;
	}
	
	
	
	/***
	 * ƥIDǥեȤ
	 * @access public
	 * @param int $cat_id ƥID
	 * @param int $with_mods ǥ졼뤫
	 * @return array $prop ץѥƥ
	 */
	function getForumsByCategoryId($cat_id, $with_mods=false){
		$filter = array('cat_id' => new Ethna_AppSearchObject($cat_id, OBJECT_CONDITION_EQ));
		$order = array('forum_id' => OBJECT_SORT_ASC);
		$forums = $this->getObjectPropList('NewbbForum', null, $filter, $order);
		if (Ethna::isError($forums) || !isset($forums[1][0])){
			return array();
		}
		
		if ($with_mods){
			foreach ($forums[1] as $key=>$f){
				$tmp = $this->newbbFM->getModsByForumId($f['forum_id']);
				$forums[1][$key]['mods'] = $tmp[1];
				$forums[1][$key]['last_post'] = $this->getLastPost($f['forum_id']) ;
			}
		}

		return $forums[1] ;
	}
	
	
	/***
	 * եIDǥץ饤١ȥեޤƥեΥå
	 * @access public
	 * @param int $topic_id եID
	 * @param bool $isWrite trueʤ񤭹߸¤θ֤
	 * @return bool
	 */
	function checkPrivilegeByForumId($forum_id, $isWrite=true){
		
		if ($this->user->isSiteAdmin()) return true ; // ȴԤOK
		
//		$forum = new Xanhte_NewbbForum(&$this->backend, 'forum_id', $forum_id);
		$forum = $this->_getForumByForumId($forum_id);
		$uid = $this->user->getUid();
		
		if ($forum['forum_type']==1){ 
			// private forum
			$user_id = $this->user->getUid();
			return $this->newbbFA->checkPrivilege($user_id, $forum_id, $isWrite);
		}
		
		if ($isWrite){
			return $uid ? true : false ;
		}
		return true ;
	}
	
	
	
	/***
	 * ȥԥåIDǥե
	 * @access public
	 * @param int $topic_id ȥԥåID
	 * @return object եobject
	 */
	function getForumByTopicId($topic_id){
		
		$topic = new Xanhte_NewbbTopics(&$this->backend, 'topic_id', $topic_id);
		
		$forum = new Xanhte_NewbbForum(&$this->backend, 'forum_id', $topic->get('forum_id'));
		
		return $forum ;
	}

	
	/***
	 * IDǥե
	 * @access public
	 * @param int $post_id ID
	 * @return object եobject
	 */
	function getForumByPostId($post_id){
		
		$post = new Xanhte_NewbbPosts(&$this->backend, 'post_id', $post_id);
		
		$forum = $this->getForumByTopicId($post->get('topic_id'));
		
		return $forum ;
	}

	
	/***
	 * եIDǾȤ
	 * @access public
	 * @param int $forum_id եID
	 * @param int $with_mods ǥ졼뤫
	 * @return array $prop եΥץѥƥ
	 */
	function getForumImfomation($forum_id){
		
		$ret = array();
		
		$ret = $this->_getForumByForumId($forum_id);
		
		
		// Moderators
		$tmp = $this->newbbFM->getModsByForumId($forum_id);
		$ret['mods'] = $tmp[1] ;

		return $ret ;
	}
	
	
	/***
	 * եIDǾȤ
	 * @access public
	 * @param int $forum_id եID
	 * @return string $forum_name ե̾
	 */
	function getForumnameByForumId($forum_id){
		
		$forum_prop = $this->_getForumByForumId($forum_id);
		
		return $forum_prop['forum_name'] ;
	}
	
	
	/***
	 * եκǽƾȤ
	 *
	 * @access public
	 * @param int $forum_id եID
	 * @return array $prop йԾΰ
	 */
	function getLastPost($forum_id){
		
		
		$filter = array(
			'uname' => new Ethna_AppSearchObject('', OBJECT_CONDITION_NE),
			'forum_id' => new Ethna_AppSearchObject($forum_id, OBJECT_CONDITION_EQ),
			);
		$order = array('post_time' => OBJECT_SORT_DESC);
		$last_post = $this->newbbP->getObjectPropList('NewbbPosts', null, $filter, $order , 0, 1);
		
		return isset($last_post[1][0]) ? $last_post[1][0] : array() ;
	}
	
	
	/***
	 * Ǥե
	 *
	 * @access public
	 * @param bool $flip ưž(Ǥʤե)
	 * @param bool $isPrivate ץ饤١ȥեΤߤ
	 * @return array եΰ
	 */
	function getReadableForum($flip=false, $isPrivate=false){
		
		if ($flip && $this->user->isSiteAdmin()){ 
			// ȴԤɤʤե̵
			return array();
			
		} else if (!$this->user->isSiteAdmin()){
			$uid = $this->user->getUid();
			$filter = array();
			if ($flip==false){
				$so = new Ethna_AppSearchObject($uid, OBJECT_CONDITION_EQ); // bb_forum_access.user_id = $uid
				$so->addObject('forum_type', new Ethna_AppSearchObject(0, OBJECT_CONDITION_EQ), OBJECT_CONDITION_OR);
				$filter['user_id'] = $so ;
			} else {
				$uid and $filter['user_id'] = new Ethna_AppSearchObject($uid, OBJECT_CONDITION_NE); // bb_forum_access.user_id = $uid
				$filter['forum_type'] = new Ethna_AppSearchObject(1, OBJECT_CONDITION_EQ);
			}
		} else {
			// ȴԤϤɤΥեǽ
			$filter = array();
		}
		
		// ץ饤١ȥ⡼ɸ
		if ($isPrivate){
			$filter['forum_type'] = new Ethna_AppSearchObject(1, OBJECT_CONDITION_EQ);
		}
		
		$forums = $this->getObjectPropList('NewbbForum', null, $filter);
		
		if (Ethna::isError($forums)){
			return array();
		}
		
		return $forums[1] ;
	}

	/***
	 * եIDǥեȤ
	 * @access private
	 * @param int $forum_id եID
	 * @return arrary եΥץѥƥ
	 */
	function _getForumByForumId($forum_id){
		
		if (!isset($this->__cache_forum[$forum_id])){
			$forum = new Xanhte_NewbbForum(&$this->backend, 'forum_id', $forum_id);
			$this->__cache_forum[$forum_id] = $forum->prop ;
		}
		
		return $this->__cache_forum[$forum_id] ;
	}

}
// }}}

// {{{ Xanhte_Forum
/**
 *	XanhteץꥱΥ桼饹
 *
 *	@author		Masaki Fujimoto <fujimoto@php.net>
 *	@access		public
 *	@package	Sample
 */
class Xanhte_NewbbForum extends Xanhte_AppObject
{
	/**#@+
	 *	@access	private
	 */

	/**
	 *	@var	array	ơ֥
	 */
        var $table_def = array(
			'bb_forums' => array(
				'primary' => true 
				)
			);
	
        var $prop_def = array(
			'forum_id'=> array(
				'primary' => true,
				'key' => true,
				'seq' => true,
				'type' => VAR_TYPE_INT,
				'form_name' => 'forum_id',
				'prop_name' => 'եID' ,
				),
			'forum_name'=> array(
				'primary' => false,
				'key' => false,
				'type' => VAR_TYPE_STRING,
				'form_name' => 'forum_name',
				'prop_name' => 'ե̾' ,
				),
			'forum_desc'=> array(
				'primary' => false,
				'key' => false,
				'type' => VAR_TYPE_STRING,
				'form_name' => 'forum_desc',
				'prop_name' => 'ե' ,
				),
			'forum_access'=> array(
				'primary' => false,
				'key' => false,
				'type' => VAR_TYPE_INT,
				'form_name' => 'forum_access',
				'prop_name' => 'եॢ' ,
				),
			'forum_moderator'=> array(
				'primary' => false,
				'key' => false,
				'type' => VAR_TYPE_INT,
				'form_name' => 'forum_moderator',
				'prop_name' => 'ե' ,
				),
			'forum_topics'=> array(
				'primary' => false,
				'key' => false,
				'type' => VAR_TYPE_INT,
				'form_name' => 'forum_topics',
				'prop_name' => 'եΥȥԥå' ,
				),
			'forum_posts'=> array(
				'primary' => false,
				'key' => false,
				'type' => VAR_TYPE_INT,
				'form_name' => 'forum_posts',
				'prop_name' => 'եƷ' ,
				),
			'forum_last_post_id'=> array(
				'primary' => false,
				'key' => false,
				'type' => VAR_TYPE_INT,
				'form_name' => 'forum_last_post_id',
				'prop_name' => 'եǽƼ' ,
				),
			'cat_id'=> array(
				'primary' => false,
				'key' => false,
				'type' => VAR_TYPE_INT,
				'form_name' => 'cat_id',
				'prop_name' => 'եΥƥID' ,
				),
			'forum_type'=> array(
				'primary' => false,
				'key' => false,
				'type' => VAR_TYPE_INT,
				'form_name' => 'forum_type',
				'prop_name' => 'եTYPE' ,
				),
			'allow_html'=> array(
				'primary' => false,
				'key' => false,
				'type' => VAR_TYPE_INT,
				'form_name' => 'allow_html',
				'prop_name' => 'եHTMLĤ뤫ɤ' ,
				),
			'allow_sig'=> array(
				'primary' => false,
				'key' => false,
				'type' => VAR_TYPE_INT,
				'form_name' => 'allow_sig',
				'prop_name' => 'եǽ̾Ĥ뤫ɤ' ,
				),
			'posts_per_page'=> array(
				'primary' => false,
				'key' => false,
				'type' => VAR_TYPE_INT,
				'form_name' => 'posts_per_page',
				'prop_name' => 'ե1ڡƿ' ,
				),
			'topics_per_page'=> array(
				'primary' => false,
				'key' => false,
				'type' => VAR_TYPE_INT,
				'form_name' => 'topics_per_page',
				'prop_name' => 'ե1ڡΥȥԥå' ,
				),
			'hot_threshold'=> array(
				'primary' => false,
				'key' => false,
				'type' => VAR_TYPE_INT,
				'form_name' => 'hot_threshold',
				'prop_name' => 'եबۥåȤ' ,
				),
			);
	
	/**#@-*/	    
	
	/**#@-*/
	
	/**
	 *	Xeblog_Entry饹Υ󥹥ȥ饯
	 *
	 *	@access	public
	 *	@param	object	Ethna_Backend	&$backend	Ethna_Backend֥
	 *	@param	mixed	$key_type					
	 *	@param	mixed	$key						
	 *	@param	array	$prop						ץѥƥ
	 */
	function Xanhte_NewbbForum(&$backend, $key_type = null, $key = null, $prop = null)
	{
		$this->Xanhte_AppObject(&$backend, $key_type, $key, $prop);
	    // ֥ȼԤϤ˵Ҥޤ
	}
	
	/**
	 * ֥ȸSQLץ饰(ɲþ)
	 *
	 * sample:
	 * <code>
	 * $search_prop_def = array(
	 * 'group_id' => array(
	 * 'primary' => true, 'key' => true, 'type' => VAR_TYPE_INT,
	 * 'form_name' => 'group_id', 'table' => 'group_user_tbl',
	 * ),
	 * );
	 * return $search_prop_def;
	 * </code>
	 *
	 * @access protected
	 * @return array ɲþ
	 */
	function _SQLPlugin_SearchPropDef(){
		$search_prop_def = array(
			'user_id' => 
			array(
				'primary'   => false, 
				'key'       => false, 
				'type'      => VAR_TYPE_INT,
				'table'     => XOOPS_DB_PREFIX.'_bb_forum_access',
				),
			'can_post' => 
			array(
				'primary'   => false, 
				'key'       => false, 
				'type'      => VAR_TYPE_INT,
				'table'     => XOOPS_DB_PREFIX.'_bb_forum_access',
				),
			);
			
		return $search_prop_def ;
	}
	

	/**
	 * ֥ȸSQLץ饰(ɲåơ֥)
	 *
	 * sample:
	 * <code>
	 * return " LEFT JOIN bar_tbl ON foo_tbl.user_id=bar_tbl.user_id";
	 * </code>
	 *
	 * @access protected
	 * @return string ơ֥JOINSQLʸ
	 */

	 
	function _SQLPlugin_SearchTable(){
		
		global $xoopsDB;
		
		return sprintf("LEFT JOIN %s ON %s.forum_id=%s.forum_id",
					   $xoopsDB->prefix('bb_forum_access'), $xoopsDB->prefix('bb_forums'), $xoopsDB->prefix('bb_forum_access'));
	}


}
// }}}

?>
