<?php
// vim: foldmethod=marker
/**
 *	
 *
 *	@author		ITOH Takashi
 *	@package	Sample
 *	@version	$Id: Sample_Rss.php,v 1.1 2005/01/23 13:46:58 masaki-f Exp $
 */

// {{{ Xanhte_NewbbCategory
/**
 *	XanhteץꥱΥ桼饹
 *
 *	@author		ITOH Takashi
 *	@access		public
 *	@package	Sample
 */

class Xanhte_NewbbCategoryManager extends Xanhte_AppManager
{
	
	/***
	 *	// ƥɲ
	 * @access public
	 * @param string $cat_title ƥΥȥ
	 * @return array $prop ץѥƥ
	 */
	function addCategory($cat_title){
		// get Max order
		$prop = $this->getMaxCategoryOrderProp();
		$cat_order = isset($prop['cat_order']) ? $prop['cat_order'] : 0;
		$prop = array(
			'cat_id' => '',
			'cat_title'=> $cat_title,
			'cat_order' => $cat_order,
			) ;
		$category = new Xanhte_NewbbCategory(&$this->backend, null, null, $prop);
		if( $category->add() === 0 ){
			$ret = intval($category->get('cat_id'));
		}else{
			$ret = false ;
		}
		
		return $ret ;
	}
	
	/***
	 *	// ƥΥåץǡ
	 * @access public
	 * @param int $cat_id ƥID
	 * @param string $cat_title ƥΥȥ
	 * @return array $prop ץѥƥ
	 */
	function updateCategory($cat_id, $cat_title){
		// get cat_obj
		$category = new Xanhte_NewbbCategory(&$this->backend, 'cat_id', $cat_id);
		$category->set('cat_title', $cat_title);

		if( $category->update() === 0 ){
			$ret = true ;
		}else{
			$ret = false ;
		}
		
		return $ret ;
	}
	
	
	
	/***
	 * ƥ꡼array('1'=>'misc', '2'=>'asc')Ȥ֤
	 * @access public
	 * @return array
	 */
	function getCategoryArray(){
		$filter = array();
		$order = array('cat_order'=>'ASC');
		$cats =& $this->getObjectPropList('NewbbCategory', array('cat_id','cat_title'), $filter, $order);
		$ret = array();
		foreach($cats[1] as $key=>$value){
			$ret[$value['cat_id']] = $value['cat_title'];
		}
		return $ret ;
	}

	
	/***
	 * ƥ꡼եȥեκǽƼԾƱ˼
	 * @access public
	 * @param int $cat_id ƥID
	 * @return array
	 */
	function getCategoriesInformation($cat_id){
		$filter = array();
		if ($cat_id){
			$filter = array('cat_id' => new Ethna_AppSearchObject($cat_id, OBJECT_CONDITION_EQ));
		}
		$order = array('cat_order'=>'ASC');
		$cats =& $this->getObjectPropList('NewbbCategory', null, $filter, $order);
		
		foreach ($cats[1] as $key=>$c){
			$cats[1][$key]['forums'] = $this->newbbF->getForumsByCategoryId($c['cat_id'], true);
		}
		return $cats ;
	}
	
	
	
	/***
	 * Ǹ¤ӽΥƥ
	 * @access public
	 * @return array $prop ץѥƥ
	 */
	function getMaxCategoryOrderProp(){
		$filter = array();
		$order = array('cat_order' => OBJECT_SORT_DESC);
		$cat = $this->getObjectPropList('NewbbCategory', null, $filter, $order, 0, 1);
		if (Ethna::isError($cat) || !isset($cat[1][0])){
			return array();
		}
		return $cat[1][0] ;
	}

}
// }}}

// {{{ Xanhte_Category
/**
 *	XanhteץꥱΥ桼饹
 *
 *	@author		Masaki Fujimoto <fujimoto@php.net>
 *	@access		public
 *	@package	Sample
 */
class Xanhte_NewbbCategory extends Xanhte_AppObject
{
	/**#@+
	 *	@access	private
	 */

	/**
	 *	@var	array	ơ֥
	 */
        var $table_def = array(
			'bb_categories' => array(
				'primary' => true 
				)
			);
	
        var $prop_def = array(
			'cat_id'=> array(
				'primary' => true,
				'key' => true,
				'seq' => true,
				'type' => VAR_TYPE_INT,
				'form_name' => 'cat_id',
				'prop_name' => 'ƥID' ,
				),
			'cat_title'=> array(
				'primary' => false,
				'key' => false,
				'type' => VAR_TYPE_STRING,
				'form_name' => 'cat_title',
				'prop_name' => 'ƥ̾' ,
				),
			'cat_order'=> array(
				'primary' => false,
				'key' => false,
				'type' => VAR_TYPE_INT,
				'form_name' => 'cat_order',
				'prop_name' => 'ƥ' ,
				),
			);
	
	/**#@-*/	    
	
	/**#@-*/
	
	/**
	 *	Xeblog_Entry饹Υ󥹥ȥ饯
	 *
	 *	@access	public
	 *	@param	object	Ethna_Backend	&$backend	Ethna_Backend֥
	 *	@param	mixed	$key_type					
	 *	@param	mixed	$key						
	 *	@param	array	$prop						ץѥƥ
	 */
	function Xanhte_NewbbCategory(&$backend, $key_type = null, $key = null, $prop = null)
	{
		$this->Xanhte_AppObject(&$backend, $key_type, $key, $prop);
	    // ֥ȼԤϤ˵Ҥޤ
	}
}
// }}}

?>
