<?php
// vim: foldmethod=marker
/**
 *	Sample_Rss.php
 *
 *	@author		Masaki Fujimoto <fujimoto@php.net>
 *	@package	Sample
 *	@version	$Id: Sample_Rss.php,v 1.1 2005/01/23 13:46:58 masaki-f Exp $
 */

// {{{ Xanhte_RssManager
/**
 *	Xanhteץꥱ󥪥֥Ȥδ쥯饹
 *
 *	@author		Masaki Fujimoto <fujimoto@php.net>
 *	@access		public
 *	@package	Sample
 */

class Xanhte_AppManager extends Ethna_AppManager
{
	function Xanhte_AppManager(&$backend){
		$this->Ethna_AppManager(&$backend) ;
	}
	
	/**
	*  ƥ꡼ĥ꡼¤٤function -> xoopsTree
	*  @access private
	*  @return string Ŭڤʾ
	**/
	var $xoopsTreeObject=null ;
	
	var $nicePath = array();
	
	function _getXoopsTree($table, $id_field, $pid_field){
		global $xoopsDB ;
		if(!class_exists('XoopsTree')){
			require_once XOOPS_ROOT_PATH.'/class/xoopstree.php';
		}
		$this->xoopsTreeObject =& new XoopsTree($xoopsDB->prefix($table), $id_field, $pid_field);
		return null ;
	}
	
	function &getXoopsTree($table, $id_field, $pid_field){
		if(!is_object($this->xoopsTreeObject)){
			$this->_getXoopsTree($table, $id_field, $pid_field);
		}
		return $this->xoopsTreeObject ;
	}
	
	function getChildTreeArray($table, $id_field, $pid_field,    $sel_id=0, $order="", $parray=array(), $r_prefix='--'){
		$xoopstree =& $this->getXoopsTree($table, $id_field, $pid_field);
		$options = $xoopstree->getChildTreeArray($sel_id,$order,$parray,$r_prefix) ;
		return $options;
	}
	
	function getCategorySelbox($table, $id_field, $pid_field, $sel_name='cat_id', $preset_id=0){
		$xoopstree =& $this->getXoopsTree($table, $id_field, $pid_field);
		$order = 'cat_created';
		ob_start();
		$xoopstree->makeMySelBox($title='cat_title',$order,$preset_id, $none=false, $sel_name, $onchange="");
		$selbox = ob_get_contents();
		ob_end_clean();
		return $selbox;
	}
	
	// pididǡpid0ΤΤޤ̤äƼäƤ
	function &getTreeNicePath($class, $id, $parray=array(), $id_field='id', $pid_field='pid'){
		$class_name = sprintf("%s_%s", $this->backend->getAppId(), $class);
		$parent = new $class_name(&$this->backend, $id_field, $id) ;
		array_push($parray , $parent);
		$parent_pid = $parent->get($pid_field);
		if($parent_pid == 0){
			return $parray ;
		}else{
			if($parent_pid == $id){
				return false ; // ʽλ
			}else{
				$parray = $this->getTreeNicePath($class, $parent_pid, $parray,  $id_field, $pid_field);
			}
		}
		return $parray ;
	}
	
	
	/***
	 * ع¤ˤʤäƤΤΰФ
	 * array( array('prefix'=>'0', 'title'=>'cate1'), array('prefix'=>'1', 'title'=>'cate2'.....),
	 * @access public
	 * @param string Ѥ륯饹
	 * @param string primaryIDΥե̾
	 * @param string parent IDΥե̾
	 * @param array  ¤ӽϤ
	 * @param int    ID
	 * @param bool   ʬ겼γؤ˹Ԥ(trueʤ鲼Ȥ˹Ԥ)
	 * @param int    no use
	 * @param array  no use
	 * @param string no use
	 * @return object or array
	 */
	function getPropTreeArray($class, $id_field, $pid_field, $order, $currentid, $show_self=true, $pid=0, $tree=array(), $prefix=''){
		
		$filter = array($pid_field => new Ethna_AppSearchObject($pid, OBJECT_CONDITION_EQ) );
		$prop = $this->getObjectPropList($class, null, $filter, $order);
        
        if($prop[0] == 0){
			return $tree ;
        } else {
			foreach ($prop[1] as $key=>$property) {
				if (!$show_self && ($property[$id_field]==$currentid || $property[$pid_field]==$currentid) ){
					continue;
				} else {
					$property['prefix'] = $prefix.'.' ;
					$tree[] = $property ;
					$tree = $this->getPropTreeArray($class, $id_field, $pid_field, $order, $currentid, $show_self, $property[$id_field], $tree, $property['prefix']);
				}
			}
        }
		return $tree ;
	}
  
	/***
	 * ع¤ˤʤäƤΤSelectѤOption֤
	 * @access protected
	 * @param string Ѥ륯饹
	 * @param string primaryIDΥե̾
	 * @param string parent IDΥե̾
	 * @param array  ¤ӽϤ
	 * @param int    äID
	 * @param bool   trueʤ顢ʬȤβΥƥ⸫
	 * @param int    no use
	 * @param array  no use
	 * @param string no use
	 * @return object or array
	 */
	function _getPropTreeOption($class, $title_field, $id_field, $pid_field, $order, $currentid=0, $show_self=true, $prefix_style='-'){
  
		$options = array();

		$props = $this->getPropTreeArray($class, $id_field, $pid_field, $order, $currentid, $show_self, 0, array(), '');

		foreach($props as $key=>$value){
			$value['prefix'] = str_replace('.', $prefix_style, $value['prefix']);
			$options[$value[$id_field]] =  $value['prefix'].$value[$title_field];
		}

		return $options ;
	}
  
	
	// xoopsAPIѤΥ᥽å
		// @access protected
	function backupGlobals(){
		global $module_handler, $config_handler, $xoopsModule, $xoopsModuleConfig, $xoopsModule_tmp, $xoopsModuleConfig_tmp ;
		
		if(!$this->af->get('dirname')){
			return null;
		}
		// ¸
		$xoopsModule_tmp = $xoopsModule ;
		$xoopsModuleConfig_tmp = $xoopsModuleConfig ;
		// öglobal˿ʤȻȤʤǡ(եԲ)
		$xoopsModule = $module_handler->getByDirname($this->af->get('dirname'));
		$xoopsModuleConfig = $config_handler->getConfigsByCat(0, $xoopsModule->getVar('mid'));
		return null;
	}
	
	// @access protected
	function restoreGlobals(){
		global $xoopsModule, $xoopsModuleConfig, $xoopsModule_tmp, $xoopsModuleConfig_tmp ;
		if(is_null($xoopsModule_tmp)){
			return null;
		}
		// ᤹
		$xoopsModule = $xoopsModule_tmp ;
		$xoopsModuleConfig = $xoopsModuleConfig_tmp ;
		return null;
	}
	
	
	
	
	/***
	 * ֥Ȱarray('1'=>'misc', '2'=>'asc')Ȥ֤(select option)
	 * @param string $class 饹̾
	 * @param string $key_field	1,2,
	 * @param string $label_field	misc,asc,
	 * @param array	 $order	getObjectPropListѥ
	 * @param array	$filter	getObjectPropListѥե륿
	 * @access public
	 * @return array
	 */
	function getOptionsArray($class, $key_field, $label_field, $order=array(), $filter=array()){
		$cats =& $this->getObjectPropList($class, array($key_field, $label_field), $filter, $order);
		$ret = array();
		foreach($cats[1] as $key=>$value){
			$ret[$value[$key_field]] = $value[$label_field];
		}
		return $ret ;
	}

}
// }}}

// {{{ Xanhte_Rss
/**
 *	XanhteץꥱΥ桼饹
 *
 *	@author		Masaki Fujimoto <fujimoto@php.net>
 *	@access		public
 *	@package	Sample
 */
class Xanhte_AppObject extends Ethna_AppObject
{
	/**#@+
	 *	@access	private
	 */

	/**
	 *	@var	array	ơ֥(ץ)
	 */
	 var $table_def = array();
	 var $prop_def = array();
	 var $table_join = array();

	/**#@-*/	    
	    
	/**#@-*/

	/**
	 *	Xeblog_Entry饹Υ󥹥ȥ饯
	 *
	 *	@access	public
	 *	@param	object	Ethna_Backend	&$backend	Ethna_Backend֥
	 *	@param	mixed	$key_type					
	 *	@param	mixed	$key						
	 *	@param	array	$prop						ץѥƥ
	 */
	function Xanhte_AppObject(&$backend, $key_type = null, $key = null, $prop = null)
	{
	    global $xoopsDB ;
	    // table_def/join_tableΥơ֥̾prefixĤ
		foreach($this->table_def as $table_name=>$table_prop){
			$this->table_def[$xoopsDB->prefix($table_name)] = $table_prop ;
			unset($this->table_def[$table_name]) ;
		}
	    // join_tableΥơ֥̾prefixĤ
		foreach($this->table_join as $join_table=>$join_prop){
			list($left_term, $right_term) = each($join_prop) ;
			$left_term = $xoopsDB->prefix($left_term);
			$right_term = $xoopsDB->prefix($right_term);
			$this->table_join[$xoopsDB->prefix($join_table)] = array($left_term => $right_term) ;
			unset($this->table_join[$join_table]) ;
	    }
		// propjoin_tableξprefixĤ
		foreach($this->prop_def as $prop_name=>$property){
			if(isset($property['table']) && $property['table']!=$this->_getPrimaryTable()){
				$this->prop_def[$prop_name]['table'] = $xoopsDB->prefix($property['table']) ;
			}
	    }
		
		$r = $this->Ethna_AppObject(&$backend, $key_type, $key, $prop);
		if (Ethna::isError($r)) {
			return $r;
		}
	    // ֥ȼԤϤ˵Ҥޤ
	}

	/**
	 *	ơ֥른祤
	 *
	 *	@access	public
	 *	@param	string	$table_name	ꤹơ֥
	 *	@param	array	$table_prop	ơ֥ץѥƥ
	 *	@return	null
	 */
	function _SQLPlugin_SearchTable()
	{
	    $join_query = '';
		if( is_array($this->table_join) ){
			foreach($this->table_join as $right_table => $join_def){
				$join_query .= " left join $right_table ON " ;
				list($l, $r) = each($join_def) ;
				$join_query .= sprintf(' %s=%s ', $l, $r);
			}
		}
		return $join_query;
	}

	// Dummy
	function _isAdditionalField($v){
	    return true ;
	}
	
		
	/**
	 *	ơ֥ؤΥ(W)
	 *
	 *	@access	public
	 *	@param	string	$table_name	ꤹơ֥
	 *	@param	array	$table_prop	ơ֥ץѥƥ
	 *	@return	null
	 */
	function setTable($table_name, $table_prop)
	{
		if( is_string($table_name) && is_array($table_prop)){
			$this->table_def[$table_name] = $table_prop ;
		}
	}
	
	/**
	 *	եؤΥ(W)
	 *
	 *	@access	public
	 *	@param	string	$prop_field	ꤹץѥƥ̾
	 *	@param	array	$prop_prop	ץѥƥ
	 *	@return	null
	 */
	function setProp($prop_field, $properties)
	{
		if( is_string($prop_field) && is_array($properties)){
			$this->prop_def[$prop_field] = array(
				'primary' => $properties['primary'],
				'key' => $properties['key'], 
				'type' => $properties['type'], 
				'form_name' => $properties['form_name'],
				'prop_name' => $properties['prop_name'] ,
			) ;
		}
	}
	
	/**
	 *	桼ץѥƥɽؤΥ
	 *
	 *	@access	public
	 *	@param	string	$key	桼ץѥƥ̾
	 *	@return	mixed	$keyǻꤷ桼ץѥƥ
	 */
	function getName($key)
	{
		return $this->get($key);
	}

	/**
	 *	桼ץѥƥɽ̾ǼϢ
	 *
	 *	@access	public
	 *	@return	array	桼ץѥƥɽ̾ǼϢ
	 */
	function getNameObject()
	{
		$object = parent::getNameObject();

		return $object;
	}
	
	/**
	 *	ץѥƥܺ̾Ǽ°ϢǼ
	 *
	 *	@access	public
	 *	@return	array	ץѥƥܺ̾ǼϢ
	 */
	function getNameProp()
	{
		$object = array();

		foreach ($this->prop_def as $key => $elt) {
			$object[$key] = isset($elt['prop_name']) ? $elt['prop_name'] : '' ;
		}

		return $object;
	}
	
	/**
	 *	ץѥƥ֤
	 *
	 *	@access	public
	 *	@return	array	ץѥƥ
	 */
	function getProp()
	{
		$prop = $this->prop ;
		return $prop;
	}
	
	/**
	 *	remove()᥽åɤΥС饤ɡqueryF̤
	 *
	 *	@access	public
	 *	@return	array	ץѥƥ
	 */
/*	function remove($queryF=false)
	{
		
		$sql = $this->_getSQL_Remove();
		if($queryF){
			$r =& $this->my_db_rw->queryF($sql);
		}else{
			$r =& $this->my_db_rw->query($sql);
		}
		if (Ethna::isError($r)) {
			return $r;
		}

		// ץѥƥ/Хåå/å奯ꥢ
		$this->id = $this->prop = $this->prop_backup = null;
		$this->_clearPropCache();

		return 0;
	} */	

}
// }}}

?>
