#!/bin/bash

# Copyright (C) 2013 NTT DATA Corporation
# 
# This program is free software; you can redistribute it and/or
# Modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation, version 2.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details

# bash configuration
SCRIPT_DIR=$(cd $(dirname $0);pwd)
. ${SCRIPT_DIR}/../../hinemos.cfg
. ${SCRIPT_DIR}/../hinemos_utility.sh

DIR=`dirname $0`
USER=`/usr/bin/whoami`
HOST=`hostname`

########################################
#  Local Variable
########################################
DBPORT=24001
DBUSER=hinemos
DBNAME=hinemos
DBPASSWORD=hinemos

########################################
#  Local Message
########################################

# INFO
MSG_I001="reset schduler."
MSG_I101="successful in reseting schduler."

# WARN
#MSG_W001="xxx"

# ERROR
MSG_E001="failed to reset scheduler."

########################################
# Function
########################################

#
# show usage
#
function usage() {
	echo "usage : ${PROG}"
}

########################################
# SHELL
########################################

# help check
for OPT in $@
do
	case $OPT in
		 --help)
			usage
			exit 0
			;;
	esac
done

# check user
CheckUser ${JVM_USER}

# check process
CheckJVMProcessStopped
CheckPostgreSQLProcessRunning

# main
AskPostgreSQLPasswd

SQL_EXEC_MSG="${MSG_I001}"
SQL=`cat <<DML
BEGIN;
UPDATE qrtz_triggers SET next_fire_time = 0 ;
COMMIT;
DML`

Logging "${SQL_EXEC_MSG}"
MSG=`${PG_HOME}/bin/psql -p ${DBPORT} -U ${DBUSER} -d ${DBNAME} -c "${SQL}" 2>&1`
RET=$?
if [ ${RET} -ne 0 ]
then
	Logging "${MSG}"
	Logging "${MSG_E001}"
	RET=$((16 + ${RET}))
	exit ${RET}
fi


########################################
# Termination Processing
########################################

Logging "${MSG_I101}"
exit 0 

