#!/bin/bash

# Copyright (C) 2013 NTT DATA Corporation
#
#This program is free software; you can redistribute it and/or
#Modify it under the terms of the GNU General Public License
#as published by the Free Software Foundation, version 2.
#
#This program is distributed in the hope that it will be useful,
#but WITHOUT ANY WARRANTY; without even the implied warranty of
#MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#GNU General Public License for more details

# Set up information reading
. /opt/hinemos/hinemos.cfg

# User check
if [ ! `whoami` = ${JVM_USER} ]; then
	echo "Please execute it by the ${JVM_USER} user."
	exit 1
fi

# Argument check
REMOTE_USER=""
if [ $# -eq 0 ]; then
	REMOTE_USER="root"
elif [ $# -eq 1 ]; then
	REMOTE_USER=$1
else
	echo "[Usage] : $0 [remot_user(default : root)]"
	exit 1
fi
echo "The setup of the node for the watch to user ${REMOTE_USER} begins."

#
# Variables
#
SSH_KEYGEN="/usr/bin/ssh-keygen -t rsa"
MKDIR=/bin/mkdir
CHMOD=/bin/chmod

VERSION=`cat ${HINEMOS_HOME}/_version`

echo
echo "-------------------------------------------------------"
echo "   Welcome to the Setup of the collective run function"
echo "                     Hinemos  Version ${VERSION}"
echo
echo "           Copyright (C) 2013 NTT DATA Corporation"
echo "-------------------------------------------------------"

# Making of public key for attestation of JBoss start user
setup() {
    echo "" 
    echo "The public key for the attestation of the ${JVM_USER} user is made without the passphrase."
    echo "Is it good? (Y/N default:Y)"
    while [ 1 ];
    do
      read ANS
      ANS=${ANS:-Y}
      case ${ANS} in
          y|Y)
              break
              ;;
          n|N)
              echo "The setup of the collective run function is discontinued."
              sleep 1
              return
              ;;
          *)
              echo "Please input Y or N."
              ;;
      esac
    done

    if [ -e /root/.ssh/id_rsa.pub ]; then
        echo "The public key already exists."
        sleep 1
        return
    fi

    expect -c "
        set timeout 20
        spawn -noecho $SSH_KEYGEN
        expect Enter
        send \r
        expect Enter
        send \r
        expect Enter
        send \r
        expect eof
    "

    if [ $? -ne 0 ] ; then
        echo ""
        echo "It failed in making the public key."
        echo ""
        break
    fi

    echo ""
    echo "The public key was made."
    echo ""
}


# Registration of JBoss start user's public key to node for monitoring
entry() {
    if [ ! -e /root/.ssh/id_rsa.pub ]; then
        echo ""
        echo "${JVM_USER} user's public key is not made. Please make it."
        return
    fi
    
    MANAGER_KEY=`cat /root/.ssh/id_rsa.pub`

    echo ""
    echo ""
    echo "${JVM_USER} user's public key is registered in the ${REMOTE_USER} user's with node for the authorized_keys file."

    while [ 1 ];
    do
        echo ""
        echo "Please input IP address of the node that uses the collective run function for the monitoring."
        echo "Please input 9 when ending."
        
        read AGENT_IP
        
        case ${AGENT_IP} in
        9)
            break
            ;;
        *)

    
     	    if [ $? -ne 0 ] ; then
		echo ""
		echo "${AGENT_IP} doesn't exist."

	    else
		echo ""
		echo "Please specify the home directory of the ${REMOTE_USER} user with the node for the monitoring."
		read ROOT_HOME
		
	    # When the end is not "/", it adds it. 
		case ${ROOT_HOME} in
		    */)
		        ;;
		    *)
		        ROOT_HOME=${ROOT_HOME}/
			;;
		esac
		
		echo "${JVM_USER} user's public key is set to ${ROOT_HOME}.ssh/authorized_keys."
		echo "Is it good? (Y/N default:Y)"
		read ANS
		ANS=${ANS:-Y}
		AGENT_AUTHORIZED_KEYS=${ROOT_HOME}.ssh/authorized_keys
		case ${ANS} in
		    y|Y)
			ssh ${REMOTE_USER}@${AGENT_IP} "
                            if [ ! -d ${ROOT_HOME}.ssh ] ; then
                                ${MKDIR} ${ROOT_HOME}.ssh
                                ${CHMOD} 700 ${ROOT_HOME}.ssh
                            fi
                            echo ${MANAGER_KEY} >> ${AGENT_AUTHORIZED_KEYS}
                            ${CHMOD} 600 ${AGENT_AUTHORIZED_KEYS}
                        "

			echo ""
			echo "Registration to ${AGENT_IP} was completed."
		        ;;
		    n|N)
   		        ;;
		    *)
			;;
		esac
	    fi
            sleep 1
            ;;
        esac
    done
}



# Main Function
while [ 1 ];
do
    echo ""
    echo "the Setup of the collective run function"
    echo ""
    echo "     1) Making of public key for attestation of ${JVM_USER} user"
    echo "     2) Public key registration to node for monitoring"
    echo "     9) Setup end of collective run function"
    echo ""
    echo -n "===> "

    read NUMBER

    case ${NUMBER} in
        1)
            setup
            ;;
        2)
            entry
            ;;
        9)
            exit 0
            ;;
        *)
            echo ""
            sleep 1
    esac
done


