#!/bin/bash

# Copyright (C) since 2006 NTT DATA Corporation
# 
# This program is free software; you can redistribute it and/or
# Modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation, version 2.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details

# bash configuration
RPM_PROC=""
FTP_PROC=""
FTP_HOST=%%FTP_HOST%%
FTP_USER="hinemos"
FTP_PASSWD="hinemos"
RM_PROC="/bin/rm -f"

# RPM file name
rpmfile=${1##/*/}
# RPM file remote path
remotepath=${1%/*}

echo $rpmfile
echo $remotepath

##
## Check Distribution
##
LSB_RELEASE_FILE="/etc/lsb-release"
RHEL_RELEASE_FILE="/etc/redhat-release"
if [ -f $LSB_RELEASE_FILE ]; then
    RPM_PROC="/usr/bin/dpkg -i"
    FTP_PROC="/usr/bin/krb5-ftp"
    if [ "${@##*.}" != "deb" ]; then
        echo "$1 is not deb file."
        exit 255  ## exit: Illegal number: -1
    fi

elif [ -f $RHEL_RELEASE_FILE ]; then
    RPM_PROC="/bin/rpm -Uvh"
    FTP_PROC="/usr/bin/ftp"
    if [ "${@##*.}" != "rpm" ]; then
        echo "$1 is not rpm file."
        exit -1
    fi

else
    echo "OS Release file not found. Please make sure that your environment meets the system requirements. Unable to process."
    exit -1
fi

##
## The rpm file is forwarded from the server in the local. 
##
if [ -f ${FTP_PROC} ]; then
    echo "You have ftp command '$FTP_PROC' installed. OK."
else
    echo "You don't have ftp command '$FTP_PROC' installed. Please install it before process."
    exit -1
fi

expect -c "
    set timeout 300
    spawn $FTP_PROC $FTP_HOST
    expect Name*:
    send $FTP_USER\r
    expect Password:
    send $FTP_PASSWD\r
    expect {
	successful.	{}
	failed.		{exit 1}
	timeout		{exit 1}
    }
    expect >
    send \"cd $remotepath\r\"
    expect >
    send \"get $rpmfile\r\"
    expect {
	complete.		{}	
	Failed		{exit 1}
	timeout		{exit 1}
    }
    expect >
    send quit\r
    expect eof
"
if [ $? -ne 0 ] ; then
    echo 'File transfer error' 1>&2
    exit 10
fi

##
## rpm command
##
echo "$RPM_PROC $rpmfile"
$RPM_PROC $rpmfile
RETVAL=$?


##
## delete rpm file
##
echo "$RM_PROC $rpmfile"
$RM_PROC $rpmfile

echo "exit $RETVAL"
if [ $RETVAL -ne 0 ] ; then
    exit 20
fi

exit

