#!/bin/bash

# Copyright (C) since 2006 NTT DATA Corporation
# 
# This program is free software; you can redistribute it and/or
# Modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation, version 2.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details

# bash configuration
FTP_PROC=""
FTP_HOST=%%FTP_HOST%%
FTP_USER="hinemos"
FTP_PASSWD="hinemos"
EXPECT_PROC="/usr/bin/expect"
CHOWN_PROC="/bin/chown"
CHMOD_PROC="/bin/chmod"

##
## Check Distribution
##
LSB_RELEASE_FILE="/etc/lsb-release"
RHEL_RELEASE_FILE="/etc/redhat-release"
if [ -f $LSB_RELEASE_FILE ]; then
    FTP_PROC="/usr/bin/krb5-ftp"
elif [ -f $RHEL_RELEASE_FILE ]; then
    FTP_PROC="/usr/bin/ftp"
else
    echo "OS Release file not found. Please make sure that your environment meets the system requirements. Unable to process."
    exit -1
fi

##
## Argument setting
##
while [ $# -gt 0 ]
do
  #echo $1
  case $1 in
    -u)
      shift
      user="$1"
      ;;
    -g)
      shift
      group="$1"
      ;;
    -m)
      shift
      mode="$1"
      ;;
    -d)
      shift
      distdir="$1"
      ;;
    *)
      # file name
      file=${1##/*/}
      # remote file path
      remotepath=${1%/*}
      ;;
  esac

  shift

done


##
## The file is forwarded from the server in the local.
##
if [ -f ${FTP_PROC} ]; then
    echo "You have ftp command '$FTP_PROC' installed. OK."
else
    echo "You don't have ftp command '$FTP_PROC' installed. Please install it before process."
    exit -1
fi

$EXPECT_PROC -c "
    set timeout 300
    spawn $FTP_PROC $FTP_HOST
    expect Name*:
    send $FTP_USER\r
    expect Password:
    send $FTP_PASSWD\r
    expect {
	successful.	{}
	failed.		{exit 1}
	timeout		{exit 1}
    }
    expect >
    send \"lcd $distdir\r\"
    expect {
	No*such*file*or*directory	{exit 1}
	Permission*denied	{exit 1}
        >	{}
	timeout		{exit 1}
    }
    send \"cd $remotepath\r\"
    expect >
    send \"get $file\r\"
    expect {
	complete.		{}	
	Failed		{exit 1}
	timeout		{exit 1}
    }
    expect >
    send quit\r
    expect eof
"
if [ $? -ne 0 ] ; then
    echo 'File transfer error' 1>&2
    exit 10
fi

##
## chown command
##
if [ ${#user} -ne 0 ] ; then
    ownarg=$user
fi
if [ ${#group} -ne 0 ] ; then
    ownarg=$ownarg:$group
fi
if [ ${#ownarg} -ne 0 ] ; then
    echo "$CHOWN_PROC $ownarg $distdir/$file"
    $CHOWN_PROC $ownarg $distdir/$file
    if [ $? -ne 0 ] ; then
        exit 1
    fi
fi

##
## chmod command
##
if [ ${#mode} -ne 0 ] ; then
    echo "$CHMOD_PROC $mode $distdir/$file"
    $CHMOD_PROC $mode $distdir/$file
    if [ $? -ne 0 ] ; then
        exit 2
    fi
fi

exit
