#!/bin/bash

# Copyright (C) since 2006 NTT DATA Corporation
# 
# This program is free software; you can redistribute it and/or
# Modify it under the terms of the GNU General Public License
# as published by the Free Software Foundation, version 2.
# 
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details

# bash configuration

GREP_PROC="/bin/grep"
EXPECT_PROC="/usr/bin/expect"
SSH_PROC="/usr/bin/ssh"
SCP_PROC="/usr/bin/scp"
TAR_PROC="/bin/tar"
AWK_PROC="/bin/awk"
PWD_PROC="/bin/pwd"
LS_PROC="/bin/ls"
RM_PROC="/bin/rm -rf"


HINEMOS_VERSION=%%HINEMOS_VERSION%%

AGENT_HOME="/opt/hinemos_agent"
AGENT_INSTALL_SH="agent_installer_JP.sh"

#
# Check Distribution
#
LSB_RELEASE_FILE="/etc/lsb-release"
RHEL_RELEASE_FILE="/etc/redhat-release"
VERSION=""

if [ -f $LSB_RELEASE_FILE ]; then
    if [ `. /etc/lsb-release && echo $DISTRIB_RELEASE` = "12.04" ]; then
        VERSION="precise"
    else
        echo "OS version missmatch (required version = 12.04 LTS). Unable to install."
        exit -1
    fi

    ARCH=`uname -p`
    if [ $ARCH = "x86_64" ]; then
        VERSION=${VERSION}"_64"
    elif [ $ARGH = "i686" ]; then
        VERSION=${VERSION}"_32"
    else
        echo "Unknown architecture (neither i686 nor x86_64). Unable to install."
        exit -1
    fi
    
elif [ -f $RHEL_RELEASE_FILE ]; then
    if [ `grep [56].[0-9] $RHEL_RELEASE_FILE | wc -l` -eq 1 ]; then
        VERSION="rhel5-rhel6"
    elif [ `grep 4.[0-9] $RHEL_RELEASE_FILE | wc -l` -eq 1 ]; then
        VERSION="rhel4"
    fi

    ARCH=`rpm -q --qf "%{ARCH}" kernel`
    if [ $? -ne 0 ]; then
        echo "The kernel package is not installed. Please install the kernel package."
        exit -1
    fi
    echo ${ARCH} | grep 64 > /dev/null  && VERSION=${VERSION}"_64"
    if [ $? -ne 0 ]; then
        VERSION=${VERSION}"_32"
    fi
    
else
    echo "OS Release file not found. Please make sure that your environment meets the system requirements. Unable to install."
    exit -1
fi

# Name resolution of Hinemos agent package
AGENT_DIR="Hinemos_Agent-${HINEMOS_VERSION}_${VERSION}"
AGENT_PACKAGE="hinemos_agent-${HINEMOS_VERSION}_${VERSION}.tar.gz"
echo "Target Install Package : ${AGENT_PACKAGE}"

# Variable
scp_address=""
mgr_address=""
pass=""
jre_ans=""
place=""

##
## Argument settings
##
while [ $# -gt 0 ] 
do
  case $1 in
    -a)
      shift
      agent=$1
      ;;
    -i)
      shift
      scp_address=$1
      ;;
    -p)
      shift
      pass=$1 
      ;;
    -j)
      shift
      jre_ans=$1
      ;;
    -m)
      shift
      mgr_address=$1
      ;;
    -w)
      shift
      ${LS_PROC} $1 > /dev/null
      if [ "$?" != 0 ];then
          echo "The copy destination doesn't exist."
          exit -1
      fi
      place=$1
      ;;
    *)
      ;;
  esac

  shift 

done


##
## Confirmation
##

# Check on input value
if [ "${scp_address}" = "" ]; then
    echo "Please input IP address of the server with the Hinemos agent installer."
    exit -1
elif [ "${pass}" = "" ]; then
    echo "Please input the password of the root user of the server with the Hinemos agent installer."
    exit -1
elif [ "${agent}" = "" ]; then
    echo "Please input the file path of the Hinemos agent installer."
    exit -1
elif [ "${place}" = "" ]; then
    echo "Please input the destination of the copy of the agent installer."
    exit -1
elif [ "${mgr_address}" = "" ]; then
	echo "Please input manager's IP address. "
	exit -1 
fi


## Set confirmation of agent installer distribution machine
##
# Confirmation of IP address and confirmation of password
$EXPECT_PROC -c "
    set timeout 10
    spawn -noecho $SSH_PROC -n ${scp_address} -l root \"
        ${LS_PROC} ${agent}/${AEGNT_PACKEGE}
    \"
    expect {
        -re \".*Name or service not known\" { exit 1}
        \"Are you sure\" { send yes\r }
        timeout
    }
    expect root
    send ${pass}\r
    expect {
        -re \".*${agent}/${AGENT_PACKAGE}\" { exit 0 }
        -re \".*${LS_PROC}\" { exit 3 }
        timeout { exit 2 }
    }
" > /dev/null
case $? in
    1)
      echo "IP:${scp_address} IP address doesn't exist."
      exit 1
      ;;
    2)
      echo "IP:${scp_address} root user's password is wrong."
      exit 2
      ;;
    3)
      echo "${agent}/${AGENT_PACKAGE} doesn't exist."
      exit 3
      ;;
    *)
      break
      ;;
esac


##
## Processing on Hinemos agent server
##

# for IPv6's command format
scp_address_mod=$scp_address
if [ -n "`echo $scp_address_mod | awk /:/`" ]
then
    scp_address_mod="\[${scp_address}\]"
fi
mgr_address_mod=$mgr_address
if [ -n "`echo $mgr_address_mod | awk /:/`" ]
then
    mgr_address_mod="\[${mgr_address}\]"
fi

# The Hinemos agent installer is copied from the server of input IP address.
$EXPECT_PROC -c "
    set timeout -1
    spawn $SCP_PROC root@${scp_address_mod}:${agent}/${AGENT_PACKAGE} ${place}
    expect root
    send ${pass}\r
    expect eof
" > /dev/null


if [ $? != 0 ];then
    echo "Failed to copy HinemosAgent installer."
    exit 10
fi
echo "Successfully copied HinemosAgent installer."
echo "  ${place}/${AGENT_PACKAGE}"

# Hinemos agent's decompression
CURRENT_PLACE=`${PWD_PROC}`
cd ${place}
${TAR_PROC} -zxf ${AGENT_PACKAGE} > /dev/null 2>&1
if [ $? != 0 ];then
    echo "Failed to decompress HinemosAgent installer."
    exit 1
fi
echo "Successfully decompressed HinemosAgent installer."
echo "  ${place}/${AGENT_DIR}"
echo "Please delete above unless needed after installation."
echo ""
echo "Installation begins."

cd ${CURRENT_PLACE}

AGENT_LOG="${place}/${AGENT_DIR}/agent_install.log"

# The Hinemos agent's installation
$EXPECT_PROC -c "
    set timeout -1
    spawn ${place}/${AGENT_DIR}/${AGENT_INSTALL_SH}

# "1" is selected by the first menu selection. 
    expect {
        -re \".*==>\" { send \"1\r\" }
        eof { exit 1 }
    }
#    send 1\r

# The installation begins. Is it good? 
    expect -re \".*\?\(Y\/N.*\).*\"
    send Y\r

# Is the installation directory good in /opt/hinemos_agent ? 
    expect -re \".*\?\(Y\/N.*\).*\"
    send Y\r

# The manager's IP address setting
    expect -re \".*IP.*\"
    send ${mgr_address_mod}\r
    expect -re \".*\(Y\/N.*\)\"
    send Y\r

# The service script is arranged. Is it good? 
    expect -re \".*\?\(Y\/N.*\).*\"
    send Y\r

# "9" is selected by the menu selection displayed again. 
    expect -re \".*==>\"
    send 9\r
    expect eof

" >${AGENT_LOG} 2>&1

echo ""

if [ $? = 0 ]; then
    echo "HinemosAgent installation completed. Please confirm ${AGENT_DIR}/agent_install.log of ${place}." 
else
    echo "Failed to install HinemosAgent."
    echo "Please confirm ${AGENT_DIR}/agent_install.log of ${place} for the detail."
    exit -1
fi

exit
