/*
 * Decompiled with CFR 0.152.
 */
package net.sf.jpasecurity.configuration;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Map;
import net.sf.jpasecurity.configuration.AuthenticationProvider;
import net.sf.jpasecurity.configuration.Configuration;
import net.sf.jpasecurity.configuration.ConfigurationReceiver;
import net.sf.jpasecurity.configuration.SecurityContext;
import net.sf.jpasecurity.configuration.SecurityContextReceiver;
import net.sf.jpasecurity.mapping.Alias;
import net.sf.jpasecurity.mapping.MappingInformation;
import net.sf.jpasecurity.mapping.MappingInformationReceiver;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AuthenticationProviderSecurityContext
implements SecurityContext,
ConfigurationReceiver,
MappingInformationReceiver,
SecurityContextReceiver {
    public static final Alias CURRENT_PRINCIPAL = new Alias("CURRENT_PRINCIPAL");
    public static final Alias CURRENT_ROLES = new Alias("CURRENT_ROLES");
    private AuthenticationProvider authenticationProvider;
    private ConfigurationReceiver configurationReceiver;
    private MappingInformationReceiver persistenceInformationReceiver;
    private SecurityContextReceiver securityContextReceiver;

    public AuthenticationProviderSecurityContext(AuthenticationProvider authenticationProvider) {
        this.authenticationProvider = authenticationProvider;
        if (authenticationProvider instanceof ConfigurationReceiver) {
            this.configurationReceiver = (ConfigurationReceiver)((Object)authenticationProvider);
        }
        if (authenticationProvider instanceof MappingInformationReceiver) {
            this.persistenceInformationReceiver = (MappingInformationReceiver)((Object)authenticationProvider);
        }
        if (authenticationProvider instanceof SecurityContextReceiver) {
            this.securityContextReceiver = (SecurityContextReceiver)((Object)authenticationProvider);
        }
    }

    @Override
    public void setConfiguration(Configuration configuration) {
        if (this.configurationReceiver != null) {
            this.configurationReceiver.setConfiguration(configuration);
        }
    }

    @Override
    public void setMappingInformation(MappingInformation persistenceMapping) {
        if (this.persistenceInformationReceiver != null) {
            this.persistenceInformationReceiver.setMappingInformation(persistenceMapping);
        }
    }

    @Override
    public void setMappingProperties(Map<String, Object> properties) {
        if (this.persistenceInformationReceiver != null) {
            this.persistenceInformationReceiver.setMappingProperties(properties);
        }
    }

    @Override
    public void setSecurityContext(SecurityContext securityContext) {
        if (this.securityContextReceiver != null) {
            this.securityContextReceiver.setSecurityContext(securityContext);
        }
    }

    @Override
    public Object getAliasValue(Alias alias) {
        if (alias == null) {
            return null;
        }
        if (alias.equals(CURRENT_PRINCIPAL)) {
            return this.authenticationProvider.getPrincipal();
        }
        return null;
    }

    @Override
    public <T> Collection<T> getAliasValues(Alias alias) {
        if (alias == null) {
            return null;
        }
        if (alias.equals(CURRENT_ROLES)) {
            return this.authenticationProvider.getRoles();
        }
        return null;
    }

    @Override
    public Collection<Alias> getAliases() {
        return Collections.unmodifiableCollection(Arrays.asList(CURRENT_PRINCIPAL, CURRENT_ROLES));
    }
}

