#!/bin/bash

echo ""
echo ""
echo "########################################################"
echo "### Gathering script of Agent Information (20110301) ###"
echo "###    Script started at `date '+%Y-%m-%d %T'`       ###"
echo "########################################################"
echo ""

function usage {
        echo "usage: "
        echo "$0 -vv  : Get information about OS INFORMATION"
        echo "$0 -vvv : Get information about DETAIL"
        return 0
}

function init {
## Hinemos Agent env
. /opt/hinemos_agent/conf/hinemos_agent.cfg
}

function os {
## cat /etc/lsb-release
echo "### cat /etc/lsb-release ###"
cat /etc/lsb-release
echo -e "\n"

## chkconfig --list | grep hinemos
#echo "###  chkconfig --list | grep hinemos ###"
#chkconfig --list | grep hinemos
#echo -e "\n"

## dpkg -l
echo "### dpkg -l ###"
dpkg -l
echo -e "\n"

## cpuinfo
echo "### /proc/cpuinfo ###"
cat /proc/cpuinfo
echo -e ""

## meminfo
echo "### /proc/meminfo ###"
cat /proc/meminfo
echo -e "\n"

if [ -x sar ]; then
    ## sar -P ALL
    echo "### sar -P ALL ###"
    sar -P ALL
    echo -e "\n"

    ## sar -r
    echo "### sar -r ###"
    sar -r
    echo -e "\n"

    ## sar -n DEV
    echo "### sar -n DEV ###"
    sar -n DEV
    echo -e "\n"
    
    ## sar -n EDEV
    echo "### sar -n EDEV ###"
    sar -n EDEV
    echo -e "\n"
else
    echo -e "### command 'sar' not installed ###\n"
fi

## vmstat -n
if [ -x vmstat ]; then
    echo "### vmstat -n ###"
    vmstat -n
    echo -e "\n"
else
    echo -e "### command 'vmstat' not installed ###\n"
fi

## iostat -d -x
if [ -x iostat ]; then
    echo "### iostat -d -x ###"
    iostat -d -x
    echo -e ""
else
    echo -e "### command 'iostat' not installed ###\n"
fi

## ps -H auxwww
echo "### ps -H auxwww ###"
ps -H auxwww
echo -e "\n"

## netstat -s
echo "### netstat -s ###"
netstat -s
echo -e "\n"

## netstat -anpo
echo "### netstat -anpo ###"
netstat -anpo
echo -e "\n"

## df
echo "### df ###"
df
echo -e "\n"

## df -i
echo "### df -i ###"
df -i
echo -e "\n"

## uptime
echo "### uptime ###"
uptime
echo -e "\n"

## /proc/slabinfo
echo "### /proc/slabinfo ###"
cat /proc/slabinfo
echo -e "\n"

## /proc/vmstat
echo "### /proc/vmstat ###"
cat /proc/vmstat
echo -e "\n"
}

function detail {
## lsof
echo "### lsof ###"
lsof
echo -e "\n"

## md5sum
echo "### md5sum ###"
cd ${HINEMOS_AGENT_HOME}
find `ls --ignore='var'` -type f | xargs md5sum
cd -
echo -e "\n"
}


if [ $# -eq 0 ]; then
        usage
        exit 1
fi

for OPTION in "$@"
do
        case $OPTION in
                -vv)
                        init
                        os
                        ;;
                -vvv)
                        init
                        os
                        detail
                        ;;
                *)
                        usage
                        exit 1
        esac
done

echo ""
echo "###################################################"
echo "###     Script ended at `date '+%Y-%m-%d %T'`     ###"
echo "###################################################"

exit 0
