package com.clustercontrol.xcloud.aws.ui.handlers;

import static com.clustercontrol.xcloud.aws.common.AWSConstants.backup_aws_iops;
import static com.clustercontrol.xcloud.aws.common.AWSConstants.backup_aws_volumeSize;
import static com.clustercontrol.xcloud.aws.common.AWSConstants.backup_aws_volumeType;
import static com.clustercontrol.xcloud.aws.common.AWSConstants.backup_storageName;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Map.Entry;

import org.apache.log4j.Logger;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.handlers.HandlerUtil;

import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.xcloud.BackupedData;
import com.clustercontrol.ws.xcloud.BackupedDataEntry;
import com.clustercontrol.ws.xcloud.CloneBackupedStorageRequest;
import com.clustercontrol.ws.xcloud.CloudEndpoint;
import com.clustercontrol.xcloud.aws.common.AWSStringConstants;
import com.clustercontrol.xcloud.aws.ui.dialogs.AWSResourceProvider;
import com.clustercontrol.xcloud.aws.ui.dialogs.CreateStorageDialog;
import com.clustercontrol.xcloud.aws.ui.dialogs.CreateStorageDialog.DialogData;
import com.clustercontrol.xcloud.common.CloudConstants;
import com.clustercontrol.xcloud.common.CloudStringConstants;
import com.clustercontrol.xcloud.extensions.ICloudOptionHandler;
import com.clustercontrol.xcloud.model.cloud.IBackupedDataEntry;
import com.clustercontrol.xcloud.model.cloud.ILocation;
import com.clustercontrol.xcloud.model.cloud.IStorageBackupEntry;
import com.clustercontrol.xcloud.plugin.CloudOptionSourceProvider;
import com.clustercontrol.xcloud.util.CollectionComparator;

public class CloneBackupedStorageHandler implements ICloudOptionHandler, CloudStringConstants, AWSStringConstants {
	@Override
	public Object execute(ExecutionEvent event) {
		IStructuredSelection selection = (IStructuredSelection)HandlerUtil.getActiveSite(event).getSelectionProvider().getSelection();
		final IStorageBackupEntry backupedEntry = (IStorageBackupEntry)selection.getFirstElement();
		final ILocation location = (ILocation)HandlerUtil.getVariable(event, CloudOptionSourceProvider.ActiveLocation);
		final CloneBackupedStorageRequest request = new CloneBackupedStorageRequest();
		
		request.setStorageId(backupedEntry.getBackup().getStorage().getId());
		request.setStorageSnapshotId(backupedEntry.getId());
		request.setModifiedData(new BackupedData());
		
		for (IBackupedDataEntry entry: backupedEntry.getBackupedDataEntries()) {
			BackupedDataEntry e = new BackupedDataEntry();
			e.setName(entry.getName());
			e.setValue(entry.getValue());
			request.getModifiedData().getEntries().add(e);
		}
		
		final Map<String, String> dataMap = new HashMap<>();
		for (BackupedDataEntry entry: request.getModifiedData().getEntries()) {
			dataMap.put(entry.getName(), entry.getValue());
		}
		CreateStorageDialog dialog = new CreateStorageDialog(
			HandlerUtil.getActiveShell(event),
			location,
			MessageFormat.format(dlgComputeHistryClone, strAws),
			new AWSResourceProvider(location)) {
			@Override
			protected Control createDialogArea(Composite parent) {
				Control control = super.createDialogArea(parent);
				cmbSnapshot.setEnabled(false);
				btnNewButton.setEnabled(false);
				return control;
			}
		};
		
		dialog.setDialogData(new DialogData() {
			@Override
			public String getName() {
				return dataMap.get(backup_storageName);
			}
			@Override
			public void setName(String value) {
				dataMap.put(backup_storageName, value);
			}
			@Override
			public String getAvailabilityZone() {
				return dataMap.get(CloudConstants.backup_instanceName);
			}
			@Override
			public void setAvailabilityZone(String value) {
				dataMap.put(CloudConstants.backup_instanceName, value);
			}
			@Override
			public String getSnapshotId() {
				return request.getStorageSnapshotId();
			}
			@Override
			public void setSnapshotId(String value) {
			}
			@Override
			public Integer getIops() {
				String iopsString = dataMap.get(backup_aws_iops);
				return iopsString != null ? Integer.valueOf(iopsString): null;
			}
			@Override
			public void setIops(Integer value) {
				dataMap.put(backup_aws_iops, value == null ? null: Integer.toString(value));
			}
			@Override
			public Integer getSize() {
				String sizeString = dataMap.get(backup_aws_volumeSize);
				return sizeString != null ? Integer.valueOf(sizeString): null;
			}
			@Override
			public void setSize(Integer value) {
				dataMap.put(backup_aws_volumeSize, value == null ? Integer.toString(0): Integer.toString(value));
			}
			@Override
			public String getType() {
				return dataMap.get(backup_aws_volumeType);
			}
			@Override
			public void setType(String value) {
				dataMap.put(backup_aws_volumeType, value);
			}

		});
		
		loop_end:
		while(true){
			try {
				if (dialog.open() != Window.OK)
					break loop_end;
			} catch (Exception e) {
				Logger logger = Logger.getLogger(this.getClass());
				logger.error(e.getMessage(), e);
	
				String message = e.getMessage();
				if (message == null) {
					ByteArrayOutputStream bos = new ByteArrayOutputStream();
					PrintStream ps = new PrintStream(bos, true);
					e.printStackTrace(ps);
					
					message = bos.toString();
				}
				
				// 失敗報告ダイアログを生成
				MessageDialog.openError(null, Messages.getString("failed"), message);
				break;
			}
			
			String storageName = dataMap.get(backup_storageName);
			storageName = storageName == null ? "": storageName;
			if (MessageDialog.openConfirm(
				null,
				Messages.getString("confirmed"),
				MessageFormat.format(msgConfirmCloneStorageSnapshot, backupedEntry.getName(), backupedEntry.getId(), storageName))) {
				
				try {
					CollectionComparator.compareCollection(request.getModifiedData().getEntries(), dataMap.entrySet(), new CollectionComparator.Comparator<BackupedDataEntry, Map.Entry<String, String>>(){
						@Override
						public boolean match(BackupedDataEntry o1, Entry<String, String> o2) {
							return o1.getName().equals(o2.getKey());
						}
						@Override
						public void matched(BackupedDataEntry o1, Entry<String, String> o2) {
							o1.setValue(o2.getValue());
						}
						@Override
						public void afterO1(BackupedDataEntry o1) {
							request.getModifiedData().getEntries().remove(o1);
						}
						@Override
						public void afterO2(Entry<String, String> o2) {
							BackupedDataEntry entry = new BackupedDataEntry();
							entry.setName(o2.getKey());
							entry.setValue(o2.getValue());
							request.getModifiedData().getEntries().add(entry);
						}
						
					});
					
					CloudEndpoint endpoint = location.getCloudScope().getCloudScopes().getHinemosManager().getEndpoint(CloudEndpoint.class);
					endpoint.cloneBackupedStorage(location.getCloudScope().getId(), location.getId(), request);
					
					// 成功報告ダイアログを生成
					MessageDialog.openInformation(
						null,
						Messages.getString("successful"),
						MessageFormat.format(msgFinishCloneStorageSnapshot, storageName));
					
					Display.getCurrent().asyncExec(new Runnable() {
						@Override
						public void run() {
							location.getComputeResources().updateStorages();
						}
					});
					
					break loop_end;
				} catch (Exception e) {
					Logger logger = Logger.getLogger(this.getClass());
					logger.error(e.getMessage(), e);

					String message = e.getMessage();
					if (message == null) {
						ByteArrayOutputStream bos = new ByteArrayOutputStream();
						PrintStream ps = new PrintStream(bos, true);
						e.printStackTrace(ps);
						
						message = bos.toString();
					}
					
					// 失敗報告ダイアログを生成
					MessageDialog.openError(null, Messages.getString("failed"), message);
				}
			}
		}
		return null;
	}
}