/*
Copyright (C) 2015 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.xcloud.aws.ui.dialogs;

import java.text.MessageFormat;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.SWTResourceManager;

import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.xcloud.AvailableRole;
import com.clustercontrol.ws.xcloud.CloudEndpoint;
import com.clustercontrol.ws.xcloud.CloudManagerException;
import com.clustercontrol.ws.xcloud.InvalidRole_Exception;
import com.clustercontrol.ws.xcloud.InvalidUserPass_Exception;
import com.clustercontrol.xcloud.Activator;
import com.clustercontrol.xcloud.aws.common.AWSStringConstants;
import com.clustercontrol.xcloud.common.CloudStringConstants;
import com.clustercontrol.xcloud.model.CloudModelException;
import com.clustercontrol.xcloud.model.cloud.IHinemosManager;
import com.clustercontrol.xcloud.platform.PlatformDependent;
import com.clustercontrol.xcloud.ui.dialogs.IDialogConstants;
import com.clustercontrol.xcloud.util.ControlUtil;
import com.clustercontrol.xcloud.util.validation.ControlValidator;
import com.clustercontrol.xcloud.util.validation.ValidateException;
import com.clustercontrol.xcloud.util.validation.annotation.RequiredInput;
import com.clustercontrol.xcloud.util.validation.annotation.RequiredSelect;

public class CreateCloudScopeDialog extends Dialog implements CloudStringConstants, AWSStringConstants {
	public static class DialogData{
		private String managerName;
		private String cloudScopeId;
		private String cloudScopeName;
		private String ownerRoleId;
		private String description;
		private String accountId;
		private String accessKey;
		private String secretKey;
		private String displayName;
		public String getManagerName() {return managerName;}
		public void setManagerName(String managerName) {this.managerName = managerName;}
		public String getCloudScopeId() {return cloudScopeId;}
		public void setCloudScopeId(String cloudScopeId) {this.cloudScopeId = cloudScopeId;}
		public String getCloudScopeName() {return cloudScopeName;}
		public void setCloudScopeName(String cloudScopeName) {this.cloudScopeName = cloudScopeName;}
		public String getDescription() {return description;}
		public void setDescription(String description) {this.description = description;}
		public String getAccountId() {return accountId;}
		public void setAccountId(String accountId) {this.accountId = accountId;}
		public String getAccessKey() {return accessKey;}
		public void setAccessKey(String accessKey) {this.accessKey = accessKey;}
		public String getSecretKey() {return secretKey;}
		public void setSecretKey(String secretKey) {this.secretKey = secretKey;}
		public String getDisplayName() {return displayName;}
		public void setDisplayName(String displayName) {this.displayName = displayName;}
		public String getOwnerRoleId() {return ownerRoleId;}
		public void setOwnerRoleId(String ownerRoleId) {this.ownerRoleId = ownerRoleId;}
	}
	
	private DialogData dialogData = null;
	
	@RequiredSelect
	private Combo cmbManager;
	@RequiredInput
	private Text txtCloudScopeId;
	@RequiredInput
	private Text txtCloudScopeName;
	private Text txtDescription;
	@RequiredInput
	private Text txtAccountId;
	@RequiredInput
	private Text txtAccessKey;
	@RequiredInput
	private Text txtSecretKey;
	@RequiredInput
	private Text txtDisplayName;
	
	private Combo cmbAssignRoleId;
	private IHinemosManager currentManager;
	
	private boolean edit;
	
	/**
	 * Create the dialog.
	 * @param parentShell
	 */
	public CreateCloudScopeDialog(Shell parentShell, boolean edit) {
		super(parentShell);
		this.edit = edit;
	}

	/**
	 * Create contents of the dialog.
	 * @param parent
	 */
	@Override
	protected Control createDialogArea(Composite parent) {
		Composite area = (Composite) super.createDialogArea(parent);
		Composite container = new Composite(area, SWT.FILL);
		container.setBackground(SWTResourceManager.getColor(SWT.COLOR_WIDGET_BACKGROUND));
		GridLayout gl_container = new GridLayout(2, false);
		gl_container.verticalSpacing = 20;
		container.setLayout(gl_container);
		GridData gd_container = new GridData(SWT.FILL, SWT.FILL, true, false);
		gd_container.verticalAlignment = SWT.FILL;
		gd_container.horizontalAlignment = SWT.FILL;
		container.setLayoutData(gd_container);
		
		Composite composite = new Composite(container, SWT.NONE);
		GridLayout gl_composite = new GridLayout(2, false);
		gl_composite.marginRight = 3;
		gl_composite.marginLeft = 3;
		composite.setLayout(gl_composite);
		composite.setLayoutData(new GridData(SWT.FILL, SWT.FILL, false, false, 2, 1));
		
				Label lblManager = new Label(composite, SWT.RIGHT);
				lblManager.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
				lblManager.setText(strManager + strSeparator);
						
								cmbManager = new Combo(composite, SWT.READ_ONLY);
								cmbManager.addModifyListener(new ModifyListener() {
									public void modifyText(ModifyEvent event) {
										if (currentManager != null && cmbManager.getData(cmbManager.getText()) == currentManager)
											return;
										
										currentManager = (IHinemosManager)cmbManager.getData(cmbManager.getText());
										cmbAssignRoleId.removeAll();
										
										try {
											IHinemosManager manager = (IHinemosManager)cmbManager.getData(cmbManager.getText());
											CloudEndpoint endpoint = manager.getEndpoint(CloudEndpoint.class);
											for(AvailableRole role: endpoint.getAvailableRoles()){
												String roleLabel = role.getRoleName() + "(" + role.getRoleId() + ")"; 
												cmbAssignRoleId.add(roleLabel);
												cmbAssignRoleId.setData(roleLabel, role.getRoleId());
											}
											if(cmbAssignRoleId.getItemCount() > 0){
												cmbAssignRoleId.select(0);
											}
										} catch (CloudManagerException
												| InvalidRole_Exception
												| InvalidUserPass_Exception e) {
											throw new CloudModelException(e.getMessage(), e);
										}
									}
								});
								cmbManager.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false, 1, 1));
								cmbManager.setData(ControlValidator.labelKey, strManager);
								
								for(IHinemosManager manager: Activator.getDefault().getHinemosManagers()){
									cmbManager.add(manager.getManagerName());
									cmbManager.setData(manager.getManagerName(), manager);
								}
		
				Label lblCloudScopeId = new Label(composite, SWT.RIGHT);
				lblCloudScopeId.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
				lblCloudScopeId.setText(strCloudScopeId + strSeparator);
		
				txtCloudScopeId = new Text(composite, SWT.BORDER);
				txtCloudScopeId.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
				txtCloudScopeId.setData(ControlValidator.labelKey, strCloudScopeId);
						
								Label lblCloudScopeName = new Label(composite, SWT.RIGHT);
								lblCloudScopeName.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
								lblCloudScopeName.setText(strCloudScopeName + strSeparator);
						
								txtCloudScopeName = new Text(composite, SWT.BORDER);
								txtCloudScopeName.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
								txtCloudScopeName.setData(ControlValidator.labelKey, strCloudScopeName);
								
						Label label = new Label(composite, SWT.NONE);
						label.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
						label.setText(strOwnerRole + strSeparator);
						
						cmbAssignRoleId = new Combo(composite, SWT.NONE);
						cmbAssignRoleId.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 1, 1));
				
						Label lblDescription = new Label(composite, SWT.RIGHT);
						lblDescription.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
						lblDescription.setText(strDescription + strSeparator);
				
						txtDescription = new Text(composite, SWT.BORDER);
						txtDescription.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		
		Group grpManagerAccount = new Group(container, SWT.NONE);
		GridLayout gl_managerAccount = new GridLayout(2, false);
		grpManagerAccount.setLayout(gl_managerAccount);
		grpManagerAccount.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false, 2, 1));
		grpManagerAccount.setText(strManagerAccount);
		
				Label lblAccessKey = new Label(grpManagerAccount, SWT.RIGHT);
				lblAccessKey.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
				lblAccessKey.setText(strAccessKey + strSeparator);
				
						txtAccessKey = new Text(grpManagerAccount, SWT.BORDER);
						txtAccessKey.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
						txtAccessKey.setData(ControlValidator.labelKey, strAccessKey);
												
														Label lblSecretKey = new Label(grpManagerAccount, SWT.RIGHT);
														lblSecretKey.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
														lblSecretKey.setText(strSecretKey + strSeparator);
												
														txtSecretKey = new Text(grpManagerAccount, SWT.BORDER | SWT.PASSWORD);
														txtSecretKey.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
														txtSecretKey.setData(ControlValidator.labelKey, strSecretKey);
										
												Label lblAccountId = new Label(grpManagerAccount, SWT.RIGHT);
												lblAccountId.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
												lblAccountId.setText(strAccountId + strSeparator);
										
												txtAccountId = new Text(grpManagerAccount, SWT.BORDER);
												txtAccountId.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
												txtAccountId.setData(ControlValidator.labelKey, strAccountId);
										
												Label lblDisplayName = new Label(grpManagerAccount, SWT.RIGHT);
												lblDisplayName.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
												lblDisplayName.setText(strDisplayName + strSeparator);
										
												txtDisplayName = new Text(grpManagerAccount, SWT.BORDER);
												txtDisplayName.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
												txtDisplayName.setData(ControlValidator.labelKey, strDisplayName);
																		
												grpManagerAccount.layout(true);
		
		cmbManager.setEnabled(!edit);
		txtCloudScopeId.setEnabled(!edit);
		cmbAssignRoleId.setEnabled(!edit);
		txtAccountId.setEnabled(!edit);
												
		if (cmbManager.getItemCount() > 0) {
			cmbManager.select(0);
		}
		
		if(dialogData != null){
			cmbManager.setText(dialogData.getManagerName());
			txtCloudScopeId.setText(dialogData.getCloudScopeId());
			txtCloudScopeName.setText(dialogData.getCloudScopeName());
			txtDescription.setText(dialogData.getDescription() == null ? "": dialogData.getDescription());
			txtAccessKey.setText(dialogData.getAccessKey() == null ? "": dialogData.getAccessKey());
			txtSecretKey.setText(dialogData.getSecretKey() == null ? "": dialogData.getSecretKey());
			txtAccountId.setText(dialogData.getAccountId() == null ? "": dialogData.getAccountId());
			txtDisplayName.setText(dialogData.getDisplayName() == null ? "": dialogData.getDisplayName());
			for (String item: cmbAssignRoleId.getItems()) {
				String roleId = (String)cmbAssignRoleId.getData(item);
				if (roleId.equals(dialogData.getOwnerRoleId())) {
					cmbAssignRoleId.setText(item);
					break;
				}
			}
		}
		
		
		ControlUtil.setRequired(new Control[]{
			txtCloudScopeId,
			txtCloudScopeName,
			txtAccountId,
			txtAccessKey,
			txtSecretKey,
			txtDisplayName
		});
		
		if (!PlatformDependent.getPlatformDependent().isRapPlatfome()) {
			container.layout();
			Control[] labels = new Control[]{lblManager, lblCloudScopeId, lblCloudScopeName, lblDescription, lblAccountId, lblAccessKey, lblSecretKey, lblDisplayName};
			int maxWidth = 0;
			for (Control l: labels) {
				Point p = l.getSize();
				maxWidth = Math.max(maxWidth, p.x);
			}
			for (Control l: labels) {
				((GridData)l.getLayoutData()).widthHint = maxWidth;
			}
		}
		
		return area;
	}

	/**
	 * Create contents of the button bar.
	 * @param parent
	 */
	@Override
	protected void createButtonsForButtonBar(Composite parent) {
		createButton(parent, IDialogConstants.OK_ID, IDialogConstants.OK_LABEL,
				false);
		createButton(parent, IDialogConstants.CANCEL_ID,
				IDialogConstants.CANCEL_LABEL, false);
	}

	/**
	 * Return the initial size of the dialog.
	 */
	@Override
	protected Point getInitialSize() {
		return new Point(450, 414);
	}

	@Override
	protected void okPressed() {
		try{
			ControlUtil.validate(this);
		} catch(ValidateException e){
			MessageDialog.openError(null, Messages.getString("failed"), e.getMessage());
			return;
		} catch(Exception e){
			throw new RuntimeException(e);
		}
		
		DialogData dialogData = getDialogData();
		
		{
			dialogData.setManagerName(cmbManager.getText());
			dialogData.setCloudScopeId(txtCloudScopeId.getText());
			dialogData.setCloudScopeName(txtCloudScopeName.getText());
			dialogData.setDescription(txtDescription.getText());
			dialogData.setAccountId(txtAccountId.getText());
			dialogData.setAccessKey(txtAccessKey.getText());
			dialogData.setSecretKey(txtSecretKey.getText());
			dialogData.setDisplayName(txtDisplayName.getText());
			dialogData.setOwnerRoleId((String)cmbAssignRoleId.getData(cmbAssignRoleId.getText()));
		}

		// リオープンされた場合のために、null を代入
		currentManager = null;

		setReturnCode(OK);
		close();
	}

	@Override
	protected void configureShell(Shell newShell) {
		super.configureShell(newShell);
		newShell.setText(MessageFormat.format(dlgLoginuserRegistModify, strAws));
	}

	public DialogData getDialogData() {
		if (dialogData == null)
			dialogData = new DialogData();
		return dialogData;
	}
	public void setDialogData(DialogData dialogData) {
		this.dialogData = dialogData;
	}
}
