package com.clustercontrol.xcloud.aws.ui.dialogs.job;

import static com.clustercontrol.xcloud.aws.common.AWSConstants.EPROP_AvailabilityZone;

import java.util.List;

import org.eclipse.jface.wizard.WizardPage;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Label;

import com.clustercontrol.ws.xcloud.ExtendedProperty;
import com.clustercontrol.ws.xcloud.Instance;
import com.clustercontrol.xcloud.aws.common.AWSStringConstants;
import com.clustercontrol.xcloud.aws.ui.dialogs.AWSResourceProvider;
import com.clustercontrol.xcloud.common.CloudStringConstants;
import com.clustercontrol.xcloud.model.cloud.IInstance;
import com.clustercontrol.xcloud.model.cloud.IStorage;
import com.clustercontrol.xcloud.util.ControlUtil;
import org.eclipse.swt.widgets.Text;

public class SelectInstancePage extends WizardPage implements CloudStringConstants, AWSStringConstants {
	public static final long serialVersionUID = 1L;
	public static final String pageName = SelectInstancePage.class.getName();

	private Combo cmbInstances;
	private IStorage storage;
	private AWSResourceProvider provider;
	private Text text;

	/**
	 * Create the wizard.
	 */
	public SelectInstancePage(IStorage storage) {
		super(pageName);
		setTitle(msgSelectComputeSammay);
		setDescription(msgSelectCompute);
		this.storage = storage;
		this.provider = new AWSResourceProvider(storage.getLocation());
	}

	/**
	 * Create contents of the wizard.
	 * @param parent
	 */
	public void createControl(Composite parent) {
		Composite container = new Composite(parent, SWT.NULL);

		setControl(container);
		container.setLayout(new GridLayout(3, false));
		
		Label lblNewLabel = new Label(container, SWT.RIGHT);
		lblNewLabel.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
		lblNewLabel.setText(strComputeId + strSeparator);
		
		cmbInstances = new Combo(container, SWT.BORDER);
		cmbInstances.addModifyListener(new ModifyListener() {
			public void modifyText(ModifyEvent e) {
				getContainer().updateButtons();
			}
		});
		cmbInstances.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false, 2, 1));
		
		String availabilityZone = storage.getExtendedProperty(EPROP_AvailabilityZone);
		List<Instance> instances = provider.getInstances();
		for (Instance instance: instances) {
			for (ExtendedProperty prop: instance.getExtendedProperties()) {
				if (!prop.getName().equals(EPROP_AvailabilityZone))
					continue;
				if (prop.getValue().equals(availabilityZone)) {
					String instanceItem = String.format("%s (%s)", instance.getName(), instance.getId());
					cmbInstances.add(instanceItem);
					cmbInstances.setData(instanceItem, instance);
				}
				break;
			}
		}
		
		Label lblNewLabel_1 = new Label(container, SWT.NONE);
		lblNewLabel_1.setAlignment(SWT.RIGHT);
		lblNewLabel_1.setLayoutData(new GridData(SWT.RIGHT, SWT.CENTER, false, false, 1, 1));
		lblNewLabel_1.setText(strDevice + strSeparator);
		
		text = new Text(container, SWT.BORDER);
		text.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, true, false, 2, 1));
		
		ControlUtil.setRequired(cmbInstances, text);
	}
	
	public Instance getInstance() {
		return (Instance)cmbInstances.getData(cmbInstances.getText());
	}
	
	public String getDevice() {
		return text.getText();
	}

	public void setInstance(String instanceId) {
		for (String item: cmbInstances.getItems()) {
			IInstance instance = (IInstance)cmbInstances.getData(item);
			if (instance.getId().equals(instanceId)) {
				cmbInstances.setText(item);
				break;
			}
		}
	}
	
	@Override
	public boolean isPageComplete() {
		return super.isPageComplete() && cmbInstances.getText() != null && !cmbInstances.getText().isEmpty() &&
				text.getText() != null && text.getText().isEmpty();
	}
}