package com.clustercontrol.xcloud.ui.handlers;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.List;

import org.apache.log4j.Logger;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.handlers.HandlerUtil;

import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.notify.NotifyRelationInfo;
import com.clustercontrol.ws.xcloud.CloudEndpoint;
import com.clustercontrol.ws.xcloud.CloudManagerException;
import com.clustercontrol.ws.xcloud.ModifyBillingAlarmRequest;
import com.clustercontrol.ws.xcloud.MonitorKind;
import com.clustercontrol.xcloud.common.CloudStringConstants;
import com.clustercontrol.xcloud.model.cloud.IBillingAlarm;
import com.clustercontrol.xcloud.model.cloud.IHinemosManager;
import com.clustercontrol.xcloud.ui.dialogs.CreateBillingAlarmDialog;

public class ModifyBillingAlarmHandler extends AbstractHandler implements CloudStringConstants {
	@Override
	public Object execute(ExecutionEvent event) throws ExecutionException {
		IStructuredSelection selection = (IStructuredSelection)HandlerUtil.getActiveSite(event).getSelectionProvider().getSelection();
		final IBillingAlarm billingAlarm = (IBillingAlarm)selection.getFirstElement();
		final IHinemosManager manager = (IHinemosManager)billingAlarm.getAdapter(IHinemosManager.class);

		CreateBillingAlarmDialog dialog = new CreateBillingAlarmDialog(HandlerUtil.getActiveShell(event), manager.getManagerName());
		
		final ModifyBillingAlarmRequest request = new ModifyBillingAlarmRequest();
		request.setAlarmId(billingAlarm.getId());
		request.setAlarmName(billingAlarm.getName());
		request.setDescription(billingAlarm.getDescription());
		request.setFacilityId(billingAlarm.getFacilityId());
		request.setMonitorKind(billingAlarm.getMonitorKind());
		request.setThresholdInfoLimit(billingAlarm.getThresholdInfoLimit());
		request.setThresholdWarnLimit(billingAlarm.getThresholdWarnLimit());
		request.setUnit(billingAlarm.getUnit());
		request.setValidFlg(billingAlarm.getValidFlg());
		request.setCollectFlg(billingAlarm.getCollectFlg());
		request.getNotifyRelationInfos().addAll(billingAlarm.getNotifyRelationInfos());
		dialog.setDialogData(
				new CreateBillingAlarmDialog.DialogData() {
					@Override
					public String getAlarmId() {
						return request.getAlarmId();
					}
					@Override
					public void setAlarmId(String value) {
					}
					@Override
					public String getAlarmName() {
						return request.getAlarmName();
					}
					@Override
					public void setAlarmName(String value) {
						request.setAlarmName(value);
					}
					@Override
					public String getDescription() {
						return request.getDescription();
					}
					@Override
					public void setDescription(String value) {
						request.setDescription(value);
					}
					@Override
					public String getFacilityId() {
						return request.getFacilityId();
					}
					@Override
					public void setFacilityId(String value) {
						request.setFacilityId(value);
					}
					@Override
					public MonitorKind getMonitorKind() {
						return request.getMonitorKind();
					}
					@Override
					public void setMonitorKind(MonitorKind value) {
						request.setMonitorKind(value);
					}
					@Override
					public List<NotifyRelationInfo> getNotifyRelationInfos() {
						return request.getNotifyRelationInfos();
					}
					@Override
					public void setNotifyRelationInfos(List<NotifyRelationInfo> value) {
						request.getNotifyRelationInfos().clear();
						request.getNotifyRelationInfos().addAll(value);
					}
					@Override
					public Double getThresholdInfoLimit() {
						return request.getThresholdInfoLimit();
					}
					@Override
					public void setThresholdInfoLimit(Double value) {
						request.setThresholdInfoLimit(value);
					}
					@Override
					public Double getThresholdWarnLimit() {
						return request.getThresholdWarnLimit();
					}
					@Override
					public void setThresholdWarnLimit(Double value) {
						request.setThresholdWarnLimit(value);
					}
					@Override
					public Boolean getValidFlg() {
						return request.isValidFlg();
					}
					@Override
					public void setValidFlg(Boolean value) {
						request.setValidFlg(value);
					}
					@Override
					public String getOwnerRoleId() {
						return billingAlarm.getOwnerRoleId();
					}
					@Override
					public void setOwnerRoleId(String value) {
					}
					@Override
					public Boolean getCollectFlg() {
						return request.isCollectFlg();
					}
					@Override
					public void setCollectFlg(Boolean value) {
						request.setCollectFlg(value);
					}
				});
		
		loop_end:
		while(true){
			try {
				if (dialog.open() != Window.OK)
					break loop_end;
			} catch (Exception e) {
				Logger logger = Logger.getLogger(this.getClass());
				logger.error(e.getMessage(), e);

				String message = e.getMessage();
				if (message == null) {
					ByteArrayOutputStream bos = new ByteArrayOutputStream();
					PrintStream ps = new PrintStream(bos, true);
					e.printStackTrace(ps);
					
					message = bos.toString();
				}
				
				// 失敗報告ダイアログを生成
				MessageDialog.openError(null, Messages.getString("failed"), message);
				break;
			}
		
			if (MessageDialog.openConfirm(
					null,
					Messages.getString("confirmed"),
					MessageFormat.format(msgConfirmModifyBilligAlarm, request.getAlarmName(), request.getAlarmId())
					)) {
				
				try {
					CloudEndpoint endpoint = manager.getEndpoint(CloudEndpoint.class);
					endpoint.modifyBillingAlarm(request);
					
					// 成功報告ダイアログを生成
					MessageDialog.openInformation(
						null,
						Messages.getString("successful"),
						MessageFormat.format(msgFinishModifyBilligAlarm, request.getAlarmName(), request.getAlarmId()));
					
					Display.getCurrent().asyncExec(new Runnable() {
						@Override
						public void run() {
							manager.getBillingAlarms().updateBillingAlarms();
						}
					});
					
					break loop_end;
				} catch (Exception e) {
					Logger logger = Logger.getLogger(this.getClass());
					logger.error(e.getMessage(), e);
		
					String message = e.getMessage();
					if (message == null) {
						ByteArrayOutputStream bos = new ByteArrayOutputStream();
						PrintStream ps = new PrintStream(bos, true);
						e.printStackTrace(ps);
						
						message = bos.toString();
					}
					
					if (e instanceof CloudManagerException) {
						CloudManagerException cme = (CloudManagerException)e;
						if ("UNSUPPORTED_OPERATION".equals(cme.getFaultInfo().getErrorCode())) {
							message = msgFucUnSupported;
						}
					}
					
					// 失敗報告ダイアログを生成
					MessageDialog.openError(null, Messages.getString("failed"), message);
				}
			}
		}
		return null;
	}
}
