/*
Copyright (C) 2015 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.xcloud.ui.dialogs;

import static com.clustercontrol.xcloud.common.CloudConstants.bundle_messages;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.eclipse.wb.swt.SWTResourceManager;

import com.clustercontrol.util.Messages;
import com.clustercontrol.xcloud.util.ControlUtil;

public class CreateCloudServiceDialog extends Dialog {
	public static final long serialVersionUID = 1L;
	
	public static class DialogOutput{
		private String serviceId;
		private String serviceName;
		private String environmentInfo;
		private String masterId;
		
		public String getServiceId() {
			return serviceId;
		}
		public void setServiceId(String serviceId) {
			this.serviceId = serviceId;
		}
		public String getEnvironmentInfo() {
			return environmentInfo;
		}
		public void setEnvironmentInfo(String environmentInfo) {
			this.environmentInfo = environmentInfo;
		}
		public String getServiceName() {
			return serviceName;
		}
		public void setServiceName(String serviceName) {
			this.serviceName = serviceName;
		}
		public String getMasterId() {
			return masterId;
		}
		public void setMasterId(String masterId) {
			this.masterId = masterId;
		}
	}
	
	private DialogOutput output = new DialogOutput();

	private String strCloudService = bundle_messages.getString("word.cloud_service");
	private String strSeparator = bundle_messages.getString("caption.title_separator");
	private String strServiceId = bundle_messages.getString("word.service_id");
	private String strServiceName = bundle_messages.getString("word.service_name");
	private String strEnvironmentInfo = bundle_messages.getString("word.environment_info");
	private String strMasterId = bundle_messages.getString("word.master_id");
	
	private Text serviceId;
	private Text serviceName;
	private Text environmentInfo;
	private Text masterId;

	
	/**
	 * Create the dialog.
	 * @param parentShell
	 */
	public CreateCloudServiceDialog(Shell parentShell) {
		super(parentShell);
	}

	/**
	 * Create contents of the dialog.
	 * @param parent
	 */
	@Override
	protected Control createDialogArea(Composite parent) {
		Composite area = (Composite) super.createDialogArea(parent);
		Composite container = new Composite(area, SWT.FILL);
		container.setBackground(SWTResourceManager.getColor(SWT.COLOR_WIDGET_BACKGROUND));
		GridLayout gl_container = new GridLayout(1, false);
		gl_container.verticalSpacing = 15;
		container.setLayout(gl_container);
		GridData gd_container = new GridData(SWT.FILL, SWT.FILL, true, false);
		gd_container.verticalAlignment = SWT.FILL;
		gd_container.horizontalAlignment = SWT.FILL;
		container.setLayoutData(gd_container);
		
		{
			Group grpCloudUser = new Group(container, SWT.NONE);
			GridLayout gl_cloudUser = new GridLayout(2, false);
			gl_cloudUser.verticalSpacing = 15;
			grpCloudUser.setLayout(gl_cloudUser);
			grpCloudUser.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, false));
			grpCloudUser.setText(strCloudService);
			
			Label lblserviceId = new Label(grpCloudUser, SWT.RIGHT);
			lblserviceId.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
			lblserviceId.setText(strServiceId + strSeparator);
	
			serviceId = new Text(grpCloudUser, SWT.BORDER);
			serviceId.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
	
			Label lblserviceName = new Label(grpCloudUser, SWT.RIGHT);
			lblserviceName.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
			lblserviceName.setText(strServiceName + strSeparator);
	
			serviceName = new Text(grpCloudUser, SWT.BORDER);
			serviceName.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
	
			Label lblDescription = new Label(grpCloudUser, SWT.RIGHT);
			lblDescription.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
			lblDescription.setText(strEnvironmentInfo + strSeparator);
	
			environmentInfo = new Text(grpCloudUser, SWT.BORDER);
			environmentInfo.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));

			Label lblAccessKey = new Label(grpCloudUser, SWT.RIGHT);
			lblAccessKey.setLayoutData(new GridData(SWT.FILL, SWT.CENTER, false, false, 1, 1));
			lblAccessKey.setText(strMasterId + strSeparator);
	
			masterId = new Text(grpCloudUser, SWT.BORDER);
			masterId.setLayoutData(new GridData(SWT.FILL, SWT.FILL, true, true, 1, 1));
		}
		
		//初期化ブロック
		{
			
		}
		
		ControlUtil.setRequired(new Control[]{});

		return area;
	}

	/**
	 * Create contents of the button bar.
	 * @param parent
	 */
	@Override
	protected void createButtonsForButtonBar(Composite parent) {
		createButton(parent, IDialogConstants.OK_ID, IDialogConstants.OK_LABEL,
				false);
		createButton(parent, IDialogConstants.CANCEL_ID,
				IDialogConstants.CANCEL_LABEL, false);
	}

	/**
	 * Return the initial size of the dialog.
	 */
	@Override
	protected Point getInitialSize() {
		return new Point(640, 480);
	}

	@Override
	protected void okPressed() {
		if(serviceId.getText() == ""
		){
			MessageDialog.openError(null,
					Messages.getString("failed"),
					bundle_messages.getString("message.must_fully_input"));
			return;
		}
		
		{
			output.setServiceId(serviceId.getText());
			output.setServiceName(serviceName.getText());
			output.setEnvironmentInfo(environmentInfo.getText());
			output.setMasterId(masterId.getText());

		}

		setReturnCode(OK);
		close();
	}

	@Override
	protected void configureShell(Shell newShell) {
		super.configureShell(newShell);
		newShell.setText(bundle_messages.getString("caption.create_cloud_service_dialog"));
	}

	public DialogOutput getOutput() {
		return output;
	}
}
