package com.clustercontrol.collectiverun.model;

import java.io.Serializable;
import java.util.Arrays;

import javax.persistence.*;

/**
 * The primary key class for the cc_crun_session_param database table.
 * 
 */
@Embeddable
public class CrunSessionParamEntityPK implements Serializable {
	//default serial version id, required for serializable classes.
	private static final long serialVersionUID = 1L;
	private String sessionId;
	private String paramId;

	public CrunSessionParamEntityPK() {
	}

	public CrunSessionParamEntityPK(String sessionId, String paramId) {
		this.setSessionId(sessionId);
		this.setParamId(paramId);
	}

	@Column(name="session_id")
	public String getSessionId() {
		return this.sessionId;
	}
	public void setSessionId(String sessionId) {
		this.sessionId = sessionId;
	}

	@Column(name="param_id")
	public String getParamId() {
		return this.paramId;
	}
	public void setParamId(String paramId) {
		this.paramId = paramId;
	}

	@Override
	public boolean equals(Object other) {
		if (this == other) {
			return true;
		}
		if (!(other instanceof CrunSessionParamEntityPK)) {
			return false;
		}
		CrunSessionParamEntityPK castOther = (CrunSessionParamEntityPK)other;
		return
				this.sessionId.equals(castOther.sessionId)
				&& this.paramId.equals(castOther.paramId);
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int hash = 17;
		hash = hash * prime + this.sessionId.hashCode();
		hash = hash * prime + this.paramId.hashCode();

		return hash;
	}

	@Override
	public String toString() {
		String[] names = {
				"sessionId",
				"paramId"
		};
		String[] values = {
				this.sessionId,
				this.paramId
		};
		return Arrays.toString(names) + " = " + Arrays.toString(values);
	}
}