package com.clustercontrol.collectiverun.model;

import java.io.Serializable;
import javax.persistence.*;

import com.clustercontrol.commons.util.JpaTransactionManager;

import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;


/**
 * The persistent class for the cc_crun_session_detail database table.
 * 
 */
@Entity
@Table(name="cc_crun_session_detail")
public class CrunSessionDetailEntity implements Serializable {
	private static final long serialVersionUID = 1L;
	private CrunSessionDetailEntityPK id;
	private Timestamp endDate;
	private Integer endStatus;
	private Integer endValue;
	private String errorMessage;
	private String facilityName;
	private String message;
	private Timestamp startDate;
	private Integer status;
	private CrunSessionEntity crunSessionEntity;

	@Deprecated
	public CrunSessionDetailEntity() {
	}

	public CrunSessionDetailEntity(CrunSessionDetailEntityPK pk,
			CrunSessionEntity crunSessionEntity) {
		this.setId(pk);
		EntityManager em = new JpaTransactionManager().getEntityManager();
		em.persist(this);
		this.relateToCrunSessionEntity(crunSessionEntity);
	}

	public CrunSessionDetailEntity(CrunSessionEntity crunSessionEntity, String facilityId) {
		this(new CrunSessionDetailEntityPK(
				crunSessionEntity.getSessionId(),
				facilityId), crunSessionEntity);
	}

	@EmbeddedId
	public CrunSessionDetailEntityPK getId() {
		return this.id;
	}

	public void setId(CrunSessionDetailEntityPK id) {
		this.id = id;
	}


	@Column(name="end_date")
	public Timestamp getEndDate() {
		return this.endDate;
	}

	public void setEndDate(Timestamp endDate) {
		this.endDate = endDate;
	}


	@Column(name="end_status")
	public Integer getEndStatus() {
		return this.endStatus;
	}

	public void setEndStatus(Integer endStatus) {
		this.endStatus = endStatus;
	}


	@Column(name="end_value")
	public Integer getEndValue() {
		return this.endValue;
	}

	public void setEndValue(Integer endValue) {
		this.endValue = endValue;
	}


	@Column(name="error_message")
	public String getErrorMessage() {
		return this.errorMessage;
	}

	public void setErrorMessage(String errorMessage) {
		this.errorMessage = errorMessage;
	}


	@Column(name="facility_name")
	public String getFacilityName() {
		return this.facilityName;
	}

	public void setFacilityName(String facilityName) {
		this.facilityName = facilityName;
	}


	public String getMessage() {
		return this.message;
	}

	public void setMessage(String message) {
		this.message = message;
	}


	@Column(name="start_date")
	public Timestamp getStartDate() {
		return this.startDate;
	}

	public void setStartDate(Timestamp startDate) {
		this.startDate = startDate;
	}


	public Integer getStatus() {
		return this.status;
	}

	public void setStatus(Integer status) {
		this.status = status;
	}


	//bi-directional many-to-one association to CrunSessionEntity
	@ManyToOne(fetch=FetchType.LAZY)
	@JoinColumn(name="session_id", insertable=false, updatable=false)
	public CrunSessionEntity getCrunSessionEntity() {
		return this.crunSessionEntity;
	}

	@Deprecated
	public void setCrunSessionEntity(CrunSessionEntity crunSessionEntity) {
		this.crunSessionEntity = crunSessionEntity;
	}

	/**
	 * CrunSessionEntityオブジェクト参照設定<BR>
	 * 
	 * CrunSessionEntity設定時はSetterに代わりこちらを使用すること。
	 * 
	 * JPAの仕様(JSR 220)では、データ更新に伴うrelationshipの管理はユーザに委ねられており、
	 * INSERTやDELETE時に、そのオブジェクトに対する参照をメンテナンスする処理を実装する。
	 * 
	 * JSR 220 3.2.3 Synchronization to the Database
	 * 
	 * Bidirectional relationships between managed entities will be persisted
	 * based on references held by the owning side of the relationship.
	 * It is the developer’s responsibility to keep the in-memory references
	 * held on the owning side and those held on the inverse side consistent
	 * with each other when they change.
	 */
	public void relateToCrunSessionEntity(CrunSessionEntity crunSessionEntity) {
		this.setCrunSessionEntity(crunSessionEntity);
		if (crunSessionEntity != null) {
			List<CrunSessionDetailEntity> list = crunSessionEntity.getCrunSessionDetailEntities();
			if (list == null) {
				list = new ArrayList<CrunSessionDetailEntity>();
			} else {
				for(CrunSessionDetailEntity entity : list){
					if (entity.getId().equals(this.getId())) {
						return;
					}
				}
			}
			list.add(this);
			crunSessionEntity.setCrunSessionDetailEntities(list);
		}
	}


	/**
	 * 削除前処理<BR>
	 * 
	 * JPAの仕様(JSR 220)では、データ更新に伴うrelationshipの管理はユーザに委ねられており、
	 * INSERTやDELETE時に、そのオブジェクトに対する参照をメンテナンスする処理を実装する。
	 * 
	 * JSR 220 3.2.3 Synchronization to the Database
	 * 
	 * Bidirectional relationships between managed entities will be persisted
	 * based on references held by the owning side of the relationship.
	 * It is the developer’s responsibility to keep the in-memory references
	 * held on the owning side and those held on the inverse side consistent
	 * with each other when they change.
	 */
	public void unchain() {

		// CrunSessionEntity
		if (this.crunSessionEntity != null) {
			List<CrunSessionDetailEntity> list = this.crunSessionEntity.getCrunSessionDetailEntities();
			if (list != null) {
				Iterator<CrunSessionDetailEntity> iter = list.iterator();
				while(iter.hasNext()) {
					CrunSessionDetailEntity entity = iter.next();
					if (entity.getId().equals(this.getId())){
						iter.remove();
						break;
					}
				}
			}
		}
	}

}