package com.clustercontrol.collectiverun.model;

import java.io.Serializable;
import java.util.Arrays;

import javax.persistence.*;

/**
 * The primary key class for the cc_crun_cmd_param_mst database table.
 * 
 */
@Embeddable
public class CrunCmdParamMstEntityPK implements Serializable {
	//default serial version id, required for serializable classes.
	private static final long serialVersionUID = 1L;
	private String commandId;
	private String paramId;

	public CrunCmdParamMstEntityPK() {
	}

	public CrunCmdParamMstEntityPK(String commandId, String paramId) {
		this.setCommandId(commandId);
		this.setParamId(paramId);
	}

	@Column(name="command_id")
	public String getCommandId() {
		return this.commandId;
	}
	public void setCommandId(String commandId) {
		this.commandId = commandId;
	}

	@Column(name="param_id")
	public String getParamId() {
		return this.paramId;
	}
	public void setParamId(String paramId) {
		this.paramId = paramId;
	}

	@Override
	public boolean equals(Object other) {
		if (this == other) {
			return true;
		}
		if (!(other instanceof CrunCmdParamMstEntityPK)) {
			return false;
		}
		CrunCmdParamMstEntityPK castOther = (CrunCmdParamMstEntityPK)other;
		return
				this.commandId.equals(castOther.commandId)
				&& this.paramId.equals(castOther.paramId);
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int hash = 17;
		hash = hash * prime + this.commandId.hashCode();
		hash = hash * prime + this.paramId.hashCode();

		return hash;
	}

	@Override
	public String toString() {
		String[] names = {
				"commandId",
				"paramId"
		};
		String[] values = {
				this.commandId,
				this.paramId
		};
		return Arrays.toString(names) + " = " + Arrays.toString(values);
	}
}