/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.snmptrap.dialog;

import java.util.ArrayList;
import java.util.List;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;

import com.clustercontrol.dialog.CommonDialog;
import com.clustercontrol.dialog.ValidateResult;
import com.clustercontrol.snmptrap.composite.MasterListComposite;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.monitor.MonitorTrapValueInfo;
import com.clustercontrol.ws.monitor.SnmpTrapMasterInfo;

/**
 * SNMPTRAP監視 マスタ選択ダイアログクラス<BR>
 * 
 * @version 4.0.0
 * @since 2.1.0
 */
public class SnmpTrapMasterDialog extends CommonDialog {

	public static final int WIDTH_TITLE = 5;
	public static final int WIDTH_VALUE = 2;

	// ----- instance フィールド ----- //

	/** 入力値を保持するオブジェクト */
	private ArrayList<SnmpTrapMasterInfo> inputData = null;

	/** 入力値の正当性を保持するオブジェクト */
	protected ValidateResult validateResult = null;

	/** マスタテーブル */
	private MasterListComposite masterListComposite = null;

	/** OID情報 */
	private List<MonitorTrapValueInfo> oidList = null;

	// ----- コンストラクタ ----- //

	/**
	 * 作成用ダイアログのインスタンスを返します。
	 * 
	 * @param parent 親のシェルオブジェクト
	 * @param monitorType 監視判定タイプ
	 */
	public SnmpTrapMasterDialog(Shell parent) {
		super(parent);
		setShellStyle(getShellStyle() | SWT.RESIZE | SWT.MAX);
	}

	// ----- instance メソッド ----- //

	/**
	 * ダイアログの初期サイズを返します。
	 * 
	 * @return 初期サイズ
	 */
	@Override
	protected Point getInitialSize() {
		return new Point(750, 400);
	}

	/**
	 * ダイアログエリアを生成します。
	 * 
	 * @param parent
	 *            親のインスタンス
	 */
	@Override
	protected void customizeDialog(Composite parent) {
		Shell shell = this.getShell();

		// タイトル
		shell.setText(Messages.getString("dialog.snmptrap.add.definition"));

		// 変数として利用されるグリッドデータ
		GridData gridData = null;

		// レイアウト
		GridLayout layout = new GridLayout(1, true);
		layout.marginWidth = 10;
		layout.marginHeight = 10;
		layout.numColumns = 15;
		parent.setLayout(layout);

		/*
		 * マスタテーブル
		 */
		this.masterListComposite = new MasterListComposite(parent, SWT.NONE);
		gridData = new GridData();
		gridData.horizontalSpan = 15;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.verticalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		gridData.grabExcessVerticalSpace = true;
		this.masterListComposite.setLayoutData(gridData);
		this.masterListComposite.setOidList(oidList);

		// ラインを引く
		Label line = new Label(parent, SWT.SEPARATOR | SWT.HORIZONTAL);
		gridData = new GridData();
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		gridData.horizontalSpan = 15;
		line.setLayoutData(gridData);

		// 画面中央に
		Display display = shell.getDisplay();
		shell.setLocation((display.getBounds().width - shell.getSize().x) / 2,
				(display.getBounds().height - shell.getSize().y) / 2);

		// 初期表示
		this.setInputData();

	}

	/**
	 * 入力内容を返します。
	 * 
	 * @return 入力内容を保持した通知情報
	 */
	public ArrayList<SnmpTrapMasterInfo> getInputData() {
		return this.inputData;
	}

	/**
	 * 各項目に入力値を設定します。
	 * 
	 * @param monitor
	 *            設定値として用いる監視情報
	 */
	protected void setInputData() {

		masterListComposite.update();

	}

	/**
	 * 入力値チェックをします。
	 * 
	 * @return 検証結果
	 */
	@Override
	protected ValidateResult validate() {
		// 入力値生成
		this.inputData = masterListComposite.getSelectMaster();

		if (this.inputData != null) {
			return super.validate();
		} else {
			return validateResult;
		}
	}

	/**
	 * ＯＫボタンのテキストを返します。
	 * 
	 * @return ＯＫボタンのテキスト
	 */
	@Override
	protected String getOkButtonText() {
		return Messages.getString("add");
	}

	/**
	 * キャンセルボタンのテキストを返します。
	 * 
	 * @return キャンセルボタンのテキスト
	 */
	@Override
	protected String getCancelButtonText() {
		return Messages.getString("cancel");
	}


	/**
	 * @return
	 */
	public List<MonitorTrapValueInfo> getOidList() {
		return oidList;
	}

	/**
	 * @param oidList
	 */
	public void setOidList(List<MonitorTrapValueInfo> oidList) {
		this.oidList = oidList;
	}
}