/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.snmptrap.composite;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.jface.viewers.Viewer;
import org.eclipse.jface.viewers.ViewerFilter;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Combo;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Table;
import org.eclipse.swt.widgets.Text;
import org.eclipse.ui.PlatformUI;

import com.clustercontrol.bean.DataRangeConstant;
import com.clustercontrol.bean.YesNoConstant;
import com.clustercontrol.composite.action.StringVerifyListener;
import com.clustercontrol.snmptrap.action.GetMaster;
import com.clustercontrol.snmptrap.action.GetOidTableDefine;
import com.clustercontrol.snmptrap.dialog.SnmpTrapCreateDialog;
import com.clustercontrol.snmptrap.dialog.SnmpTrapMasterDialog;
import com.clustercontrol.snmptrap.dialog.SnmpTrapModifyDialog;
import com.clustercontrol.util.Messages;
import com.clustercontrol.viewer.CommonTableViewer;
import com.clustercontrol.ws.monitor.MonitorTrapValueInfo;
import com.clustercontrol.ws.monitor.SnmpTrapMasterInfo;

/**
 * SNMPTRAP監視OID一覧コンポジットクラス<BR>
 * 
 * @version 4.0.0
 * @since 2.1.0
 */
public class OidListComposite extends Composite {

	// ログ
	private static Log m_log = LogFactory.getLog( OidListComposite.class );

	public static final int MAX_COLUMN = SnmpTrapCreateDialog.MAX_COLUMN;
	public static final int WIDTH_TITLE = SnmpTrapCreateDialog.WIDTH_TITLE;
	public static final int WIDTH_VALUE = SnmpTrapCreateDialog.WIDTH_VALUE;
	public static final int WIDTH_TITLE_WIDE = SnmpTrapCreateDialog.WIDTH_TITLE_WIDE;
	public static final int WIDTH_TITLE_SMALL = SnmpTrapCreateDialog.WIDTH_TITLE_SMALL;

	// ----- instance フィールド ----- //

	private List<MonitorTrapValueInfo> oidList = null;

	/** テーブルビューア */
	private CommonTableViewer tableViewer = null;

	/** MIB */
	private Combo comboMib = null;

	/** フィルタ */
	private Text textFilter = null;

	/** フィルタクリアボタン */
	private Button buttonClearFilter = null;

	/** 表示ボタン */
	private Button buttonShowOidTable = null;

	/** 追加ボタン */
	private Button buttonAdd = null;

	/** 更新ボタン */
	private Button buttonModify = null;

	/** 削除ボタン */
	private Button buttonDelete = null;

	private String monitorId = null;

	private  Table table = null;

	/**未登録・登録OIDすべてなど対応修正**/

	private Button radioSpecific = null;
	private Button radioAll = null;
	private Button radioUnregistered = null;


	// ----- コンストラクタ ----- //

	/**
	 * インスタンスを返します。
	 * 
	 * @param parent
	 *            親のコンポジット
	 * @param style
	 *            スタイル
	 */
	public OidListComposite(Composite parent, int style) {
		super(parent, style);

		this.initialize();
	}

	// ----- instance メソッド ----- //

	/**
	 * コンポジットを生成・構築します。
	 */
	private void initialize() {
		GridLayout layout = new GridLayout(1, true);
		this.setLayout(layout);
		layout.marginHeight = 0;
		layout.marginWidth = 0;
		layout.numColumns = MAX_COLUMN;

		//変数として利用されるラベル
		Label label = null;

		this.radioSpecific =  new Button(this, SWT.RADIO);
		this.radioSpecific.setText(Messages.getString("OidListComposite.SpecificOid")); //$NON-NLS-1$
		//Messages.getString("registration.method.node.base"));
		GridData gridDataRadio = new GridData();
		gridDataRadio.horizontalSpan = WIDTH_TITLE_SMALL;
		gridDataRadio.horizontalAlignment = GridData.FILL;
		gridDataRadio.grabExcessHorizontalSpace = true;
		this.radioSpecific.setLayoutData(gridDataRadio);
		this.radioAll =  new Button(this, SWT.RADIO);
		this.radioAll.setText(Messages.getString("OidListComposite.AllMaterOid")); //$NON-NLS-1$
		//Messages.getString("registration.method.node.base"));
		gridDataRadio = new GridData();
		gridDataRadio.horizontalSpan = WIDTH_TITLE_WIDE;
		gridDataRadio.horizontalAlignment = GridData.FILL;
		gridDataRadio.grabExcessHorizontalSpace = true;
		this.radioAll.setLayoutData(gridDataRadio);
		this.radioUnregistered =  new Button(this, SWT.RADIO);
		this.radioUnregistered.setText(Messages.getString("OidListComposite.NoMasterOid")); //$NON-NLS-1$
		//Messages.getString("registration.method.node.base"));
		gridDataRadio = new GridData();
		gridDataRadio.horizontalSpan = MAX_COLUMN-WIDTH_TITLE*2;
		gridDataRadio.horizontalAlignment = GridData.FILL;
		gridDataRadio.grabExcessHorizontalSpace = true;
		this.radioUnregistered.setLayoutData(gridDataRadio);


		//this.radioSpecific.setSelection(true);

		// ラジオボタンのイベント
		this.radioSpecific.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				if(radioSpecific.getSelection()){

					//m_log.debug("下の入力を有効にします。");
					comboMib.setEnabled(true);
					textFilter.setEnabled(true);
					buttonClearFilter.setEnabled(true);
					buttonShowOidTable.setEnabled(true);
					table.setEnabled(true);
					buttonAdd.setEnabled(true);
					buttonModify.setEnabled(true);
					buttonDelete.setEnabled(true);
				}else{

					//m_log.debug("下の入力を無効にします。");
					comboMib.setEnabled(false);
					textFilter.setEnabled(false);
					buttonClearFilter.setEnabled(false);
					buttonShowOidTable.setEnabled(false);
					table.setEnabled(false);
					buttonAdd.setEnabled(false);
					buttonModify.setEnabled(false);
					buttonDelete.setEnabled(false);
				}

			}
		});


		// グループ
		Group groupFilter = new Group(this, SWT.NONE);
		layout = new GridLayout(1, true);
		layout.marginWidth = 5;
		layout.marginHeight = 5;
		layout.numColumns = MAX_COLUMN;
		groupFilter.setLayout(layout);
		GridData gridData = new GridData();
		gridData.horizontalSpan = MAX_COLUMN;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		groupFilter.setLayoutData(gridData);
		groupFilter.setText(Messages.getString("filter") + " : "); //$NON-NLS-1$ //$NON-NLS-2$

		/*
		 * MIB
		 */
		// ラベル
		label = new Label(groupFilter, SWT.NONE);
		gridData = new GridData();
		gridData.horizontalSpan = WIDTH_TITLE;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		label.setLayoutData(gridData);
		label.setText(Messages.getString("mib") + " : "); //$NON-NLS-1$ //$NON-NLS-2$
		// コンボボックス
		this.comboMib = new Combo(groupFilter, SWT.DROP_DOWN | SWT.READ_ONLY);
		gridData = new GridData();
		gridData.horizontalSpan = MAX_COLUMN - WIDTH_TITLE;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		this.comboMib.setLayoutData(gridData);
		this.comboMib.setVisibleItemCount(10);
		// MIBリスト取得
		List<String> mibList = new GetMaster().getMibList();
		this.comboMib.add(""); //$NON-NLS-1$
		for(int i = 0; i < mibList.size(); i++){
			this.comboMib.add(mibList.get(i));
		}
		this.comboMib.select(0);
		this.comboMib.addSelectionListener(new SelectionListener(){
			/* (non-Javadoc)
			 * @see org.eclipse.swt.events.SelectionListener#widgetSelected(org.eclipse.swt.events.SelectionEvent)
			 */
			@Override
			public void widgetSelected(SelectionEvent e) {
				//表示処理
				update();
			}

			/* (non-Javadoc)
			 * @see org.eclipse.swt.events.SelectionListener#widgetDefaultSelected(org.eclipse.swt.events.SelectionEvent)
			 */
			@Override
			public void widgetDefaultSelected(SelectionEvent e) {

			}
		});

		/*
		 * フィルタ
		 */
		// ラベル
		label = new Label(groupFilter, SWT.NONE);
		gridData = new GridData();
		gridData.horizontalSpan = WIDTH_TITLE;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		label.setLayoutData(gridData);
		label.setText(Messages.getString("trap.name") + " : "); //$NON-NLS-1$ //$NON-NLS-2$
		// テキスト
		this.textFilter = new Text(groupFilter, SWT.BORDER | SWT.LEFT);
		gridData = new GridData();
		gridData.horizontalSpan = 10;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		this.textFilter.setLayoutData(gridData);
		this.textFilter.addVerifyListener(
				new StringVerifyListener(DataRangeConstant.VARCHAR_256));
		// クリアボタン
		this.buttonClearFilter = new Button(groupFilter, SWT.NONE);
		this.buttonClearFilter.setText(Messages.getString("clear")); //$NON-NLS-1$
		gridData = new GridData();
		gridData.horizontalSpan = 2;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		this.buttonClearFilter.setLayoutData(gridData);
		this.buttonClearFilter.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				textFilter.setText(""); //$NON-NLS-1$
			}
		});
		// 表示ボタン
		this.buttonShowOidTable = new Button(groupFilter, SWT.NONE);
		this.buttonShowOidTable.setText(Messages.getString("show")); //$NON-NLS-1$
		gridData = new GridData();
		gridData.horizontalSpan = 2;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		this.buttonShowOidTable.setLayoutData(gridData);
		this.buttonShowOidTable.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				//表示処理
				update();
			}
		});


		table = new Table(this, SWT.MULTI | SWT.H_SCROLL | SWT.V_SCROLL
				| SWT.FULL_SELECTION | SWT.BORDER);
		table.setHeaderVisible(true);
		table.setLinesVisible(true);

		gridData = new GridData();
		gridData.horizontalSpan = MAX_COLUMN;
		gridData.minimumHeight = 90;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.verticalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		gridData.grabExcessVerticalSpace = true;
		table.setLayoutData(gridData);

		/*
		 * OIDテーブルボタン
		 */
		// ラベル
		label = new Label(this, SWT.NONE);
		gridData = new GridData();
		gridData.horizontalSpan = MAX_COLUMN - (2+2+2);
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		label.setLayoutData(gridData);
		// 追加ボタン
		this.buttonAdd = new Button(this, SWT.NONE);
		this.buttonAdd.setText(Messages.getString("add")); //$NON-NLS-1$
		gridData = new GridData();
		gridData.horizontalSpan = 2;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		this.buttonAdd.setLayoutData(gridData);
		this.buttonAdd.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				// シェルを取得
				Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();

				SnmpTrapMasterDialog dialog = new SnmpTrapMasterDialog(shell);
				dialog.setOidList(oidList);
				if (dialog.open() == IDialogConstants.OK_ID) {

					List<SnmpTrapMasterInfo> list = dialog.getInputData();
					if(list != null){
						for(int i = 0; i < list.size(); i++){
							SnmpTrapMasterInfo master = list.get(i);
							MonitorTrapValueInfo info = new MonitorTrapValueInfo();
							info.setMonitorId(monitorId);
							info.setMib(master.getMib());
							info.setTrapOid(master.getTrapOid());
							info.setGenericId(master.getGenericId());
							info.setSpecificId(master.getSpecificId());
							info.setUei(master.getUei());
							info.setValidFlg(YesNoConstant.BOOLEAN_YES);
							info.setPriority(master.getPriority());
							info.setLogmsg(master.getLogmsg());
							info.setDescr(master.getDescr());

							oidList.add(info);
						}
					}
				}

				//再表示
				update();
			}
		});
		// 変更ボタン
		this.buttonModify = new Button(this, SWT.NONE);
		this.buttonModify.setText(Messages.getString("modify")); //$NON-NLS-1$
		gridData = new GridData();
		gridData.horizontalSpan = 2;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		this.buttonModify.setLayoutData(gridData);
		this.buttonModify.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				// シェルを取得
				Shell shell = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getShell();

				//選択OID情報を取得
				ArrayList<MonitorTrapValueInfo> list = getSelectionData();
				if (list != null && list.size() > 0) {

					for(int index = 0; index < list.size(); index++){
						MonitorTrapValueInfo oidInfo = list.get(index);

						SnmpTrapModifyDialog dialog = new SnmpTrapModifyDialog(shell);
						dialog.setInputData(oidInfo);
						dialog.open();
					}

					//再表示
					update();
				}
			}
		});
		// 削除ボタン
		this.buttonDelete = new Button(this, SWT.NONE);
		this.buttonDelete.setText(Messages.getString("delete")); //$NON-NLS-1$
		gridData = new GridData();
		gridData.horizontalSpan = 2;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		this.buttonDelete.setLayoutData(gridData);
		this.buttonDelete.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				//選択OID情報を取得
				ArrayList<MonitorTrapValueInfo> list = getSelectionData();
				if (list != null && list.size() > 0) {
					//確認
					StringBuilder trapNames = new StringBuilder();
					for(int index = 0; index < list.size(); index++){
						MonitorTrapValueInfo oidInfo = list.get(index);
						if(index == 0)
							trapNames.append(oidInfo.getUei());
						else
							trapNames.append(", " + oidInfo.getUei()); //$NON-NLS-1$
					}
					String[] args = { trapNames.toString() };
					String message = Messages.getString("message.snmptrap.2",args); //$NON-NLS-1$

					if (MessageDialog.openConfirm(
							null,
							Messages.getString("confirmed"),  //$NON-NLS-1$
							message)) {

						for(int index = 0; index < list.size(); index++){
							MonitorTrapValueInfo oidInfo = list.get(index);
							oidList.remove(oidInfo);
						}

						//再表示
						update();
					}
				}
			}
		});

		// テーブルビューアの作成
		this.tableViewer = new CommonTableViewer(table);
		this.tableViewer.createTableColumn(GetOidTableDefine.get(),
				GetOidTableDefine.SORT_COLUMN_INDEX,
				GetOidTableDefine.SORT_ORDER);
		this.update();
	}

	/**
	 * tableViewerを返します。
	 * 
	 * @return tableViewer
	 */
	public CommonTableViewer getTableViewer() {
		return this.tableViewer;
	}

	/**
	 * @return
	 */
	public List<MonitorTrapValueInfo> getOidList() {
		return oidList;
	}

	/**
	 * @param oidList
	 */
	public void setOidList(List<MonitorTrapValueInfo> oidList) {
		this.oidList = oidList;
	}

	/**
	 * @return
	 */
	public String getMonitorId() {
		return monitorId;
	}

	/**
	 * @param monitorId
	 */
	public void setMonitorId(String monitorId) {
		this.monitorId = monitorId;
	}

	/**
	 * コンポジットを有効/無効化します。
	 * 
	 */
	@Override
	public void setEnabled(boolean enabled){
		super.setEnabled(enabled);
		comboMib.setEnabled(enabled);
		textFilter.setEnabled(enabled);
		buttonClearFilter.setEnabled(enabled);
		buttonShowOidTable.setEnabled(enabled);
		buttonAdd.setEnabled(enabled);
		buttonModify.setEnabled(enabled);
		buttonDelete.setEnabled(enabled);
		table.setEnabled(enabled);
		radioSpecific.setEnabled(enabled);
		radioAll.setEnabled(enabled);
		radioUnregistered.setEnabled(enabled);
	}

	/**
	 * コンポジットを更新します。
	 * <p>
	 * 
	 */
	@Override
	public void update() {

		ArrayList list = collectionToArray(this.oidList);

		//フィルタを設定
		this.tableViewer.addFilter(new ViewerFilter(){

			/* (non-Javadoc)
			 * @see org.eclipse.jface.viewers.ViewerFilter#select(org.eclipse.jface.viewers.Viewer, java.lang.Object, java.lang.Object)
			 */
			@Override
			public boolean select(Viewer viewer, Object parentElement, Object element) {
				boolean select = true;

				ArrayList info = (ArrayList)element;

				String mib = (String)info.get(GetOidTableDefine.MIB);
				if(!comboMib.getText().equals("")){ //$NON-NLS-1$
					if(!mib.equals(comboMib.getText())){
						select = false;
					}
				}

				String trapName = (String)info.get(GetOidTableDefine.TRAP_NAME);
				if(!textFilter.getText().equals("")){ //$NON-NLS-1$
					if(!trapName.matches(textFilter.getText())){
						select = false;
					}
				}

				return select;
			}
		});

		// テーブル更新
		this.tableViewer.setInput(list);
	}

	/**
	 * OID情報をObjectの2次元配列に格納
	 * 
	 * @param oidList
	 * @return
	 */
	@SuppressWarnings("unchecked")
	public ArrayList collectionToArray(List<MonitorTrapValueInfo> oidList) {

		ArrayList list = new ArrayList();
		if(oidList != null){
			Iterator itr = oidList.iterator();
			while(itr.hasNext())
			{
				MonitorTrapValueInfo oid = (MonitorTrapValueInfo)itr.next();

				ArrayList info = new ArrayList();
				info.add(oid.getMonitorId());
				info.add(oid.getMib());
				info.add(oid.getUei());
				info.add(oid.getTrapOid());
				info.add(new Integer(oid.getGenericId()));
				info.add(new Integer(oid.getSpecificId()));
				if(oid.isValidFlg())
					info.add(new Integer(YesNoConstant.TYPE_YES));
				else
					info.add(new Integer(YesNoConstant.TYPE_NO));
				info.add(new Integer(oid.getPriority()));
				info.add(oid.getLogmsg());
				list.add(info);
			}
		}
		return list;
	}


	public int getCheckMode(){
		if(radioAll.getSelection())
			return 1;
		//return MonitorSnmpTrapInfo.ALL_OID;
		else if(radioUnregistered.getSelection())
			return 2;
		//return MonitorSnmpTrapInfo.UNREGISTERED_OID;
		else
			return 0;
		//return MonitorSnmpTrapInfo.SPECIFIC_OID;
	}
	/**
	 * OIDの監視をどのようにするかを設定します。
	 * @param mode
	 */
	public void setCheckMode(int mode){

		switch(mode){

		case 1:
			this.radioAll.setSelection(true);
			comboMib.setEnabled(false);
			textFilter.setEnabled(false);
			buttonClearFilter.setEnabled(false);
			buttonShowOidTable.setEnabled(false);
			table.setEnabled(false);
			buttonAdd.setEnabled(false);
			buttonModify.setEnabled(false);
			buttonDelete.setEnabled(false);
			break;
		case 2:
			this.radioUnregistered.setSelection(true);
			comboMib.setEnabled(false);
			textFilter.setEnabled(false);
			buttonClearFilter.setEnabled(false);
			buttonShowOidTable.setEnabled(false);
			table.setEnabled(false);
			buttonAdd.setEnabled(false);
			buttonModify.setEnabled(false);
			buttonDelete.setEnabled(false);
			break;
		default:
		case 0:
			this.radioSpecific.setSelection(true);
			break;
		}

	}
	/**
	 * 選択されたOID情報の配列を取得する
	 * 
	 * @return
	 */
	private ArrayList<MonitorTrapValueInfo> getSelectionData() {

		ArrayList<MonitorTrapValueInfo> data = new ArrayList<MonitorTrapValueInfo>();

		//選択されたアイテムを取得
		StructuredSelection selection =
				(StructuredSelection)tableViewer.getSelection();
		List list = selection.toList();

		if (list != null) {
			for(int index = 0; index < list.size(); index++){

				ArrayList info = (ArrayList)list.get(index);
				if (info != null && info.size() > 0) {
					String mib = (String)info.get(GetOidTableDefine.MIB);
					String oid = (String)info.get(GetOidTableDefine.TRAP_OID);
					Integer genericId = (Integer)info.get(GetOidTableDefine.GENERIC_ID);
					Integer specificId = (Integer)info.get(GetOidTableDefine.SPECIFIC_ID);

					if (oidList != null) {
						for(int i = 0; i < oidList.size(); i++){
							MonitorTrapValueInfo oidInfo = oidList.get(i);

							if(mib.equals(oidInfo.getMib()) &&
									oid.equals(oidInfo.getTrapOid()) &&
									genericId.equals(oidInfo.getGenericId()) &&
									specificId.equals(oidInfo.getSpecificId())){

								data.add(oidInfo);
								break;
							}
						}
					}
				}
			}
		}

		return data;
	}
}