/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.monitor.view.action;

import java.util.List;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.viewers.ISelection;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IViewActionDelegate;
import org.eclipse.ui.IViewPart;

import com.clustercontrol.bean.HinemosModuleConstant;
import com.clustercontrol.custom.dialog.MonitorCustomDialog;
import com.clustercontrol.hinemosagent.dialog.AgentCreateDialog;
import com.clustercontrol.http.dialog.HttpNumericCreateDialog;
import com.clustercontrol.http.dialog.HttpStringCreateDialog;
import com.clustercontrol.logfile.dialog.LogfileStringCreateDialog;
import com.clustercontrol.monitor.composite.MonitorListComposite;
import com.clustercontrol.monitor.run.action.GetMonitorListTableDefine;
import com.clustercontrol.monitor.run.bean.MonitorTypeConstant;
import com.clustercontrol.monitor.run.dialog.CommonMonitorDialog;
import com.clustercontrol.monitor.view.MonitorListView;
import com.clustercontrol.performance.monitor.dialog.PerformanceCreateDialog;
import com.clustercontrol.ping.dialog.PingCreateDialog;
import com.clustercontrol.plugin.monitor.IMonitorPlugin;
import com.clustercontrol.plugin.monitor.LoadMonitorPlugin;
import com.clustercontrol.port.dialog.PortCreateDialog;
import com.clustercontrol.process.dialog.ProcessCreateDialog;
import com.clustercontrol.snmp.dialog.SnmpNumericCreateDialog;
import com.clustercontrol.snmp.dialog.SnmpStringCreateDialog;
import com.clustercontrol.snmptrap.dialog.SnmpTrapCreateDialog;
import com.clustercontrol.sql.dialog.SqlNumericCreateDialog;
import com.clustercontrol.sql.dialog.SqlStringCreateDialog;
import com.clustercontrol.systemlog.dialog.SystemlogStringCreateDialog;
import com.clustercontrol.winevent.dialog.WinEventDialog;
import com.clustercontrol.winservice.dialog.WinServiceCreateDialog;

/**
 * 監視[一覧]ビューのコピーアクションクラス<BR>
 * 
 * @version 4.1.0
 */
public class MonitorCopyAction implements IViewActionDelegate {

	// ログ
	private static Log m_log = LogFactory.getLog( MonitorCopyAction.class );

	/** アクションID */
	public static final String ID = "com.clustercontrol.monitor.view.action.MonitorCopyAction";

	/** ビュー */
	private IViewPart viewPart;

	@Override
	public void run(IAction action) {
		// 選択アイテムの取得
		MonitorListView view = (MonitorListView) this.viewPart.getAdapter(MonitorListView.class);

		MonitorListComposite composite = (MonitorListComposite) view.getListComposite();
		StructuredSelection selection = (StructuredSelection) composite.getTableViewer().getSelection();

		List list = (List) selection.getFirstElement();
		String pluginId = null;
		String monitorId = null;
		int monitorType = 0;
		if(list != null && list.size() > 0){
			pluginId = (String) list.get(GetMonitorListTableDefine.MONITOR_TYPE_ID);
			monitorId = (String) list.get(GetMonitorListTableDefine.MONITOR_ID);
			monitorType = MonitorTypeConstant.stringToType((String) list.get(GetMonitorListTableDefine.MONITOR_TYPE));
		}


		dialogOpen(this.viewPart.getSite().getShell(), pluginId, monitorId, monitorType);

		// ビューの更新
		view.update();
	}

	public int dialogOpen(Shell shell, String pluginId, String monitorId, int monitorType) {
		CommonMonitorDialog dialog = null;
		if (pluginId.equals(HinemosModuleConstant.MONITOR_AGENT)) {
			dialog = new AgentCreateDialog(shell, monitorId, false);
		} else if (pluginId.equals(HinemosModuleConstant.MONITOR_HTTP)) {
			if (monitorType == 1) {
				dialog = new HttpNumericCreateDialog(shell, monitorId, false);
			} else {
				dialog = new HttpStringCreateDialog(shell, monitorId, false);
			}
		} else if (pluginId.equals(HinemosModuleConstant.MONITOR_PERFORMANCE)) {
			dialog = new PerformanceCreateDialog(shell, monitorId, false);
		} else if (pluginId.equals(HinemosModuleConstant.MONITOR_PING)) {
			dialog = new PingCreateDialog(shell, monitorId, false);
		} else if (pluginId.equals(HinemosModuleConstant.MONITOR_PORT)) {
			dialog = new PortCreateDialog(shell, monitorId, false);
		} else if (pluginId.equals(HinemosModuleConstant.MONITOR_PROCESS)) {
			dialog = new ProcessCreateDialog(shell, monitorId, false);
		} else if (pluginId.equals(HinemosModuleConstant.MONITOR_SNMP)) {
			if (monitorType == 1) {
				dialog = new SnmpNumericCreateDialog(shell, monitorId, false);
			} else {
				dialog = new SnmpStringCreateDialog(shell, monitorId, false);
			}
		} else if (pluginId.equals(HinemosModuleConstant.MONITOR_SQL)) {
			if (monitorType == 1) {
				dialog = new SqlNumericCreateDialog(shell, monitorId, false);
			} else {
				dialog = new SqlStringCreateDialog(shell, monitorId, false);
			}
		} else if (pluginId.equals(HinemosModuleConstant.MONITOR_SYSTEMLOG)) {
			dialog = new SystemlogStringCreateDialog(shell, monitorId, false);
		} else if (pluginId.equals(HinemosModuleConstant.MONITOR_LOGFILE)) {
			dialog = new LogfileStringCreateDialog(shell, monitorId, false);
		} else if (pluginId.equals(HinemosModuleConstant.MONITOR_CUSTOM)) {
			dialog = new MonitorCustomDialog(shell, monitorId, false);
		} else if (pluginId.equals(HinemosModuleConstant.MONITOR_SNMPTRAP)) {
			dialog = new SnmpTrapCreateDialog(shell, monitorId, false);
		} else if (pluginId.equals(HinemosModuleConstant.MONITOR_WINSERVICE)) {
			dialog = new WinServiceCreateDialog(shell, monitorId, false);
		} else if (pluginId.equals(HinemosModuleConstant.MONITOR_WINEVENT)) {
			dialog = new WinEventDialog(shell, monitorId, false);
		} else {
			for(IMonitorPlugin extensionMonitor: LoadMonitorPlugin.getExtensionMonitorList()){
				if(pluginId.equals(extensionMonitor.getMonitorPluginId())){
					return extensionMonitor.create(shell, monitorId, false);
				}
			}

			m_log.warn("unknown pluginId " + pluginId);
			return -1;
		}
		return dialog.open();
	}

	@Override
	public void selectionChanged(IAction action, ISelection selection) {
		// TODO Auto-generated method stub

	}

	@Override
	public void init(IViewPart viewPart) {
		this.viewPart = viewPart;
	}

}
