/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.calendar.dialog;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.swt.SWT;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;

import com.clustercontrol.bean.PropertyDefineConstant;
import com.clustercontrol.bean.RequiredFieldColorConstant;
import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.calendar.CalendarDetailInfo;
import com.clustercontrol.ws.calendar.CalendarInfo;
import com.clustercontrol.calendar.action.AddCalendar;
import com.clustercontrol.calendar.action.GetCalendar;
import com.clustercontrol.calendar.action.GetCalendarDetailTableDefine;
import com.clustercontrol.calendar.action.ModifyCalendar;
import com.clustercontrol.calendar.composite.CalendarDetailInfoComposite;
import com.clustercontrol.composite.RoleIdListComposite;
import com.clustercontrol.composite.RoleIdListComposite.Mode;
import com.clustercontrol.dialog.CommonDialog;
import com.clustercontrol.dialog.DateTimeDialog;
import com.clustercontrol.dialog.ValidateResult;

/**
 * カレンダ設定作成・変更ダイアログクラス<BR>
 * 
 * @version 4.1.0
 * @since 2.0.0
 */
public class CalendarDialog extends CommonDialog{

	// ログ
	private static Log m_log = LogFactory.getLog( CalendarDialog.class );
	/** カレンダID */
	private String calendarId = "";

	/** 有効期間（開始） */
	private Long calTimeFrom = new Long(-1);
	/** 有効期間（終了） */
	private Long calTimeTo = new Long(-1);
	/** 変更用ダイアログ判別フラグ */
	private int mode;
	/** カレンダID */
	private Text txtCalID = null;
	/** カレンダ名 */
	private Text txtCalName = null;
	/** 有効期間（開始） */
	private Text txtCalTimeFrom = null;
	/** 有効期間（終了） */
	private Text txtCalTimeTo = null;
	/** 入力値を保持するオブジェクト */
	private CalendarInfo inputData = null;
	/** カレンダ詳細情報 */
	private CalendarDetailInfoComposite m_calendarDetailComposite = null;
	/** オーナーロールID用テキスト */
	private RoleIdListComposite m_ownerRoleId = null;
	private String ownerRoleId = null;

	// ----- 共通メンバ変数 ----- //
	private Shell shell = null;
	private Group groupCal = null; //カレンダ設定グループ
	private Group groupCalDetail = null;// カレンダ詳細グループ
	private Text txtCalDescription = null;
	private Button btnTimeFrom = null;
	private Button btnTimeTo = null;

	// ----- コンストラクタ ----- //
	/**
	 * 作成用ダイアログのインスタンスを返します。
	 * 
	 * @param parent
	 *            親のシェルオブジェクト
	 */
	public CalendarDialog(Shell parent) {
		super(parent);
	}
	public CalendarDialog(Shell parent, String id, int mode) {
		super(parent);
		this.calendarId = id;
		this.mode = mode;
	}
	// ----- instance メソッド ----- //
	/**
	 * ダイアログエリアを生成します。
	 * 
	 * @param parent
	 *            親のインスタンス
	 */
	@Override
	protected void customizeDialog(Composite parent) {
		shell = this.getShell();
		// タイトル
		shell.setText(Messages.getString("dialog.calendar.calendar.create.modify"));
		GridData gridData = new GridData();
		GridLayout layout = new GridLayout(1, true);
		layout.marginWidth = 10;
		layout.marginHeight = 10;
		parent.setLayout(layout);
		/*
		 * カレンダ設定グループ
		 */
		groupCal = new Group(parent, SWT.NONE);
		layout = new GridLayout(1, true);
		layout.marginWidth = 5;
		layout.marginHeight = 5;
		layout.numColumns = 15;
		groupCal.setLayout(layout);
		gridData = new GridData();
		gridData.horizontalSpan = 15;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		groupCal.setLayoutData(gridData);
		groupCal.setText(Messages.getString("calendar.create"));
		/*
		 * カレンダID
		 */
		//ラベル
		Label lblCalID = new Label(groupCal, SWT.LEFT);
		gridData = new GridData();
		gridData.horizontalSpan = 4;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		lblCalID.setLayoutData(gridData);
		lblCalID.setText(Messages.getString("calendar.id") + " : ");
		//テキスト
		txtCalID = new Text(groupCal, SWT.BORDER | SWT.LEFT);
		gridData = new GridData();
		gridData.horizontalSpan = 8;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		txtCalID.setLayoutData(gridData);
		txtCalID.addModifyListener(new ModifyListener(){
			@Override
			public void modifyText(ModifyEvent arg0) {
				update();
			}
		});
		/*
		 * カレンダ名
		 */
		//ラベル
		Label lblCalName = new Label(groupCal, SWT.LEFT);
		gridData = new GridData();
		gridData.horizontalSpan = 4;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		lblCalName.setLayoutData(gridData);
		lblCalName.setText(Messages.getString("calendar.name") + " : ");
		//テキスト
		txtCalName = new Text(groupCal, SWT.BORDER | SWT.LEFT);
		gridData = new GridData();
		gridData.horizontalSpan = 8;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		txtCalName.setLayoutData(gridData);
		txtCalName.addModifyListener(new ModifyListener(){
			@Override
			public void modifyText(ModifyEvent arg0) {
				update();
			}
		});
		/*
		 * 説明
		 */
		//ラベル
		Label lblCalDescription = new Label(groupCal, SWT.LEFT);
		gridData = new GridData();
		gridData.horizontalSpan = 4;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		lblCalDescription.setLayoutData(gridData);
		lblCalDescription.setText(Messages.getString("description") + " : ");
		//テキスト
		txtCalDescription = new Text(groupCal, SWT.BORDER | SWT.LEFT);
		gridData = new GridData();
		gridData.horizontalSpan = 8;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		txtCalDescription.setLayoutData(gridData);
		txtCalDescription.addModifyListener(new ModifyListener(){
			@Override
			public void modifyText(ModifyEvent arg0) {
				update();
			}
		});

		/*
		 * オーナーロールID
		 */
		Label labelRoleId = new Label(groupCal, SWT.LEFT);
		gridData = new GridData();
		gridData.horizontalSpan = 4;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		labelRoleId.setLayoutData(gridData);
		labelRoleId.setText(Messages.getString("owner.role.id") + " : ");
		if (this.mode == PropertyDefineConstant.MODE_ADD
				|| this.mode == PropertyDefineConstant.MODE_COPY) {
			this.m_ownerRoleId = new RoleIdListComposite(groupCal, SWT.NONE, true, Mode.OWNER_ROLE);
			this.m_ownerRoleId.getComboRoleId().addSelectionListener(new SelectionAdapter() {
				@Override
				public void widgetSelected(SelectionEvent e) {
					/* FIXME
					CalendarInfo calInfo = m_calendarDetailComposite.getCalendarInfo();
					if (calInfo != null
							&& calInfo.getCalendarDetailList() != null
							&& calInfo.getCalendarDetailList().size() > 0) {
					 */
					if (m_calendarDetailComposite.getDetailList() != null
							&& m_calendarDetailComposite.getDetailList().size() > 0) {
						if (!MessageDialog.openConfirm(
								null,
								Messages.getString("confirmed"),
								Messages.getString("message.calendar.50"))) {
							m_ownerRoleId.setText(ownerRoleId);
							return;
						}
					}
					m_calendarDetailComposite.changeOwnerRoleId(m_ownerRoleId.getText());
					ownerRoleId = m_ownerRoleId.getText();
				}
			});
		} else {
			this.m_ownerRoleId = new RoleIdListComposite(groupCal, SWT.NONE, false, Mode.OWNER_ROLE);
		}
		gridData = new GridData();
		gridData.horizontalSpan = 8;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		m_ownerRoleId.setLayoutData(gridData);

		/*
		 * 有効期間（開始）
		 */
		//ラベル
		Label lblCalTimeFrom = new Label(groupCal, SWT.LEFT);
		gridData = new GridData();
		gridData.horizontalSpan = 4;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		lblCalTimeFrom.setLayoutData(gridData);
		lblCalTimeFrom.setText(Messages.getString("valid.time") + "(" +
				Messages.getString("start") + ")" + " : ");
		//テキスト
		txtCalTimeFrom = new Text(groupCal, SWT.BORDER | SWT.LEFT);
		gridData = new GridData();
		gridData.horizontalSpan = 8;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		txtCalTimeFrom.setLayoutData(gridData);
		//日時ダイアログからの入力しか受け付けません
		txtCalTimeFrom.setEnabled(false);
		txtCalTimeFrom.addModifyListener(new ModifyListener(){
			@Override
			public void modifyText(ModifyEvent arg0) {
				update();
			}
		});
		// 追加ボタン
		btnTimeFrom = new Button(groupCal, SWT.NONE);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		btnTimeFrom.setLayoutData(gridData);
		btnTimeFrom.setText(Messages.getString("calendar.button"));
		btnTimeFrom.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				DateTimeDialog dialog = new DateTimeDialog(shell);
				if (txtCalTimeFrom.getText().length() > 0) {
					Date date = new Date(calTimeFrom);
					dialog.setDate(date);
				}
				if (dialog.open() == IDialogConstants.OK_ID) {
					//取得した日時をLong型で保持
					calTimeFrom = dialog.getDate().getTime();
					//ダイアログより取得した日時を"yyyy/MM/dd HH:mm:ss"の形式に変換
					SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
					String tmp = sdf.format(dialog.getDate());
					txtCalTimeFrom.setText(tmp);
					update();
				}
			}
		});
		/*
		 * 有効期間（終了）
		 */
		//ラベル
		Label lblCalTimeTo = new Label(groupCal, SWT.LEFT);
		gridData = new GridData();
		gridData.horizontalSpan = 4;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		lblCalTimeTo.setLayoutData(gridData);
		lblCalTimeTo.setText(Messages.getString("valid.time") + "(" +
				Messages.getString("end") + ")" + " : ");
		//テキスト
		txtCalTimeTo = new Text(groupCal, SWT.BORDER | SWT.LEFT);
		gridData = new GridData();
		gridData.horizontalSpan = 8;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		txtCalTimeTo.setLayoutData(gridData);
		//日時ダイアログからの入力しか受け付けません
		txtCalTimeTo.setEnabled(false);
		txtCalTimeTo.addModifyListener(new ModifyListener(){
			@Override
			public void modifyText(ModifyEvent arg0) {
				update();
			}
		});
		// 追加ボタン
		btnTimeTo = new Button(groupCal, SWT.NONE);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		btnTimeTo.setLayoutData(gridData);
		btnTimeTo.setText(Messages.getString("calendar.button"));
		btnTimeTo.addSelectionListener(new SelectionAdapter() {
			@Override
			public void widgetSelected(SelectionEvent e) {
				DateTimeDialog dialog = new DateTimeDialog(shell);
				if (txtCalTimeTo.getText().length() > 0) {
					Date date = new Date(calTimeTo);
					dialog.setDate(date);
				}
				if (dialog.open() == IDialogConstants.OK_ID) {
					//取得した日時をLong型で保持
					calTimeTo = dialog.getDate().getTime();
					//日付ダイアログより取得した数字列を"yyyy/MM/dd HH:mm:ss"の形式に変換
					SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");

					m_log.trace("CalendarDialog getTime：" + dialog.getDate());

					String tmp = sdf.format(dialog.getDate());
					txtCalTimeTo.setText(tmp);
				}
			}
		});

		/*
		 * カレンダ詳細グループ
		 * 
		 */
		groupCalDetail = new Group(parent, SWT.NONE);
		layout = new GridLayout(1, true);
		layout.marginWidth = 5;
		layout.marginHeight = 5;
		layout.numColumns = 1;
		groupCalDetail.setLayout(layout);
		gridData = new GridData();
		gridData.horizontalSpan = 15;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		groupCalDetail.setLayoutData(gridData);
		groupCalDetail.setText(Messages.getString("calendar.detail"));

		/**
		 *  カレンダ詳細定義情報
		 */
		//詳細情報テーブルカラム取得
		GetCalendarDetailTableDefine.get();
		this.m_calendarDetailComposite = new CalendarDetailInfoComposite(groupCalDetail, SWT.NONE);
		gridData = new GridData();
		gridData.horizontalSpan = 1;
		gridData.horizontalAlignment = GridData.FILL;
		gridData.grabExcessHorizontalSpace = true;
		gridData.heightHint = 220;
		m_calendarDetailComposite.setLayoutData(gridData);

		Display display = shell.getDisplay();
		shell.setLocation((display.getBounds().width - shell.getSize().x) / 2,
				(display.getBounds().height - shell.getSize().y) / 2);

		// ダイアログを調整
		this.adjustDialog();
		//ダイアログにカレンダ詳細情報反映
		this.reflectCalendar();
		//ダイアログのパラメータをカレンダ詳細情報に反映
		//this.createCalendarInfo();
		// 必須入力項目を可視化
		this.update();
	}


	/**
	 * ダイアログエリアを調整します。
	 * 
	 */
	private void adjustDialog(){
		// サイズを最適化
		// グリッドレイアウトを用いた場合、こうしないと横幅が画面いっぱいになります。
		shell.pack();
		shell.setSize(new Point(600, shell.getSize().y));

		// 画面中央に配置
		Display display = shell.getDisplay();
		shell.setLocation((display.getBounds().width - shell.getSize().x) / 2,
				(display.getBounds().height - shell.getSize().y) / 2);
	}

	/**
	 * 更新処理
	 * 
	 */
	public void update(){
		// 必須項目を明示

		// カレンダIDのインデックス：9
		if("".equals(this.txtCalID.getText())){
			this.txtCalID.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
		}else{
			this.txtCalID.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
		}
		// カレンダ名のインデックス：9
		if("".equals(this.txtCalName.getText())){
			this.txtCalName.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
		}else{
			this.txtCalName.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
		}
		// 有効期間（開始）のインデックス：9
		if("".equals(this.txtCalTimeFrom.getText())){
			this.txtCalTimeFrom.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
		}else{
			this.txtCalTimeFrom.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
		}
		// 有効期間（終了）のインデックス：9
		if("".equals(this.txtCalTimeTo.getText())){
			this.txtCalTimeTo.setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
		}else{
			this.txtCalTimeTo.setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
		}
	}
	/**
	 * ダイアログの情報からカレンダ情報を作成します。
	 * 
	 * @return 入力値の検証結果
	 * 
	 * @see
	 */
	private ValidateResult createCalendarInfo() {
		ValidateResult result = null;

		this.inputData = new CalendarInfo();

		//カレンダID取得
		if(txtCalID.getText().length() > 0){
			inputData.setId(txtCalID.getText());
		} else {
			result = new ValidateResult();
			result.setValid(false);
			result.setID(Messages.getString("message.hinemos.1"));
			result.setMessage(Messages.getString("calendar.id"));
			return result;
		}
		m_log.trace("createCalendarInfo cal name = " + txtCalName.getText());
		//カレンダ名取得
		if(txtCalName.getText().length() > 0 && !txtCalName.equals("")) {
			m_log.trace("createCalendarInfo22 cal name = " + txtCalName.getText());
			inputData.setName(txtCalName.getText());
			m_log.trace("input cal name = " + inputData.getName());
		} else {
			result = new ValidateResult();
			result.setValid(false);
			result.setID(Messages.getString("message.hinemos.1"));
			result.setMessage(Messages.getString("calendar.name"));
			return result;
		}
		//カレンダ説明取得
		if(txtCalDescription.getText().length() > 0){
			inputData.setDescription(txtCalDescription.getText());
		} else {
			inputData.setDescription("");
		}
		//有効期間（開始）取得
		if(txtCalTimeFrom.getText().length() > 0){
			Date dateTimeFrom;
			try {
				dateTimeFrom = (new SimpleDateFormat("yyyy/MM/dd HH:mm:ss")).parse(txtCalTimeFrom.getText());
				calTimeFrom = dateTimeFrom.getTime();
				inputData.setValidTimeFrom(calTimeFrom);
			} catch (ParseException e) {
				e.printStackTrace();
			}
		} else {
			result = new ValidateResult();
			result.setValid(false);
			result.setID(Messages.getString("message.hinemos.1"));
			result.setMessage(Messages.getString("valid.time") + "(" +
					Messages.getString("start") + ")" + " : ");
			return result;
		}
		//有効期間（終了）取得
		if(txtCalTimeTo.getText().length() > 0){
			Date dateTimeTo;
			try {
				dateTimeTo = (new SimpleDateFormat("yyyy/MM/dd HH:mm:ss")).parse(txtCalTimeTo.getText());
				calTimeTo = dateTimeTo.getTime();
				inputData.setValidTimeTo(calTimeTo);
			} catch (ParseException e) {
				e.printStackTrace();
			}
		} else {
			result = new ValidateResult();
			result.setValid(false);
			result.setID(Messages.getString("message.hinemos.1"));
			result.setMessage(Messages.getString("valid.time") + "(" +
					Messages.getString("end") + ")" + " : ");
			return result;
		}
		//カレンダ詳細情報取得
		if (this.m_calendarDetailComposite.getDetailList() != null) {

			m_log.debug("Add CalendarDetailInfo : " +
					this.m_calendarDetailComposite.getDetailList().size());

			for (CalendarDetailInfo detailInfo : this.m_calendarDetailComposite.getDetailList()) {
				this.inputData.getCalendarDetailList().add(detailInfo);
			}
		}
		//オーナーロールID
		if (m_ownerRoleId.getText().length() > 0) {
			inputData.setOwnerRoleId(m_ownerRoleId.getText());
		} else {
			result = new ValidateResult();
			result.setValid(false);
			result.setID(Messages.getString("message.hinemos.1"));
			result.setMessage(Messages.getString("owner.role.id"));
			return result;
		}
		return result;
	}

	/**
	 * ダイアログにカレンダ情報を反映します。
	 * 
	 * @param detailList
	 */
	private void reflectCalendar() {
		// 初期表示
		CalendarInfo calInfo = null;
		if(mode == PropertyDefineConstant.MODE_MODIFY
				|| mode == PropertyDefineConstant.MODE_COPY){
			// 変更、コピーの場合、情報取得
			calInfo = new GetCalendar().getCalendar(this.calendarId);
		}else{
			// 作成の場合
			calInfo = new CalendarInfo();
		}
		this.inputData = calInfo;
		//カレンダ情報取得
		if(calInfo != null){
			if (calInfo.getId() != null) {
				this.calendarId = calInfo.getId();
				this.txtCalID.setText(calInfo.getId());
				//カレンダ定義変更の際にはカレンダIDは変更不可
				if (this.mode == PropertyDefineConstant.MODE_MODIFY) {
					this.txtCalID.setEnabled(false);
				}
			}
			if(calInfo.getName() != null){
				this.txtCalName.setText(calInfo.getName());
			}
			if(calInfo.getDescription() != null){
				this.txtCalDescription.setText(calInfo.getDescription());
			}
			if(calInfo.getValidTimeFrom() != null){
				SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
				String tmp = sdf.format(calInfo.getValidTimeFrom());
				this.txtCalTimeFrom.setText(tmp);
				this.calTimeFrom = calInfo.getValidTimeFrom();
			}
			if(calInfo.getValidTimeTo() != null){
				SimpleDateFormat sdf = new SimpleDateFormat("yyyy/MM/dd HH:mm:ss");
				String tmp = sdf.format(calInfo.getValidTimeTo());
				this.txtCalTimeTo.setText(tmp);
				this.calTimeTo = calInfo.getValidTimeTo();
			}
		}
		// カレンダ詳細情報取得
		m_calendarDetailComposite.setDetailList(
				(ArrayList<CalendarDetailInfo>) calInfo.getCalendarDetailList());

		// オーナーロールID取得
		if (calInfo.getOwnerRoleId() != null) {
			this.m_ownerRoleId.setText(calInfo.getOwnerRoleId());
		}
		ownerRoleId = this.m_ownerRoleId.getText();
		this.m_calendarDetailComposite.setOwnerRoleId(this.m_ownerRoleId.getText());

		this.update();
	}
	/**
	 * 入力値をマネージャに登録します。
	 * 
	 * @return true：正常、false：異常
	 * 
	 * @see com.clustercontrol.dialog.CommonDialog#action()
	 */

	@Override
	protected boolean action() {
		boolean result = false;
		createCalendarInfo();
		CalendarInfo info = this.inputData;
		if(info != null){
			if(mode == PropertyDefineConstant.MODE_ADD){
				// 作成の場合+
				result = new AddCalendar().add(info);
			} else if (mode == PropertyDefineConstant.MODE_MODIFY){
				// 変更の場合
				info.setId(txtCalID.getText());
				result = new ModifyCalendar().modify(info);
			} else if (mode == PropertyDefineConstant.MODE_COPY){
				// コピーの場合
				info.setId(txtCalID.getText());
				result = new AddCalendar().add(info);
			}
		} else {
			m_log.error("action() Calendarinfo is null");
		}
		return result;
	}
}
