/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.accesscontrol.viewer;

import org.eclipse.jface.viewers.ITreeContentProvider;
import org.eclipse.jface.viewers.Viewer;

import com.clustercontrol.ws.accesscontrol.RoleTreeItem;

/**
 * ロールツリー用コンポジットのツリービューア用のITreeContentProviderクラスです。
 * 
 * @version 1.0.0
 * @since 1.0.0
 */
public class RoleSettingTreeContentProvider implements ITreeContentProvider {

	/**
	 * ロールツリーアイテムの要素(子のジョブツリーアイテム)を返します。
	 * 
	 * @param inputElement ジョブツリーアイテム
	 * @return ロールツリーアイテムの配列
	 * 
	 * @see org.eclipse.jface.viewers.IStructuredContentProvider#getElements(java.lang.Object)
	 */
	@Override
	public Object[] getElements(Object inputElement) {
		return getChildren(inputElement);
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.IContentProvider#dispose()
	 */
	@Override
	public void dispose() {
	}

	/* (non-Javadoc)
	 * @see org.eclipse.jface.viewers.IContentProvider#inputChanged(org.eclipse.jface.viewers.Viewer, java.lang.Object, java.lang.Object)
	 */
	@Override
	public void inputChanged(Viewer viewer, Object oldInput, Object newInput) {
	}

	/**
	 * ロールツリーアイテムの子のロールツリーアイテムを返します。
	 * 
	 * @param parentElement ロールツリーアイテム
	 * @return ロールツリーアイテムの配列
	 * 
	 * @see org.eclipse.jface.viewers.ITreeContentProvider#getChildren(java.lang.Object)
	 */
	@Override
	public Object[] getChildren(Object parentElement) {
		return ((RoleTreeItem) parentElement).getChildren().toArray();
	}

	/**
	 * ロールツリーアイテムの親ロールツリーアイテムを返します。
	 * 
	 * @param element 親ロールツリーアイテム
	 * 
	 * @see org.eclipse.jface.viewers.ITreeContentProvider#getParent(java.lang.Object)
	 */
	@Override
	public Object getParent(Object element) {
		return ((RoleTreeItem) element).getParent();
	}

	/**
	 * ロールツリーアイテムが子のロールツリーアイテムを持っているかを返します。
	 * 
	 * @param element ロールツリーアイテム
	 * @return true：子がある、false：子がない
	 * 
	 * @see org.eclipse.jface.viewers.ITreeContentProvider#hasChildren(java.lang.Object)
	 */
	@Override
	public boolean hasChildren(Object element) {
		return ((RoleTreeItem) element).getChildren().size() > 0;
	}

}