
package com.clustercontrol.ws.xcloud;

import javax.xml.bind.annotation.XmlEnum;
import javax.xml.bind.annotation.XmlEnumValue;
import javax.xml.bind.annotation.XmlType;


/**
 * <p>instanceSnapshotStatusTypeのJavaクラス。
 * 
 * <p>次のスキーマ・フラグメントは、このクラス内に含まれる予期されるコンテンツを指定します。
 * <p>
 * <pre>
 * &lt;simpleType name="instanceSnapshotStatusType">
 *   &lt;restriction base="{http://www.w3.org/2001/XMLSchema}string">
 *     &lt;enumeration value="completed"/>
 *     &lt;enumeration value="pending"/>
 *     &lt;enumeration value="unknown"/>
 *     &lt;enumeration value="missing"/>
 *   &lt;/restriction>
 * &lt;/simpleType>
 * </pre>
 * 
 */
@XmlType(name = "instanceSnapshotStatusType")
@XmlEnum
public enum InstanceSnapshotStatusType {

    @XmlEnumValue("completed")
    COMPLETED("completed"),
    @XmlEnumValue("pending")
    PENDING("pending"),
    @XmlEnumValue("unknown")
    UNKNOWN("unknown"),
    @XmlEnumValue("missing")
    MISSING("missing");
    private final String value;

    InstanceSnapshotStatusType(String v) {
        value = v;
    }

    public String value() {
        return value;
    }

    public static InstanceSnapshotStatusType fromValue(String v) {
        for (InstanceSnapshotStatusType c: InstanceSnapshotStatusType.values()) {
            if (c.value.equals(v)) {
                return c;
            }
        }
        throw new IllegalArgumentException(v);
    }

}
