package com.clustercontrol.xcloud.ui.handlers;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.text.MessageFormat;

import org.apache.log4j.Logger;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.handlers.HandlerUtil;

import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.xcloud.CloudEndpoint;
import com.clustercontrol.xcloud.common.CloudStringConstants;
import com.clustercontrol.xcloud.extensions.ICloudOptionHandler;
import com.clustercontrol.xcloud.model.cloud.IInstance;

public class ManualNodeAssignHandler implements ICloudOptionHandler, CloudStringConstants {
	@Override
	public Object execute(ExecutionEvent event) {
		IStructuredSelection selection = (IStructuredSelection)HandlerUtil.getActiveSite(event).getSelectionProvider().getSelection();
		final IInstance instance = (IInstance)selection.getFirstElement();
		
		if (MessageDialog.openConfirm(
			null,
			Messages.getString("confirmed"),
			MessageFormat.format(msgConfirmManualRegistNodeModify, instance.getName(), instance.getId()))) {
			
			try {
				CloudEndpoint endpoint = instance.getCloudScope().getCloudScopes().getHinemosManager().getEndpoint(CloudEndpoint.class);
				endpoint.assignNodeToInstance(instance.getCloudScope().getId(), instance.getLocation().getId(), instance.getId());
				
				// 成功報告ダイアログを生成
				MessageDialog.openInformation(
					null,
					Messages.getString("successful"),
					msgFinishManualRegistNodeModify);
				
				Display.getCurrent().asyncExec(new Runnable() {
					@Override
					public void run() {
						instance.getLocation().updateLocation();
					}
				});
			} catch (Exception e) {
				Logger logger = Logger.getLogger(this.getClass());
				logger.error(e.getMessage(), e);

				String message = e.getMessage();
				if (message == null) {
					ByteArrayOutputStream bos = new ByteArrayOutputStream();
					PrintStream ps = new PrintStream(bos, true);
					e.printStackTrace(ps);
					
					message = bos.toString();
				}
				
				// 失敗報告ダイアログを生成
				MessageDialog.openError(null, Messages.getString("failed"), message);
			}
		}
		return null;
	}
}
