package com.clustercontrol.xcloud.ui.handlers;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;

import org.apache.log4j.Logger;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.handlers.HandlerUtil;

import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.xcloud.CloudEndpoint;
import com.clustercontrol.xcloud.common.CloudStringConstants;
import com.clustercontrol.xcloud.extensions.ICloudOptionHandler;
import com.clustercontrol.xcloud.model.cloud.IStorage;

public class DeleteStorageHandler implements ICloudOptionHandler, CloudStringConstants {
	@Override
	public Object execute(ExecutionEvent event) {
		IStructuredSelection selection = (IStructuredSelection)HandlerUtil.getCurrentSelection(event);
		final IStorage storage = (IStorage)selection.getFirstElement();
		List<String> storageIds = new ArrayList<>();
		for (Object item: selection.toList()) {
			storageIds.add(((IStorage)item).getId());
		}

		if (MessageDialog.openConfirm(
				null,
				Messages.getString("confirmed"),
				storageIds.size() > 1 ?
				MessageFormat.format(msgConfirmDeleteStorageMulti, storageIds.size()):
				MessageFormat.format(msgConfirmDeleteStorage, storage.getName(), storage.getId()))) {

			try {
				CloudEndpoint endpoint = storage.getCloudScope().getCloudScopes().getHinemosManager().getEndpoint(CloudEndpoint.class);
				endpoint.removeStorages(storage.getCloudScope().getId(), storage.getLocation().getId(), storageIds);

				// 成功報告ダイアログを生成
				MessageDialog.openInformation(
						null,
						Messages.getString("successful"),
						msgFinishDeleteStorage);
				Display.getCurrent().asyncExec(new Runnable() {
					@Override
					public void run() {
						storage.getLocation().getComputeResources().updateStorages();
					}
				});
				
			} catch (Exception e) {
				Logger logger = Logger.getLogger(this.getClass());
				logger.error(e.getMessage(), e);

				String message = e.getMessage();
				if (message == null) {
					ByteArrayOutputStream bos = new ByteArrayOutputStream();
					PrintStream ps = new PrintStream(bos, true);
					e.printStackTrace(ps);

					message = bos.toString();
				}

				// 失敗報告ダイアログを生成
				MessageDialog.openError(null, Messages.getString("failed"), message);
			}
		}

		return null;
	}
}
