package com.clustercontrol.xcloud.ui.dialogs;

import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public abstract class DetailDialog extends Dialog {
	protected String input;
	protected String dialogTitle;

	public DetailDialog(Shell parentShell, String dialogTitle) {
		super(parentShell);
		setShellStyle(SWT.CLOSE | SWT.RESIZE | SWT.TITLE | SWT.APPLICATION_MODAL);
		this.dialogTitle = dialogTitle;
	}
	
	protected abstract Control createDialogArea(Composite parent);
	
	@Override
	protected Control createContents(Composite parent) {
		Control c = super.createContents(parent);
		getButton(IDialogConstants.CANCEL_ID).setVisible(false);
		return c;
	}
	
	@Override
	protected Point getInitialSize() {return new Point(475, 285);}

	public void setInput(String input) {this.input = input;}
	public String getInput() {return input;}

	@Override
	protected void configureShell(Shell newShell) {
		super.configureShell(newShell);
		newShell.setText(dialogTitle);
	}
}