package com.clustercontrol.xcloud.plugin.tester;

import org.eclipse.core.expressions.PropertyTester;

import com.clustercontrol.xcloud.extensions.CloudOptionCommandExtension;
import com.clustercontrol.xcloud.extensions.CloudOptionHandlerExtension;
import com.clustercontrol.xcloud.extensions.CloudOptionTesterExtension;
import com.clustercontrol.xcloud.extensions.ICloudOptionHandler;
import com.clustercontrol.xcloud.extensions.ICloudOptionTester;
import com.clustercontrol.xcloud.model.base.IElement;
import com.clustercontrol.xcloud.model.cloud.ICloudScope;
import com.clustercontrol.xcloud.plugin.CloudOptionSourceProvider;

public class CloudOptionPropertyTester extends PropertyTester {
	@Override
	public boolean test(Object receiver, String property, Object[] args, Object expectedValue) {
		Boolean result = null;
		switch(property) {
		case "handler":
			{
				ICloudScope cloudScope = null;
				try {
					cloudScope = (ICloudScope)((IElement)receiver).getAdapter(ICloudScope.class);
				} catch (NullPointerException e) {
				}
				
				ICloudOptionHandler handler = null;
				if (cloudScope != null) {
					CloudOptionHandlerExtension.CloudOptionHandlerHolder handlerHolder = CloudOptionHandlerExtension.getCloudOptionHandler(cloudScope.getPlatformId(), expectedValue.toString());
					if (handlerHolder != null) {
						if (handlerHolder.getCloudOptionHandler() == null) {
							// 未サポートのコマンドと判断。
							CloudOptionSourceProvider.setActiveOptionHandlerToProvider(null);
							return false;
						} else {
							handler = handlerHolder.getCloudOptionHandler();
						}
					}
				}
				
				if (handler == null)
					handler = CloudOptionCommandExtension.getDefaultCloudOptionHandlers(expectedValue.toString());
				
				CloudOptionSourceProvider.setActiveOptionHandlerToProvider(new CloudOptionSourceProvider.OptionHandlerHolder(expectedValue.toString(), handler));
				result = handler != null;
			}
			break;
		case "owner":
			{
				result = ((IElement)receiver).getOwner() != null;
			}
			break;
		}
		
		Boolean resourceTest = resourceTest(receiver, property, args, expectedValue);
		result = result != null ? (resourceTest != null ? (result && resourceTest): result): resourceTest;
		
		Boolean pluginTest = pluginTest(receiver, property, args, expectedValue);
		result = result != null ? (pluginTest != null ? (result && pluginTest): result): pluginTest;
		
		return result != null ? result: false;
	}

	protected Boolean resourceTest(Object receiver, String property, Object[] args, Object expectedValue) {
		return null;
	}
	
	protected Boolean pluginTest(Object receiver, String property, Object[] args, Object expectedValue) {
		ICloudScope cloudScope = null;
		try {
			cloudScope = (ICloudScope)((IElement)receiver).getAdapter(ICloudScope.class);
		} catch (NullPointerException e) {
		}
		if (cloudScope == null)
			return null;
		ICloudOptionTester tester = CloudOptionTesterExtension.getCloudOptionTester(cloudScope.getPlatformId());
		if (tester == null)
			return null;
		return tester.pluginTest(receiver, property, args, expectedValue);
	}
}