/*
Copyright (C) 2015 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.xcloud.model.cloud;

import java.util.List;

import com.clustercontrol.ws.notify.NotifyRelationInfo;
import com.clustercontrol.ws.xcloud.MonitorKind;
import com.clustercontrol.xcloud.model.base.Element;

public class BillingAlarm extends Element implements IBillingAlarm {
	private String id;
	private String name;
	private String description;
	private String facilityId;
	private MonitorKind monitorKind;
	private String notifyGroupId;
	private String ownerRoleId;
	private Long regDate;
	private String regUser;
	private Double thresholdInfoLimit;
	private Double thresholdWarnLimit;
	private String unit;
	private Long updateDate;
	private String updateUser;
	private Boolean validFlg;
	private Boolean collectFlg;
	private List<NotifyRelationInfo> notifyRelationInfos;

	public BillingAlarm(BillingAlarms billingAlarms){
		setOwner(billingAlarms);
	}

	@Override
	public BillingAlarms getBillingAlarms() {
		return (BillingAlarms)getOwner();
	}

	@Override
	public String getId() {
		return id;
	}

	public void setId(String id) {
		this.id = id;
	}

	@Override
	public String getName() {
		return name;
	}

	public void setName(String name) {
		internalSetProperty(p.name, name);
	}

	@Override
	public String getFacilityId() {
		return facilityId;
	}

	public void setFacilityId(String facilityId) {
		internalSetProperty(p.facilityId, facilityId);
	}

	@Override
	public MonitorKind getMonitorKind() {
		return monitorKind;
	}

	public void setMonitorKind(MonitorKind monitorKind) {
		internalSetProperty(p.monitorKind, monitorKind);
	}

	@Override
	public String getNotifyGroupId() {
		return notifyGroupId;
	}

	public void setNotifyGroupId(String notifyGroupId) {
		internalSetProperty(p.notifyGroupId, notifyGroupId);
	}

	@Override
	public String getOwnerRoleId() {
		return ownerRoleId;
	}

	public void setOwnerRoleId(String ownerRoleId) {
		internalSetProperty(p.ownerRoleId, ownerRoleId);
	}

	@Override
	public Double getThresholdInfoLimit() {
		return thresholdInfoLimit;
	}

	public void setThresholdInfoLimit(Double thresholdInfoLimit) {
		internalSetProperty(p.thresholdInfoLimit, thresholdInfoLimit);
	}

	@Override
	public Double getThresholdWarnLimit() {
		return thresholdWarnLimit;
	}

	public void setThresholdWarnLimit(Double thresholdWarnLimit) {
		internalSetProperty(p.thresholdWarnLimit, thresholdWarnLimit);
	}

	@Override
	public String getUnit() {
		return unit;
	}

	public void setUnit(String unit) {
		internalSetProperty(p.unit, unit);
	}

	@Override
	public Boolean getValidFlg() {
		return validFlg;
	}

	public void setValidFlg(Boolean validFlg) {
		internalSetProperty(p.validFlg, validFlg);
	}

	@Override
	public String getDescription() {
		return description;
	}
	public void setDescription(String description) {
		internalSetProperty(p.description, description);
	}

	@Override
	public Long getRegDate() {
		return regDate;
	}
	public void setRegDate(Long regDate) {
		internalSetProperty(p.regDate, regDate);
	}

	@Override
	public String getRegUser() {
		return regUser;
	}
	public void setRegUser(String regUser) {
		internalSetProperty(p.regUser, regUser);
	}

	@Override
	public Long getUpdateDate() {
		return updateDate;
	}
	public void setUpdateDate(Long updateDate) {
		internalSetProperty(p.updateDate, updateDate);
	}

	@Override
	public String getUpdateUser() {
		return updateUser;
	}
	public void setUpdateUser(String updateUser) {
		internalSetProperty(p.updateUser, updateUser);
	}

	public boolean equalValues(com.clustercontrol.ws.xcloud.BillingAlarm source) {
		return getId().equals(source.getId());
	}

	public static Storage convert(com.clustercontrol.ws.xcloud.Storage source) {
		Storage storage = new Storage();
		storage.update(source);
		return storage;
	}
	
	public void update(com.clustercontrol.ws.xcloud.BillingAlarm source) {
		setId(source.getId());
		setName(source.getName());
		setDescription(source.getDescription());
		setFacilityId(source.getFacilityId());
		setMonitorKind(source.getMonitorKind());
		setNotifyGroupId(source.getNotifyGroupId());
		setOwnerRoleId(source.getOwnerRoleId());
		setRegDate(source.getRegDate());
		setRegUser(source.getRegUser());
		setThresholdInfoLimit(source.getThresholdInfoLimit());
		setThresholdWarnLimit(source.getThresholdWarnLimit());
		setUnit(source.getUnit());
		setUpdateDate(source.getUpdateDate());
		setUpdateUser(source.getUpdateUser());
		setValidFlg(source.isValidFlg());
		setCollectFlg(source.isCollectFlg());
		setNotifyRelationInfos(source.getNotifyRelationInfos());
	}

	@Override
	public List<NotifyRelationInfo> getNotifyRelationInfos() {
		return notifyRelationInfos;
	}
	public void setNotifyRelationInfos(List<NotifyRelationInfo> notifyRelationInfos) {
		this.notifyRelationInfos = notifyRelationInfos;
	}
	
	public static BillingAlarm convert(BillingAlarms billingAlarms, com.clustercontrol.ws.xcloud.BillingAlarm source) {
		BillingAlarm billingAlarm = new BillingAlarm(billingAlarms);
		billingAlarm.update(source);
		return billingAlarm;
	}
	
	@Override
	public Object getAdapter(@SuppressWarnings("rawtypes") Class adapter) {
		if (adapter == IHinemosManager.class) {
			if (getBillingAlarms() != null)
				return getBillingAlarms().getHinemosManager();
		}
		return super.getAdapter(adapter);
	}

	@Override
	public Boolean getCollectFlg() {
		return collectFlg;
	}
	public void setCollectFlg(Boolean collectFlg) {
		this.collectFlg = collectFlg;
	}
}