package com.clustercontrol.xcloud.ui.handlers;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;

import org.apache.log4j.Logger;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.handlers.HandlerUtil;

import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.xcloud.CloudEndpoint;
import com.clustercontrol.xcloud.common.CloudStringConstants;
import com.clustercontrol.xcloud.extensions.ICloudOptionHandler;
import com.clustercontrol.xcloud.model.cloud.IInstance;
import com.clustercontrol.xcloud.ui.views.InstanceMonitorService;

public class PowerOnInstanceHandler implements ICloudOptionHandler, CloudStringConstants {
	@Override
	public Object execute(ExecutionEvent event) {
		IStructuredSelection selection = (IStructuredSelection)HandlerUtil.getActiveSite(event).getSelectionProvider().getSelection();
		final IInstance instance = (IInstance)selection.getFirstElement();
		final List<String> instanceIds = new ArrayList<>();
		for (@SuppressWarnings("rawtypes") Iterator iter = selection.iterator(); iter.hasNext();) {
			instanceIds.add(((IInstance)iter.next()).getId());
		}
		
		if (MessageDialog.openConfirm(
			null,
			Messages.getString("confirmed"),
			instanceIds.size() > 1 ? MessageFormat.format(msgConfirmPowerOnComputeNodeMulti, instanceIds.size()):
				MessageFormat.format(msgConfirmPowerOnComputeNode, instance.getName(), instance.getId()))) {

			try {
				CloudEndpoint endpoint = instance.getCloudScope().getCloudScopes().getHinemosManager().getEndpoint(CloudEndpoint.class);
				endpoint.powerOnInstances(instance.getCloudScope().getId(), instance.getLocation().getId(), instanceIds);
				
				// 成功報告ダイアログを生成
				MessageDialog.openInformation(
					null,
					Messages.getString("successful"),
					msgFinishPowerOnComputeNode);
				
				Display.getCurrent().asyncExec(new Runnable() {
					@Override
					public void run() {
						instance.getLocation().updateLocation();
						
						for (String instanceId: instanceIds) {
							InstanceMonitorService.getInstanceMonitorService().startMonitor(
								instance.getHinemosManager().getManagerName(),
								instance.getCloudScope().getId(),
								instance.getLocation().getId(),
								instanceId,
								"running"
								);
						}
					}
				});
			} catch (Exception e) {
				Logger logger = Logger.getLogger(this.getClass());
				logger.error(e.getMessage(), e);

				String message = e.getMessage();
				if (message == null) {
					ByteArrayOutputStream bos = new ByteArrayOutputStream();
					PrintStream ps = new PrintStream(bos, true);
					e.printStackTrace(ps);
					
					message = bos.toString();
				}
				
				// 失敗報告ダイアログを生成
				MessageDialog.openError(null, Messages.getString("failed"), message);
			}
		}
		return null;
	}
}
