package com.clustercontrol.xcloud.ui.handlers;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.List;

import org.apache.log4j.Logger;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.swt.widgets.Display;
import org.eclipse.ui.handlers.HandlerUtil;

import com.clustercontrol.util.Messages;
import com.clustercontrol.ws.xcloud.CloudEndpoint;
import com.clustercontrol.xcloud.common.CloudStringConstants;
import com.clustercontrol.xcloud.extensions.ICloudOptionHandler;
import com.clustercontrol.xcloud.model.cloud.ICloudScope;
import com.clustercontrol.xcloud.model.cloud.IInstance;
import com.clustercontrol.xcloud.model.cloud.IStorage;
import com.clustercontrol.xcloud.plugin.CloudOptionSourceProvider;

public class DetachStorageHandler implements ICloudOptionHandler, CloudStringConstants {
	@Override
	public Object execute(ExecutionEvent event) {
		IStructuredSelection selection = (IStructuredSelection)HandlerUtil.getCurrentSelection(event);
		final IStorage storage = (IStorage)selection.getFirstElement();
		IInstance instance = null;
		for (IInstance i: storage.getCloudComputeManager().getInstances()) {
			if (i.getId().equals(storage.getTargetInstanceId())) {
				instance = i;
				break;
			}
		}
		
		List<String> storageIds = new ArrayList<>();
		for (Object item: selection.toList()) {
			storageIds.add(((IStorage)item).getId());
		}
		loop_end:
		while(true){
			if (MessageDialog.openQuestion(
				null,
				Messages.getString("confirmed"),
				storageIds.size() > 1 ?
				MessageFormat.format(msgConfirmDetachStorageMulti, storageIds.size()):
				MessageFormat.format(msgConfirmDetachStorage, instance.getName(), instance.getId(), storage.getName(), storage.getId()))) {
				
				try {
					ICloudScope cloudScope = (ICloudScope)HandlerUtil.getVariable(event, CloudOptionSourceProvider.ActiveCloudScope);
					CloudEndpoint endpoint = storage.getCloudScope().getCloudScopes().getHinemosManager().getEndpoint(CloudEndpoint.class);
					endpoint.detachStorage(cloudScope.getId(),storage.getLocationId(), storageIds);
					
					// 成功報告ダイアログを生成
					MessageDialog.openInformation(
						null,
						Messages.getString("successful"),
						msgFinishDetachStorage);
					
					Display.getCurrent().asyncExec(new Runnable() {
						@Override
						public void run() {
							storage.getLocation().getComputeResources().updateStorages();
						}
					});
					
					break loop_end;
				} catch (Exception e) {
					Logger logger = Logger.getLogger(this.getClass());
					logger.error(e.getMessage(), e);

					String message = e.getMessage();
					if (message == null) {
						ByteArrayOutputStream bos = new ByteArrayOutputStream();
						PrintStream ps = new PrintStream(bos, true);
						e.printStackTrace(ps);
						
						message = bos.toString();
					}
					
					// 失敗報告ダイアログを生成
					MessageDialog.openError(null, Messages.getString("failed"), message);
					break loop_end;
				}
			} else {
				break loop_end;
			}
			
		}
		return null;
	}
}
