/*
Copyright (C) 2015 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.xcloud.model.base;

import com.clustercontrol.xcloud.model.CloudModelException;


public abstract class InternalComponent<C extends IInternalContainer<?, S>, S> extends Element implements IInternalComponent<C, S> {
	private C container;
	
	public InternalComponent(C container) {
		this.container = container;
	}
	
	public C getContainer() {
		return container;
	}
	
	@Override
	public void update() throws CloudModelException {
		S source = getSource();

		if (source != null) {
			internalUpdate(source);
		}
	}

	public abstract S getSource() throws CloudModelException;
	
	@Override
	public void internalUpdate(S source) {
		overwrite(source);
		fireEvent(new UpdateEvent(this));
	}

	protected abstract void overwrite(S source);
}