/*
Copyright (C) 2015 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.xcloud.model.base;

import java.util.List;

import org.eclipse.core.runtime.IAdaptable;




/**
 * 全ての要素の基底定義。
 * 
 * @author torun
 *
 */
public interface IElement extends IAdaptable {
	/**
	 * イベントリスナーの追加。
	 * 
	 * @param <L>
	 * @param type
	 * @param listener
	 */
	<L extends EventListener> void addEventListener(ListenerType<L> type, L listener);

	/**
	 * イベントリスナーの削除。
	 * 
	 * @param <L>
	 * @param type
	 * @param listener
	 */
	<L extends EventListener> void removeEventListener(ListenerType<L> type, L listener);

	/**
	 * プロパティオブザーバーの追加。
	 * 
	 * @param <P>
	 * @param <O>
	 * @param pid
	 * @param observer
	 */
	<P, O extends PropertyObserver<P>> void addPropertyObserver(PropertyId<O> pid, O observer);

	/**
	 * プロパティオブザーバーの削除。
	 * 
	 * @param <P>
	 * @param <O>
	 * @param pid
	 * @param observer
	 */
	<P, O extends PropertyObserver<P>> void removePropertyObserver(PropertyId<O> pid, O observer);
	
	<P, O extends PropertyObserver<P>> boolean propObsContained(PropertyId<O> pid, O observer);
	
	void addAnyPropertyObserver(AnyPropertyObserver observer);

	void removeAnyPropertyObserver(AnyPropertyObserver observer);
	
	void setData(Object key, Object value);
	Object getData(Object key);
	<T> T getData(Object key, Class<T> clazz);
	
	
	List<PropertyId<?>> getPropertyIds();
	
	<O extends PropertyObserver<P>, P> P getTypedProperty(PropertyId<O> pid);

	Object getProperty(PropertyId<?> pid);

	IElement getOwner();
}
