/*

 Copyright (C) 2014 NTT DATA Corporation

 This program is free software; you can redistribute it and/or
 Modify it under the terms of the GNU General Public License
 as published by the Free Software Foundation, version 2.

 This program is distributed in the hope that it will be
 useful, but WITHOUT ANY WARRANTY; without even the implied
 warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
 PURPOSE.  See the GNU General Public License for more details.

 */
package com.clustercontrol.http.model;

import java.io.Serializable;

import javax.persistence.Column;
import javax.persistence.EmbeddedId;
import javax.persistence.Entity;
import javax.persistence.Table;

import com.clustercontrol.commons.util.HinemosEntityManager;
import com.clustercontrol.commons.util.JpaTransactionManager;

@Entity
@Table(name="cc_monitor_http_scenario_variable_info", schema="setting")
//@Cacheable(true)
public class MonitorHttpScenarioVariableInfoEntity implements Serializable {
	private static final long serialVersionUID = 1L;

	private MonitorHttpScenarioVariableInfoEntityPK id;
	private String value;
	private Integer matchingWithResponseFlg;

	@Deprecated
	public MonitorHttpScenarioVariableInfoEntity() {
	}

	public MonitorHttpScenarioVariableInfoEntity(MonitorHttpScenarioPageInfoEntity pageEntity, MonitorHttpScenarioVariableInfoEntityPK pk) {
		this.setId(pk);
		HinemosEntityManager em = new JpaTransactionManager().getEntityManager();
		em.persist(this);
		pageEntity.getMonitorHttpScenarioVariableInfoEntities().add(this);
	}

	public MonitorHttpScenarioVariableInfoEntity(MonitorHttpScenarioPageInfoEntity pageEntity, String name) {
		this(pageEntity, new MonitorHttpScenarioVariableInfoEntityPK(pageEntity.getId().getMonitorId(), pageEntity.getId().getPageOrderNo(), name));
	}

	@EmbeddedId
	public MonitorHttpScenarioVariableInfoEntityPK getId() {
		return this.id;
	}

	public void setId(MonitorHttpScenarioVariableInfoEntityPK id) {
		this.id = id;
	}


	@Column(name="value")
	public String getValue() {
		return value;
	}

	public void setValue(String value) {
		this.value = value;
	}


	@Column(name="matching_with_response_flg")
	public Integer getMatchingWithResponseFlg() {
		return matchingWithResponseFlg;
	}

	public void setMatchingWithResponseFlg(Integer matchingWithResponseFlg) {
		this.matchingWithResponseFlg = matchingWithResponseFlg;
	}
}
