/*

Copyright (C) 2006 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.

 */

package com.clustercontrol.monitor.view.action;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.eclipse.core.commands.AbstractHandler;
import org.eclipse.core.commands.ExecutionEvent;
import org.eclipse.core.commands.ExecutionException;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.StructuredSelection;
import org.eclipse.ui.IPerspectiveDescriptor;
import org.eclipse.ui.IPerspectiveRegistry;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.IWorkbenchPart;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.commands.IElementUpdater;
import org.eclipse.ui.handlers.HandlerUtil;
import org.eclipse.ui.menus.UIElement;

import com.clustercontrol.accesscontrol.util.ClientSession;
import com.clustercontrol.bean.HinemosModuleConstant;
import com.clustercontrol.jobmanagement.composite.DetailComposite;
import com.clustercontrol.jobmanagement.composite.HistoryComposite;
import com.clustercontrol.jobmanagement.util.JobEndpointWrapper;
import com.clustercontrol.jobmanagement.view.JobDetailView;
import com.clustercontrol.jobmanagement.view.JobHistoryView;
import com.clustercontrol.monitor.action.GetStatusListTableDefine;
import com.clustercontrol.monitor.composite.StatusListComposite;
import com.clustercontrol.monitor.view.StatusView;
import com.clustercontrol.util.Messages;
import com.clustercontrol.view.ScopeListBaseView;
import com.clustercontrol.ws.jobmanagement.JobInfoNotFound_Exception;
import com.clustercontrol.ws.jobmanagement.JobTreeItem;

/**
 * ジョブ履歴パースペクティブを開くクライアント側アクションクラス<BR>
 *
 * @version 5.0.0
 * @since 5.0.0
 */
public class StatusOpenJobHistoryAction extends AbstractHandler implements IElementUpdater {
	private IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();

	/** アクションID */
	public static final String ID = StatusOpenJobHistoryAction.class.getName();

	/** ログ */
	private static Log m_log = LogFactory.getLog(EventOpenJobHistoryAction.class);

	/** ビュー */
	private IWorkbenchPart viewPart;

	/**
	 * Dispose
	 */
	@Override
	public void dispose() {
		this.viewPart = null;
		this.window = null;
	}

	private JobTreeItem getChild(JobTreeItem item) {
		JobTreeItem child = item.getChildren().size() >0 ? item.getChildren().get(0) : null;

		if (child != null) {
			child = getChild(child);
		} else {
			return item;
		}
		return child;
	}

	@Override
	/*
	 * (non-Javadoc)
	 *
	 * @see org.eclipse.core.commands.IHandler#execute
	 */
	public Object execute(ExecutionEvent event) throws ExecutionException {
		this.window = HandlerUtil.getActiveWorkbenchWindow(event);
		// In case this action has been disposed
		if( null == this.window || !isEnabled() ){
			return null;
		}

		// 選択アイテムの取得
		this.viewPart = HandlerUtil.getActivePart(event);

		JobTreeItem item;
		IPerspectiveRegistry reg = PlatformUI.getWorkbench()
				.getPerspectiveRegistry();

		PlatformUI.getWorkbench().getActiveWorkbenchWindow();
		IPerspectiveDescriptor desc = reg.findPerspectiveWithId("com.clustercontrol.jobmanagement.ui.JobHistoryPerspective");
		if (desc != null) {
			// 選択アイテムを取得します。
			ScopeListBaseView statusView = (StatusView) this.viewPart.getAdapter(StatusView.class);
			StatusListComposite composite = (StatusListComposite) statusView.getListComposite();
			StructuredSelection  selection = (StructuredSelection) composite.getTableViewer().getSelection();

			List<?> list = (ArrayList<?>) selection.getFirstElement();

			if (list != null) {
				//セッションID（監視ID）を取得
				String monitorId = (String) list.get(GetStatusListTableDefine.MONITOR_ID);
				String managerName = (String) list.get(GetStatusListTableDefine.MANAGER_NAME);
				try {
					JobEndpointWrapper wrapper = JobEndpointWrapper.getWrapper(managerName);
					item = wrapper.getJobDetailList(monitorId);
				} catch (JobInfoNotFound_Exception e) {
					ClientSession.occupyDialog();
					MessageDialog.openInformation(null, Messages.getString("message"),
							Messages.getString("message.job.122"));
					ClientSession.freeDialog();
					return null;
				} catch (Exception e) {
					m_log.warn("run() getJobDetailList, " + e.getMessage(), e);
					if(ClientSession.isDialogFree()){
						ClientSession.occupyDialog();
						MessageDialog.openError(
								null,
								Messages.getString("failed"),
								Messages.getString("message.hinemos.failure.unexpected") + ", " + e.getMessage());
						ClientSession.freeDialog();
					}
					return null;
				}

				IWorkbenchPage page = window.getActivePage();

				//パースペクティブを開く
				page.setPerspective(desc);

				//viewとcompositeを取得
				JobHistoryView historyView = (JobHistoryView)page.findView(JobHistoryView.ID);
				JobDetailView detailView = (JobDetailView)page.findView(JobDetailView.ID);
				HistoryComposite historyCmp = historyView.getComposite();

				//ジョブID、ジョブユニットIDを取得
				ArrayList<?> objList = (ArrayList<?>)historyCmp.getTableViewer().getInput();
				if (objList == null || objList.size() == 0) {
					return null;
				}

				//セッションID、ジョブIDをセット
				historyCmp.setSessionId(monitorId);
				DetailComposite detailCmp = detailView.getComposite();
				JobTreeItem child = getChild(item);
				String jobId = child.getData().getId();
				String jobunitId = child.getData().getJobunitId();

				//該当のレコードを選択
				detailCmp.setJobId(jobId);
				detailCmp.setSessionId(monitorId);

				//該当のレコードを選択
				historyView.update();
				detailCmp.setItem(managerName, monitorId, jobunitId, item);
			}
		}
		return null;
	}

	@Override
	public void updateElement(UIElement element, @SuppressWarnings("rawtypes") Map parameters) {
		IWorkbenchWindow window = PlatformUI.getWorkbench().getActiveWorkbenchWindow();
		// page may not start at state restoring
		if( null != window ){
			IWorkbenchPage page = window.getActivePage();
			if( null != page ){
				IWorkbenchPart part = page.getActivePart();

				boolean editEnable = false;
				if(part instanceof StatusView){
					// Enable button when 1 item is selected
					StatusView view = (StatusView)part;

					if(view.getRowNum() == 1 &&
							HinemosModuleConstant.JOB.equals(view.getPluginId())){
						editEnable = true;
					}
				}
				this.setBaseEnabled(editEnable);
			} else {
				this.setBaseEnabled(false);
			}
		}
	}
}
