/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */

package com.clustercontrol.cloud.ui.views.actions;


import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Text;

import com.clustercontrol.cloud.commons.util.ControlUtil;
import com.clustercontrol.cloud.commons.util.MessageManager;
import com.clustercontrol.cloud.presenter.EditBillingDetailCollectorSettingRequet;
import com.clustercontrol.cloud.presenter.IAccountResource;
import com.clustercontrol.cloud.ui.dialogs.BillingDetailCollectSettingDialog;
import com.clustercontrol.util.Messages;


public class EditBillingDetailCollectionSettingAction extends SingleSelectionActionEx {
	public static final String ID = "com.clustercontrol.cloud.ui.views.actions.EditBillingDetailCollectionSettingAction";

	private MessageManager messages = MessageManager.getInstance("messages");
	
	private String msgEditBillingDetailCollectionSettingsConfirm = messages.getString("message.confirm_some_action_to_something", new Object[]{"caption.billing_detail_collection_settings", "word.modify"});
	private String msgEditBillingDetailCollectionSettingsResult = messages.getString("message.result_some_action_to_something", new Object[]{"caption.billing_detail_collection_settings", "word.modify"});

	@Override
	protected void invoke(IAction action) throws InvocationException {
		IStructuredSelection selection = (IStructuredSelection) viewPart.getSite().getSelectionProvider().getSelection();
		final IAccountResource accountResource = (IAccountResource) selection.getFirstElement();
		
		BillingDetailCollectSettingDialog dialog = new BillingDetailCollectSettingDialog(viewPart.getSite().getShell());
		
		dialog.setBehavior(new BillingDetailCollectSettingDialog.IDialogBehavior(){
			@Override
			public void setupRetentionPeriod(Text txtRetentionPeriod) {
				if(accountResource.getRetentionPeriod() != null){
					txtRetentionPeriod.setText(accountResource.getRetentionPeriod().toString());
				}
			}
			@Override
			public void setupBillingDetailCollectorFlg(Button btnBillingDetailCollectorFlg) {
				if(accountResource.getBillingDetailCollectorFlg() != null){
					btnBillingDetailCollectorFlg.setSelection(accountResource.getBillingDetailCollectorFlg());
				}
			}
		});
		
		if(dialog.open() == Window.OK){
			if (MessageDialog.openConfirm(
				null,
				Messages.getString("confirmed"),
				msgEditBillingDetailCollectionSettingsConfirm)) {
				
				BillingDetailCollectSettingDialog.DialogOutput output = dialog.getOutput();
				
				EditBillingDetailCollectorSettingRequet request = new EditBillingDetailCollectorSettingRequet();
				ControlUtil.importObject(request, output);
				request.setAccountResourceId(accountResource.getAccountResourceId());
				accountResource.editBillingDetailCollectorSetting(request);
				
				// 成功報告ダイアログを生成
				MessageDialog.openInformation(
					null,
					Messages.getString("successful"),
					msgEditBillingDetailCollectionSettingsResult);
			}
			else {
				return;
			}
		}
	}
}