/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.presenter;

import java.util.ArrayList;
import java.util.List;

public class Scope extends Facility implements IScope {
	private Scope parent;
	private ScopeType scopeType;
	private List<Scope> scopes = new ArrayList<Scope>();
	private List<Node> nodes = new ArrayList<Node>();

	public Scope() {
	}
	
	@Override
	public Scope getParent() {
		return parent;
	}
	
	public void setParent(Scope parent) {
		this.parent = parent;
	}

	@Override
	public Scope[] getScopes() {
		return scopes.toArray(new Scope[0]);
	}

	public void addChildScope(Scope child) {
		if (!scopes.contains(child)) {
			scopes.add(child);
			fireElementAdded(IScope.p2.scopes, child);
		}
	}
	
	public void removeChildScope(Scope child) {
		if (scopes.contains(child)) {
			scopes.remove(child);
			fireElementRemoved(IScope.p2.scopes, child);
		}
	}

	@Override
	public Node[] getNodes() {
		return nodes.toArray(new Node[0]);
	}

	public void addChildNode(Node child) {
		if (!nodes.contains(child)) {
			nodes.add(child);
			fireElementAdded(IScope.p2.nodes, child);
		}
	}
	
	public void removeChildNode(Node child) {
		if (nodes.contains(child)) {
			nodes.remove(child);
			fireElementRemoved(IScope.p2.nodes, child);
		}
	}

	@Override
	public FacilityRoot getFacilityRoot() {
		return parent.getFacilityRoot();
	}

	public CloudResourceManager getCloudResourceManager() {
		return getFacilityRoot().getCloudResourceManager();
	}

	@Override
	public ScopeType getScopeType() {
		return scopeType;
	}
	
	public void setScopeType(ScopeType type) {
		this.scopeType = type;
	}

	@Override
	public String getAccountResourceId() {
		return getScopeType().getAccountResourceId(this);
	}

	@Override
	public String getRegion() {
		return getScopeType().getRegion(this);
	}
}
