/*
Copyright (C) 2014 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */

package com.clustercontrol.cloud.cloudn.base.ui.views.actions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.Window;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.widgets.Shell;

import com.clustercontrol.bean.RequiredFieldColorConstant;
import com.clustercontrol.cloud.cloudn.base.commons.util.CloudnConstants;
import com.clustercontrol.cloud.cloudn.base.commons.util.MessageManagerExt;
import com.clustercontrol.cloud.cloudn.base.resources.CloudResourceProvider;
import com.clustercontrol.cloud.cloudn.base.resources.CloudResourceProviderImpl;
import com.clustercontrol.cloud.cloudn.base.resources.Filter;
import com.clustercontrol.cloud.cloudn.base.resources.Template;
import com.clustercontrol.cloud.cloudn.base.resources.Zone;
import com.clustercontrol.cloud.cloudn.base.ui.dialogs.CreateTemplateDialog;
import com.clustercontrol.cloud.cloudn.base.ui.dialogs.SelectVMIDialog;
import com.clustercontrol.cloud.cloudn.base.ui.dialogs.CreateTemplateDialog.DialogControlContainer;
import com.clustercontrol.cloud.commons.util.TemplateJobUtil;
import com.clustercontrol.cloud.presenter.IAccountResource;
import com.clustercontrol.cloud.presenter.ICloudTemplate;
import com.clustercontrol.cloud.presenter.ModifyCloudTemplateRequest;
import com.clustercontrol.cloud.ui.views.TemplatesView;
import com.clustercontrol.cloud.ui.views.actions.InvocationException;
import com.clustercontrol.cloud.ui.views.actions.SingleSelectionActionEx;
import com.clustercontrol.util.Messages;


public class ModifyTemplateAction extends SingleSelectionActionEx {
	private MessageManagerExt messages = MessageManagerExt.getInstance("messages");
	
	private String msgModifyTemplateConfirm = messages.getString("message.confirm_some_action_to_something", new Object[]{"word.template", "word.modify"});
	private String msgModifyTemplateResult = messages.getString("message.result_some_action_to_something", new Object[]{"word.template", "word.modify"});

	private CloudResourceProvider provider;
	private ICloudTemplate template;
	
	@Override
	protected void invoke(IAction action) throws InvocationException {
		template = (ICloudTemplate)((IStructuredSelection)this.viewPart.getSite().getSelectionProvider().getSelection()).getFirstElement();
		final IAccountResource accountResource = ((TemplatesView)viewPart).getAccountResource();
		provider = new CloudResourceProviderImpl(accountResource.getAccountResourceId());
		final CreateTemplateDialog dialog = new CreateTemplateDialog(this.viewPart.getSite().getShell());
		dialog.setCloudInfoProvider(provider);
		try {
			dialog.setBehavior(new CreateTemplateDialog.IDialogBehavior(){
				@Override
				public void setup(final DialogControlContainer container) {
					MessageManagerExt messages = MessageManagerExt.getInstance("messages");
					List<TemplateJobUtil.TemplateJobnet> templateJobs;

					container.getCmbZone().addModifyListener(new ModifyListener() {
						@Override
						public void modifyText(ModifyEvent e) {
							container.getTxtVmi().setText("");
							container.getTxtVmi().setData(null);
							container.getTxtVmi().setBackground(RequiredFieldColorConstant.COLOR_REQUIRED);
						}
					});
					
					container.getCmbRegion().addModifyListener(new ModifyListener() {
						public void modifyText(ModifyEvent e) {
							setupZone(container);
						}
					});
					
					try{
						templateJobs = TemplateJobUtil.getTemplateJobList(accountResource.getAccountResourceId(), true);
					} catch(Exception e) {
						MessageDialog.openError(null, Messages.getString("failed"), e.getMessage());
						templateJobs = new ArrayList<TemplateJobUtil.TemplateJobnet>();
					}

					for (String regionName: provider.getAllRegion()) {
						String regionLocaleName = messages.getString(regionName);
						container.getCmbRegion().add(regionLocaleName);
						container.getCmbRegion().setData(regionLocaleName, regionName);
					}

					if (template != null && template.getRegion() != null && !template.getRegion().equals("")) {
						String regionLocaleName = messages.getString(template.getRegion());
						container.getCmbRegion().select(container.getCmbRegion().indexOf(regionLocaleName));
					} else {
						container.getCmbRegion().select(0);
					}
					
					final Shell shell = dialog.getShell();
					container.getBtnSelectVmi().addSelectionListener(new SelectionAdapter(){
						@Override
						public void widgetSelected(SelectionEvent e) {
							List<Template> officials = provider.getTemplates(CloudnConstants.DEFAULT_REGION, Arrays.asList(new Filter("category", "official"), new Filter("zone", container.getCmbZone().getText())));
							List<Template> mys = provider.getTemplates(CloudnConstants.DEFAULT_REGION, Arrays.asList(new Filter("category", "my"), new Filter("zone", container.getCmbZone().getText())));
							SelectVMIDialog dialog = new SelectVMIDialog(officials, mys, shell);
							if (dialog.open() == Window.OK) {
								Template output = dialog.getOutput();
								container.getTxtVmi().setText(output.getName() + " ( " + output.getId() + " ) ");
								container.getTxtVmi().setData(output);
							}
						}
					});

					if(template != null){
						container.getTxtTemplateId().setText(template.getTemplateId());
						container.getTxtTemplateId().setEditable(false);
					}
					
					if(template != null && template.getTemplateName() != null && !template.getTemplateName().isEmpty()){
						container.getTxtTemplateName().setText(template.getTemplateName());
					}
					
					if(template != null && template.getImageId() != null && !template.getImageId().equals("") && template.getRegion() != null && !template.getRegion().equals("")){
						Filter f1 = new Filter();
						f1.setName("image-id");
						f1.setValues(Arrays.asList(template.getImageId()));

						Filter f2 = new Filter();
						f2.setName("zone");
						
//						for(String zone: container.getCmbZone().getItems()){
//							f2.setValues(Arrays.asList(zone));
							f2.setValues(Arrays.asList(template.getImageId().substring(37)));
							List<Template> imageList = provider.getTemplates(template.getRegion(), Arrays.asList(f1, f2));
							if (!imageList.isEmpty()) {
								Template image = imageList.get(0);
//								container.getCmbZone().select(container.getCmbZone().indexOf(zone));
								container.getCmbZone().select(container.getCmbZone().indexOf(image.getId().substring(37)));
								
								container.getTxtVmi().setText(image.getName() + " ( " + image.getId() + " ) ");
								container.getTxtVmi().setData(image);
								container.getTxtVmi().setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
//								break;
							}
//						}
					}
					
					container.getCmbLaunchJobId().add("");
					container.getCmbStartJobId().add("");
					container.getCmbStopJobId().add("");
					
					Map<String, String> tmpMap = new HashMap<String, String>();
					for(TemplateJobUtil.TemplateJobnet childJobItem : templateJobs){
						String jobId = childJobItem.getJobnetId();
						String jobName = childJobItem.getJobnetName() + " ( " + jobId + " )";
						tmpMap.put(jobId, jobName);
						container.getCmbLaunchJobId().add(jobName);
						container.getCmbLaunchJobId().setData(jobName, jobId);
						container.getCmbStartJobId().add(jobName);
						container.getCmbStartJobId().setData(jobName, jobId);
						container.getCmbStopJobId().add(jobName);
						container.getCmbStopJobId().setData(jobName, jobId);
					}
					if(template != null && template.getLaunchJobId() != null && !template.getLaunchJobId().equals("") && tmpMap.containsKey(template.getLaunchJobId())){
						container.getCmbLaunchJobId().select(container.getCmbLaunchJobId().indexOf(tmpMap.get(template.getLaunchJobId())));
					}
					if(template != null && template.getStartJobId() != null && !template.getStartJobId().equals("") && tmpMap.containsKey(template.getStartJobId())){
						container.getCmbStartJobId().select(container.getCmbStartJobId().indexOf(tmpMap.get(template.getStartJobId())));
					}
					if(template != null && template.getStopJobId() != null && !template.getStopJobId().equals("") && tmpMap.containsKey(template.getStopJobId())){
						container.getCmbStopJobId().select(container.getCmbStopJobId().indexOf(tmpMap.get(template.getStopJobId())));
					}
				}
				
				private void setupZone(DialogControlContainer container){
					container.getCmbZone().removeAll();
					
					for(Zone zone: provider.getZones((String)container.getCmbRegion().getData(container.getCmbRegion().getText()))){
						container.getCmbZone().add(zone.getName());
						container.getCmbZone().setData(zone.getName(), zone);
					}
					if(container.getCmbZone().getItemCount() > 0){
						container.getCmbZone().select(0);
					}
				}
			});
		} catch (Exception e) {
			throw new InvocationException(e);
		}

		if (dialog.open() == Window.OK) {
			if (MessageDialog.openConfirm(
				null,
				Messages.getString("confirmed"),
				msgModifyTemplateConfirm)) {

				ModifyCloudTemplateRequest request = new ModifyCloudTemplateRequest();

				request.setImageId(dialog.getOutput().getImageId());
				request.setJobUnitId(template.getJobUnitId());
				request.setLaunchJobId(dialog.getOutput().getLaunchJobId());
				request.setStartJobId(dialog.getOutput().getStartJobId());
				request.setStopJobId(dialog.getOutput().getStopJobId());
				request.setRegion(dialog.getOutput().getRegion());
				request.setTemplateId(dialog.getOutput().getTemplateId());
				request.setTemplateName(dialog.getOutput().getTemplateName());
				
				template.modifyCloudTemplate(request);
				
				// 成功報告ダイアログを生成
				MessageDialog.openInformation(
					null,
					Messages.getString("successful"),
					msgModifyTemplateResult);
			}
			else {
				return;
			}
		}
	}
}