/*
Copyright (C) 2014 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */

package com.clustercontrol.cloud.cloudn.base.ui.views.actions;

import java.util.Arrays;
import java.util.List;

import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;
import org.eclipse.jface.viewers.IStructuredSelection;
import org.eclipse.jface.window.Window;

import com.clustercontrol.bean.RequiredFieldColorConstant;
import com.clustercontrol.cloud.cloudn.base.commons.util.MessageManagerExt;
import com.clustercontrol.cloud.cloudn.base.presenter.JobTrackingService;
import com.clustercontrol.cloud.cloudn.base.resources.CloudResourceProvider;
import com.clustercontrol.cloud.cloudn.base.resources.CloudResourceProviderImpl;
import com.clustercontrol.cloud.cloudn.base.resources.Filter;
import com.clustercontrol.cloud.cloudn.base.resources.Template;
import com.clustercontrol.cloud.cloudn.base.ui.dialogs.CreateInstanceDialog_FLAT;
import com.clustercontrol.cloud.cloudn.base.ui.views.actions.CreateInstanceAction_FLAT.InstanceDetail;
import com.clustercontrol.cloud.presenter.CreateCloudInstanceByTemplateRequest;
import com.clustercontrol.cloud.presenter.CreateCloudInstanceRequest;
import com.clustercontrol.cloud.presenter.IAccountResource.IRegion;
import com.clustercontrol.cloud.presenter.CloudModelException;
import com.clustercontrol.cloud.presenter.ICloudComputeService;
import com.clustercontrol.cloud.presenter.ICloudInstance;
import com.clustercontrol.cloud.presenter.ICloudTemplate;
import com.clustercontrol.cloud.presenter.ICloudTemplateManager;
import com.clustercontrol.cloud.presenter.InvalidStateException;
import com.clustercontrol.cloud.presenter.ICloudInstance.StateType;
import com.clustercontrol.cloud.ui.views.InstanceMonitorService;
import com.clustercontrol.cloud.ui.views.TemplatesView;
import com.clustercontrol.cloud.ui.views.actions.InvocationException;
import com.clustercontrol.cloud.ui.views.actions.SingleSelectionActionEx;
import com.clustercontrol.util.Messages;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;


public class CreateInstanceByTemplateAction_FLAT extends SingleSelectionActionEx {
	private MessageManagerExt messages = MessageManagerExt.getInstance("messages");
	
	private String msgCreateInstanceConfirm = messages.getString("message.confirm_some_action_to_something", new Object[]{"word.instance", "word.create"});
	private String msgCreateInstanceResult = messages.getString("message.result_some_action_to_something", new Object[]{"word.instance", "word.create"});

	private ICloudTemplateManager templateManager;
	private ICloudTemplate template;
	
	private CloudResourceProvider provider;
	
	@Override
	protected void invoke(IAction action) throws InvocationException {
		final CreateInstanceDialog_FLAT dialog = new CreateInstanceDialog_FLAT(this.viewPart.getSite().getShell());

		final TemplatesView view = (TemplatesView)viewPart;
		template = (ICloudTemplate)((IStructuredSelection)viewPart.getSite().getSelectionProvider().getSelection()).getFirstElement();
		templateManager = template.getCloudTemplateManager();
		dialog.setCloudTemplateManager(templateManager);

		provider = new CloudResourceProviderImpl(view.getAccountResource().getAccountResourceId());
		dialog.setCloudInfoProvider(provider);
		dialog.setRegion(template.getRegion());
		
		dialog.setBehavior(new CreateInstanceDialog_FLAT.IDialogBehavior() {
			private String msgTemplateDoesNotExists = messages.getString("message.template_does_not_exists");

			@Override
			public void setup(final CreateInstanceDialog_FLAT.DialogControlContainer container) {
				Filter f1 = new Filter();
				f1.setName("image-id");
				f1.setValues(Arrays.asList(template.getImageId()));

				Filter f2 = new Filter();
				f2.setName("zone");

				f2.setValues(Arrays.asList(template.getImageId().substring(37)));
				List<Template> imageList = provider.getTemplates(template.getRegion(), Arrays.asList(f1, f2));
				if (!imageList.isEmpty()) {
					Template image = imageList.get(0);
					container.getCmbZone().select(container.getCmbZone().indexOf(image.getId().substring(37)));
					
					container.getTxtVMI().setText(image.getName() + " ( " + image.getId() + " ) ");
					container.getTxtVMI().setData(image);
					container.getTxtVMI().setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
				}
				
				imageList = provider.getTemplates(template.getRegion(), Arrays.asList(f2));
				if(!imageList.isEmpty()){
					container.getBtnUseTemplate().setSelection(true);
					for(ICloudTemplate tmpTemplate: templateManager.getCloudTemplates()){
						if (tmpTemplate.getRegion().equals(template.getRegion())
								&& tmpTemplate.getImageId().substring(37).equals(container.getCmbZone().getText())
							) {
							String tmpLabel = tmpTemplate.getTemplateName() + " ( " + tmpTemplate.getTemplateId() + " )";
							container.getCmbTemplate().add(tmpLabel);
							container.getCmbTemplate().setData(tmpLabel, tmpTemplate);
							if(tmpTemplate.getImageId().equals(template.getImageId())){
								container.getCmbTemplate().select(container.getCmbTemplate().indexOf(tmpLabel));
							}
						}
					}
					if(container.getCmbTemplate().getSelectionIndex() == -1 && container.getCmbTemplate().getItemCount() > 0) {
						container.getCmbTemplate().select(0);
					}
				}
				
				if (container.getCmbTemplate().getItemCount() > 0) {
					container.getLblTemplate().setEnabled(true);
					container.getCmbTemplate().setEnabled(true);
					container.getBtnEditArgument().setEnabled(true);
					container.getLblVMI().setEnabled(false);
					container.getTxtVMI().setEnabled(false);
					container.getBtnSelectVMI().setEnabled(false);
					container.getTxtVMI().setBackground(RequiredFieldColorConstant.COLOR_UNREQUIRED);
				} else {
					MessageDialog.openError(null, Messages.getString("failed"), msgTemplateDoesNotExists);
					container.getBtnUseTemplate().setSelection(false);
				}
			}
		});
		
		if(dialog.open() == Window.OK){
			if (MessageDialog.openConfirm(
				null,
				Messages.getString("confirmed"),
				msgCreateInstanceConfirm)){

				CreateInstanceDialog_FLAT.Model m = dialog.getOutput();

				IRegion r = templateManager.getAccountResource().getRegion(template.getRegion());
				final ICloudInstance instance;

				InstanceDetail detail = new InstanceDetail();
				if (m.getSecurityGroups() != null) detail.securityGroups.addAll(m.getSecurityGroups());
				detail.group = m.getGroup();
				detail.attachingDisk = m.getAttachingDisk();
				
				ObjectMapper om = new ObjectMapper();
				ObjectWriter dw = om.writerWithType(InstanceDetail.class);
				String detailJson;
				try {
					detailJson = dw.writeValueAsString(detail);
				} catch (Exception e) {
					throw new CloudModelException(e);
				}
				
				if(m.isTemplateUsed()){
					CreateCloudInstanceByTemplateRequest request = new CreateCloudInstanceByTemplateRequest();
					
					request.setZone(m.getZone());
					
					request.setTemplateId(m.getTemplateId());
					
					request.setFlavor(m.getFlavor());
					
					request.setFacilityId(m.getFacilityId());
					request.setFacilityName(m.getFacilityName());
					request.setDescription(m.getDescription());
					request.setNodeName(m.getNodeName());
					request.setReplaceNode(m.getReplaceNode());
					
					request.setInstanceDetail(detailJson);
					
					request.setTags(m.getTags());
					request.setArguments(m.getArguments());
					
					instance = r.getAccountResource().getRegion(template.getRegion()).getCloudService(ICloudComputeService.class).getInstanceManager().createCloudInstanceByTemplate(request);
				} else {
					CreateCloudInstanceRequest request = new CreateCloudInstanceRequest();
					
					request.setZone(m.getZone());
					request.setImageId(m.getImageId());
					request.setFlavor(m.getFlavor());
					
					request.setFacilityId(m.getFacilityId());
					request.setFacilityName(m.getFacilityName());
					request.setDescription(m.getDescription());
					request.setNodeName(m.getNodeName());
					request.setReplaceNode(m.getReplaceNode());
					
					request.setInstanceDetail(detailJson);
					
					request.setTags(m.getTags());
					
					instance = r.getAccountResource().getRegion(template.getRegion()).getCloudService(ICloudComputeService.class).getInstanceManager().createCloudInstance(request);
				}
				
				// 成功報告ダイアログを生成
				MessageDialog.openInformation(
					null,
					Messages.getString("successful"),
					msgCreateInstanceResult);

				// Password を追跡して別ダイアログに表示する
				try {
					JobTrackingService.trackPassword(viewPart, instance);
				} catch (InvalidStateException e) {
						throw new InvocationException(e);
				}
				
				view.getSite().getShell().getDisplay().asyncExec(new Runnable() {
					@Override
					public void run() {
						InstanceMonitorService.getInstanceMonitorService().startMonitor(instance, StateType.running, StateType.terminated, StateType.stopped);
						com.clustercontrol.action.FacilityTree.refresh();
					}
				});
			}
			else {
				return;
			}
		}
	}
}