
package com.clustercontrol.ws.cloud;

import java.util.List;
import javax.jws.WebMethod;
import javax.jws.WebParam;
import javax.jws.WebResult;
import javax.jws.WebService;
import javax.xml.bind.annotation.XmlSeeAlso;
import javax.xml.ws.Action;
import javax.xml.ws.FaultAction;
import javax.xml.ws.RequestWrapper;
import javax.xml.ws.ResponseWrapper;


/**
 * This class was generated by the JAX-WS RI.
 * JAX-WS RI 2.2.7-b01 
 * Generated source version: 2.2
 * 
 */
@WebService(name = "CloudEndpoint", targetNamespace = "http://cloud.ws.clustercontrol.com")
@XmlSeeAlso({
    ObjectFactory.class
})
public interface CloudEndpoint {


    /**
     * 
     * @param region
     * @param instanceId
     * @param roleId
     * @return
     *     returns com.clustercontrol.ws.cloud.CloudInstance
     * @throws InvalidRole_Exception
     * @throws CloudManagerFault_Exception
     * @throws InvalidUserPass_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "getInstance", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.GetInstance")
    @ResponseWrapper(localName = "getInstanceResponse", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.GetInstanceResponse")
    @Action(input = "http://cloud.ws.clustercontrol.com/CloudEndpoint/getInstanceRequest", output = "http://cloud.ws.clustercontrol.com/CloudEndpoint/getInstanceResponse", fault = {
        @FaultAction(className = CloudManagerFault_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/getInstance/Fault/CloudManagerFault"),
        @FaultAction(className = InvalidUserPass_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/getInstance/Fault/InvalidUserPass"),
        @FaultAction(className = InvalidRole_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/getInstance/Fault/InvalidRole")
    })
    public CloudInstance getInstance(
        @WebParam(name = "roleId", targetNamespace = "")
        String roleId,
        @WebParam(name = "region", targetNamespace = "")
        String region,
        @WebParam(name = "instanceId", targetNamespace = "")
        String instanceId)
        throws CloudManagerFault_Exception, InvalidRole_Exception, InvalidUserPass_Exception
    ;

    /**
     * 
     * @param region
     * @param request
     * @param roleId
     * @return
     *     returns com.clustercontrol.ws.cloud.CloudInstance
     * @throws InvalidRole_Exception
     * @throws CloudManagerFault_Exception
     * @throws InvalidUserPass_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "restoreInstance", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.RestoreInstance")
    @ResponseWrapper(localName = "restoreInstanceResponse", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.RestoreInstanceResponse")
    @Action(input = "http://cloud.ws.clustercontrol.com/CloudEndpoint/restoreInstanceRequest", output = "http://cloud.ws.clustercontrol.com/CloudEndpoint/restoreInstanceResponse", fault = {
        @FaultAction(className = CloudManagerFault_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/restoreInstance/Fault/CloudManagerFault"),
        @FaultAction(className = InvalidUserPass_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/restoreInstance/Fault/InvalidUserPass"),
        @FaultAction(className = InvalidRole_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/restoreInstance/Fault/InvalidRole")
    })
    public CloudInstance restoreInstance(
        @WebParam(name = "roleId", targetNamespace = "")
        String roleId,
        @WebParam(name = "region", targetNamespace = "")
        String region,
        @WebParam(name = "request", targetNamespace = "")
        RestoreInstanceRequest request)
        throws CloudManagerFault_Exception, InvalidRole_Exception, InvalidUserPass_Exception
    ;

    /**
     * 
     * @param region
     * @param instanceId
     * @param roleId
     * @throws InvalidRole_Exception
     * @throws InvalidUserPass_Exception
     * @throws CloudManagerFault_Exception
     */
    @WebMethod
    @RequestWrapper(localName = "removeInstance", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.RemoveInstance")
    @ResponseWrapper(localName = "removeInstanceResponse", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.RemoveInstanceResponse")
    @Action(input = "http://cloud.ws.clustercontrol.com/CloudEndpoint/removeInstanceRequest", output = "http://cloud.ws.clustercontrol.com/CloudEndpoint/removeInstanceResponse", fault = {
        @FaultAction(className = CloudManagerFault_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/removeInstance/Fault/CloudManagerFault"),
        @FaultAction(className = InvalidUserPass_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/removeInstance/Fault/InvalidUserPass"),
        @FaultAction(className = InvalidRole_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/removeInstance/Fault/InvalidRole")
    })
    public void removeInstance(
        @WebParam(name = "roleId", targetNamespace = "")
        String roleId,
        @WebParam(name = "region", targetNamespace = "")
        String region,
        @WebParam(name = "instanceId", targetNamespace = "")
        String instanceId)
        throws CloudManagerFault_Exception, InvalidRole_Exception, InvalidUserPass_Exception
    ;

    /**
     * 
     * @param region
     * @param roleId
     * @return
     *     returns java.util.List<com.clustercontrol.ws.cloud.CloudInstance>
     * @throws InvalidRole_Exception
     * @throws CloudManagerFault_Exception
     * @throws InvalidUserPass_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "getInstancesByRegion", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.GetInstancesByRegion")
    @ResponseWrapper(localName = "getInstancesByRegionResponse", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.GetInstancesByRegionResponse")
    @Action(input = "http://cloud.ws.clustercontrol.com/CloudEndpoint/getInstancesByRegionRequest", output = "http://cloud.ws.clustercontrol.com/CloudEndpoint/getInstancesByRegionResponse", fault = {
        @FaultAction(className = CloudManagerFault_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/getInstancesByRegion/Fault/CloudManagerFault"),
        @FaultAction(className = InvalidUserPass_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/getInstancesByRegion/Fault/InvalidUserPass"),
        @FaultAction(className = InvalidRole_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/getInstancesByRegion/Fault/InvalidRole")
    })
    public List<CloudInstance> getInstancesByRegion(
        @WebParam(name = "roleId", targetNamespace = "")
        String roleId,
        @WebParam(name = "region", targetNamespace = "")
        String region)
        throws CloudManagerFault_Exception, InvalidRole_Exception, InvalidUserPass_Exception
    ;

    /**
     * 
     * @param region
     * @param request
     * @param roleId
     * @return
     *     returns com.clustercontrol.ws.cloud.InstanceStateChange
     * @throws InvalidRole_Exception
     * @throws CloudManagerFault_Exception
     * @throws InvalidUserPass_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "startInstance", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.StartInstance")
    @ResponseWrapper(localName = "startInstanceResponse", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.StartInstanceResponse")
    @Action(input = "http://cloud.ws.clustercontrol.com/CloudEndpoint/startInstanceRequest", output = "http://cloud.ws.clustercontrol.com/CloudEndpoint/startInstanceResponse", fault = {
        @FaultAction(className = CloudManagerFault_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/startInstance/Fault/CloudManagerFault"),
        @FaultAction(className = InvalidUserPass_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/startInstance/Fault/InvalidUserPass"),
        @FaultAction(className = InvalidRole_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/startInstance/Fault/InvalidRole")
    })
    public InstanceStateChange startInstance(
        @WebParam(name = "roleId", targetNamespace = "")
        String roleId,
        @WebParam(name = "region", targetNamespace = "")
        String region,
        @WebParam(name = "request", targetNamespace = "")
        StartInstanceRequest request)
        throws CloudManagerFault_Exception, InvalidRole_Exception, InvalidUserPass_Exception
    ;

    /**
     * 
     * @param userId
     * @throws InvalidRole_Exception
     * @throws CloudManagerFault_Exception
     * @throws InvalidUserPass_Exception
     */
    @WebMethod
    @RequestWrapper(localName = "removeCloudUser", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.RemoveCloudUser")
    @ResponseWrapper(localName = "removeCloudUserResponse", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.RemoveCloudUserResponse")
    @Action(input = "http://cloud.ws.clustercontrol.com/CloudEndpoint/removeCloudUserRequest", output = "http://cloud.ws.clustercontrol.com/CloudEndpoint/removeCloudUserResponse", fault = {
        @FaultAction(className = CloudManagerFault_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/removeCloudUser/Fault/CloudManagerFault"),
        @FaultAction(className = InvalidUserPass_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/removeCloudUser/Fault/InvalidUserPass"),
        @FaultAction(className = InvalidRole_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/removeCloudUser/Fault/InvalidRole")
    })
    public void removeCloudUser(
        @WebParam(name = "userId", targetNamespace = "")
        String userId)
        throws CloudManagerFault_Exception, InvalidRole_Exception, InvalidUserPass_Exception
    ;

    /**
     * 
     * @param request
     * @return
     *     returns com.clustercontrol.ws.cloud.CloudUser
     * @throws InvalidRole_Exception
     * @throws CloudManagerFault_Exception
     * @throws InvalidUserPass_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "modifyCloudUser", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.ModifyCloudUser")
    @ResponseWrapper(localName = "modifyCloudUserResponse", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.ModifyCloudUserResponse")
    @Action(input = "http://cloud.ws.clustercontrol.com/CloudEndpoint/modifyCloudUserRequest", output = "http://cloud.ws.clustercontrol.com/CloudEndpoint/modifyCloudUserResponse", fault = {
        @FaultAction(className = CloudManagerFault_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/modifyCloudUser/Fault/CloudManagerFault"),
        @FaultAction(className = InvalidUserPass_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/modifyCloudUser/Fault/InvalidUserPass"),
        @FaultAction(className = InvalidRole_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/modifyCloudUser/Fault/InvalidRole")
    })
    public CloudUser modifyCloudUser(
        @WebParam(name = "request", targetNamespace = "")
        ModifyCloudUserRequest request)
        throws CloudManagerFault_Exception, InvalidRole_Exception, InvalidUserPass_Exception
    ;

    /**
     * 
     * @return
     *     returns java.util.List<com.clustercontrol.ws.cloud.CloudType>
     * @throws InvalidRole_Exception
     * @throws CloudManagerFault_Exception
     * @throws InvalidUserPass_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "getAllSupportedCloudTypes", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.GetAllSupportedCloudTypes")
    @ResponseWrapper(localName = "getAllSupportedCloudTypesResponse", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.GetAllSupportedCloudTypesResponse")
    @Action(input = "http://cloud.ws.clustercontrol.com/CloudEndpoint/getAllSupportedCloudTypesRequest", output = "http://cloud.ws.clustercontrol.com/CloudEndpoint/getAllSupportedCloudTypesResponse", fault = {
        @FaultAction(className = CloudManagerFault_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/getAllSupportedCloudTypes/Fault/CloudManagerFault"),
        @FaultAction(className = InvalidUserPass_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/getAllSupportedCloudTypes/Fault/InvalidUserPass"),
        @FaultAction(className = InvalidRole_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/getAllSupportedCloudTypes/Fault/InvalidRole")
    })
    public List<CloudType> getAllSupportedCloudTypes()
        throws CloudManagerFault_Exception, InvalidRole_Exception, InvalidUserPass_Exception
    ;

    /**
     * 
     * @param cloudServiceId
     * @return
     *     returns java.util.List<com.clustercontrol.ws.cloud.CloudRegion>
     * @throws InvalidRole_Exception
     * @throws InvalidUserPass_Exception
     * @throws CloudManagerFault_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "getRegionsByService", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.GetRegionsByService")
    @ResponseWrapper(localName = "getRegionsByServiceResponse", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.GetRegionsByServiceResponse")
    @Action(input = "http://cloud.ws.clustercontrol.com/CloudEndpoint/getRegionsByServiceRequest", output = "http://cloud.ws.clustercontrol.com/CloudEndpoint/getRegionsByServiceResponse", fault = {
        @FaultAction(className = CloudManagerFault_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/getRegionsByService/Fault/CloudManagerFault"),
        @FaultAction(className = InvalidUserPass_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/getRegionsByService/Fault/InvalidUserPass"),
        @FaultAction(className = InvalidRole_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/getRegionsByService/Fault/InvalidRole")
    })
    public List<CloudRegion> getRegionsByService(
        @WebParam(name = "cloudServiceId", targetNamespace = "")
        String cloudServiceId)
        throws CloudManagerFault_Exception, InvalidRole_Exception, InvalidUserPass_Exception
    ;

    /**
     * 
     * @param region
     * @param filters
     * @param roleId
     * @return
     *     returns java.util.List<com.clustercontrol.ws.cloud.Image>
     * @throws InvalidRole_Exception
     * @throws InvalidUserPass_Exception
     * @throws CloudManagerFault_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "getImagesWithFilter", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.GetImagesWithFilter")
    @ResponseWrapper(localName = "getImagesWithFilterResponse", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.GetImagesWithFilterResponse")
    @Action(input = "http://cloud.ws.clustercontrol.com/CloudEndpoint/getImagesWithFilterRequest", output = "http://cloud.ws.clustercontrol.com/CloudEndpoint/getImagesWithFilterResponse", fault = {
        @FaultAction(className = CloudManagerFault_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/getImagesWithFilter/Fault/CloudManagerFault"),
        @FaultAction(className = InvalidUserPass_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/getImagesWithFilter/Fault/InvalidUserPass"),
        @FaultAction(className = InvalidRole_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/getImagesWithFilter/Fault/InvalidRole")
    })
    public List<Image> getImagesWithFilter(
        @WebParam(name = "roleId", targetNamespace = "")
        String roleId,
        @WebParam(name = "region", targetNamespace = "")
        String region,
        @WebParam(name = "filters", targetNamespace = "")
        List<Filter> filters)
        throws CloudManagerFault_Exception, InvalidRole_Exception, InvalidUserPass_Exception
    ;

    /**
     * 
     * @param serviceId
     * @return
     *     returns java.util.List<java.lang.String>
     * @throws InvalidRole_Exception
     * @throws InvalidUserPass_Exception
     * @throws CloudManagerFault_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "getInstanceFlavorsByService", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.GetInstanceFlavorsByService")
    @ResponseWrapper(localName = "getInstanceFlavorsByServiceResponse", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.GetInstanceFlavorsByServiceResponse")
    @Action(input = "http://cloud.ws.clustercontrol.com/CloudEndpoint/getInstanceFlavorsByServiceRequest", output = "http://cloud.ws.clustercontrol.com/CloudEndpoint/getInstanceFlavorsByServiceResponse", fault = {
        @FaultAction(className = CloudManagerFault_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/getInstanceFlavorsByService/Fault/CloudManagerFault"),
        @FaultAction(className = InvalidUserPass_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/getInstanceFlavorsByService/Fault/InvalidUserPass"),
        @FaultAction(className = InvalidRole_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/getInstanceFlavorsByService/Fault/InvalidRole")
    })
    public List<String> getInstanceFlavorsByService(
        @WebParam(name = "serviceId", targetNamespace = "")
        String serviceId)
        throws CloudManagerFault_Exception, InvalidRole_Exception, InvalidUserPass_Exception
    ;

    /**
     * 
     * @param region
     * @param filter
     * @param roleId
     * @return
     *     returns java.util.List<com.clustercontrol.ws.cloud.Snapshot>
     * @throws InvalidRole_Exception
     * @throws CloudManagerFault_Exception
     * @throws InvalidUserPass_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "getSnapshotsWithFilter", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.GetSnapshotsWithFilter")
    @ResponseWrapper(localName = "getSnapshotsWithFilterResponse", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.GetSnapshotsWithFilterResponse")
    @Action(input = "http://cloud.ws.clustercontrol.com/CloudEndpoint/getSnapshotsWithFilterRequest", output = "http://cloud.ws.clustercontrol.com/CloudEndpoint/getSnapshotsWithFilterResponse", fault = {
        @FaultAction(className = CloudManagerFault_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/getSnapshotsWithFilter/Fault/CloudManagerFault"),
        @FaultAction(className = InvalidUserPass_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/getSnapshotsWithFilter/Fault/InvalidUserPass"),
        @FaultAction(className = InvalidRole_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/getSnapshotsWithFilter/Fault/InvalidRole")
    })
    public List<Snapshot> getSnapshotsWithFilter(
        @WebParam(name = "roleId", targetNamespace = "")
        String roleId,
        @WebParam(name = "region", targetNamespace = "")
        String region,
        @WebParam(name = "filter", targetNamespace = "")
        List<Filter> filter)
        throws CloudManagerFault_Exception, InvalidRole_Exception, InvalidUserPass_Exception
    ;

    /**
     * 
     * @param region
     * @param device
     * @param instanceId
     * @param storageId
     * @param roleId
     * @throws InvalidRole_Exception
     * @throws CloudManagerFault_Exception
     * @throws InvalidUserPass_Exception
     */
    @WebMethod
    @RequestWrapper(localName = "attachStorage", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.AttachStorage")
    @ResponseWrapper(localName = "attachStorageResponse", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.AttachStorageResponse")
    @Action(input = "http://cloud.ws.clustercontrol.com/CloudEndpoint/attachStorageRequest", output = "http://cloud.ws.clustercontrol.com/CloudEndpoint/attachStorageResponse", fault = {
        @FaultAction(className = CloudManagerFault_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/attachStorage/Fault/CloudManagerFault"),
        @FaultAction(className = InvalidUserPass_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/attachStorage/Fault/InvalidUserPass"),
        @FaultAction(className = InvalidRole_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/attachStorage/Fault/InvalidRole")
    })
    public void attachStorage(
        @WebParam(name = "roleId", targetNamespace = "")
        String roleId,
        @WebParam(name = "region", targetNamespace = "")
        String region,
        @WebParam(name = "instanceId", targetNamespace = "")
        String instanceId,
        @WebParam(name = "storageId", targetNamespace = "")
        String storageId,
        @WebParam(name = "device", targetNamespace = "")
        String device)
        throws CloudManagerFault_Exception, InvalidRole_Exception, InvalidUserPass_Exception
    ;

    /**
     * 
     * @param region
     * @param instanceId
     * @param storageId
     * @param roleId
     * @throws InvalidRole_Exception
     * @throws CloudManagerFault_Exception
     * @throws InvalidUserPass_Exception
     */
    @WebMethod
    @RequestWrapper(localName = "detachStorage", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.DetachStorage")
    @ResponseWrapper(localName = "detachStorageResponse", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.DetachStorageResponse")
    @Action(input = "http://cloud.ws.clustercontrol.com/CloudEndpoint/detachStorageRequest", output = "http://cloud.ws.clustercontrol.com/CloudEndpoint/detachStorageResponse", fault = {
        @FaultAction(className = CloudManagerFault_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/detachStorage/Fault/CloudManagerFault"),
        @FaultAction(className = InvalidUserPass_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/detachStorage/Fault/InvalidUserPass"),
        @FaultAction(className = InvalidRole_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/detachStorage/Fault/InvalidRole")
    })
    public void detachStorage(
        @WebParam(name = "roleId", targetNamespace = "")
        String roleId,
        @WebParam(name = "region", targetNamespace = "")
        String region,
        @WebParam(name = "instanceId", targetNamespace = "")
        String instanceId,
        @WebParam(name = "storageId", targetNamespace = "")
        String storageId)
        throws CloudManagerFault_Exception, InvalidRole_Exception, InvalidUserPass_Exception
    ;

    /**
     * 
     * @param region
     * @param request
     * @param roleId
     * @return
     *     returns com.clustercontrol.ws.cloud.CloudStorage
     * @throws InvalidRole_Exception
     * @throws CloudManagerFault_Exception
     * @throws InvalidUserPass_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "restoreStorage", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.RestoreStorage")
    @ResponseWrapper(localName = "restoreStorageResponse", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.RestoreStorageResponse")
    @Action(input = "http://cloud.ws.clustercontrol.com/CloudEndpoint/restoreStorageRequest", output = "http://cloud.ws.clustercontrol.com/CloudEndpoint/restoreStorageResponse", fault = {
        @FaultAction(className = CloudManagerFault_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/restoreStorage/Fault/CloudManagerFault"),
        @FaultAction(className = InvalidUserPass_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/restoreStorage/Fault/InvalidUserPass"),
        @FaultAction(className = InvalidRole_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/restoreStorage/Fault/InvalidRole")
    })
    public CloudStorage restoreStorage(
        @WebParam(name = "roleId", targetNamespace = "")
        String roleId,
        @WebParam(name = "region", targetNamespace = "")
        String region,
        @WebParam(name = "request", targetNamespace = "")
        RestoreStorageRequest request)
        throws CloudManagerFault_Exception, InvalidRole_Exception, InvalidUserPass_Exception
    ;

    /**
     * 
     * @param region
     * @param storageId
     * @param roleId
     * @throws InvalidRole_Exception
     * @throws InvalidUserPass_Exception
     * @throws CloudManagerFault_Exception
     */
    @WebMethod
    @RequestWrapper(localName = "removeStorage", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.RemoveStorage")
    @ResponseWrapper(localName = "removeStorageResponse", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.RemoveStorageResponse")
    @Action(input = "http://cloud.ws.clustercontrol.com/CloudEndpoint/removeStorageRequest", output = "http://cloud.ws.clustercontrol.com/CloudEndpoint/removeStorageResponse", fault = {
        @FaultAction(className = CloudManagerFault_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/removeStorage/Fault/CloudManagerFault"),
        @FaultAction(className = InvalidUserPass_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/removeStorage/Fault/InvalidUserPass"),
        @FaultAction(className = InvalidRole_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/removeStorage/Fault/InvalidRole")
    })
    public void removeStorage(
        @WebParam(name = "roleId", targetNamespace = "")
        String roleId,
        @WebParam(name = "region", targetNamespace = "")
        String region,
        @WebParam(name = "storageId", targetNamespace = "")
        String storageId)
        throws CloudManagerFault_Exception, InvalidRole_Exception, InvalidUserPass_Exception
    ;

    /**
     * 
     * @param region
     * @param roleId
     * @return
     *     returns java.util.List<com.clustercontrol.ws.cloud.CloudStorage>
     * @throws InvalidRole_Exception
     * @throws CloudManagerFault_Exception
     * @throws InvalidUserPass_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "getStoragesByRegion", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.GetStoragesByRegion")
    @ResponseWrapper(localName = "getStoragesByRegionResponse", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.GetStoragesByRegionResponse")
    @Action(input = "http://cloud.ws.clustercontrol.com/CloudEndpoint/getStoragesByRegionRequest", output = "http://cloud.ws.clustercontrol.com/CloudEndpoint/getStoragesByRegionResponse", fault = {
        @FaultAction(className = CloudManagerFault_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/getStoragesByRegion/Fault/CloudManagerFault"),
        @FaultAction(className = InvalidUserPass_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/getStoragesByRegion/Fault/InvalidUserPass"),
        @FaultAction(className = InvalidRole_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/getStoragesByRegion/Fault/InvalidRole")
    })
    public List<CloudStorage> getStoragesByRegion(
        @WebParam(name = "roleId", targetNamespace = "")
        String roleId,
        @WebParam(name = "region", targetNamespace = "")
        String region)
        throws CloudManagerFault_Exception, InvalidRole_Exception, InvalidUserPass_Exception
    ;

    /**
     * 
     * @param region
     * @param request
     * @param roleId
     * @return
     *     returns com.clustercontrol.ws.cloud.CloudStorageBackup
     * @throws InvalidRole_Exception
     * @throws CloudManagerFault_Exception
     * @throws InvalidUserPass_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "addStorageBackup", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.AddStorageBackup")
    @ResponseWrapper(localName = "addStorageBackupResponse", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.AddStorageBackupResponse")
    @Action(input = "http://cloud.ws.clustercontrol.com/CloudEndpoint/addStorageBackupRequest", output = "http://cloud.ws.clustercontrol.com/CloudEndpoint/addStorageBackupResponse", fault = {
        @FaultAction(className = CloudManagerFault_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/addStorageBackup/Fault/CloudManagerFault"),
        @FaultAction(className = InvalidUserPass_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/addStorageBackup/Fault/InvalidUserPass"),
        @FaultAction(className = InvalidRole_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/addStorageBackup/Fault/InvalidRole")
    })
    public CloudStorageBackup addStorageBackup(
        @WebParam(name = "roleId", targetNamespace = "")
        String roleId,
        @WebParam(name = "region", targetNamespace = "")
        String region,
        @WebParam(name = "request", targetNamespace = "")
        CreateStorageBackupRequest request)
        throws CloudManagerFault_Exception, InvalidRole_Exception, InvalidUserPass_Exception
    ;

    /**
     * 
     * @param region
     * @param storageBackupId
     * @param roleId
     * @throws InvalidRole_Exception
     * @throws CloudManagerFault_Exception
     * @throws InvalidUserPass_Exception
     */
    @WebMethod
    @RequestWrapper(localName = "removeStorageBackup", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.RemoveStorageBackup")
    @ResponseWrapper(localName = "removeStorageBackupResponse", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.RemoveStorageBackupResponse")
    @Action(input = "http://cloud.ws.clustercontrol.com/CloudEndpoint/removeStorageBackupRequest", output = "http://cloud.ws.clustercontrol.com/CloudEndpoint/removeStorageBackupResponse", fault = {
        @FaultAction(className = CloudManagerFault_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/removeStorageBackup/Fault/CloudManagerFault"),
        @FaultAction(className = InvalidUserPass_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/removeStorageBackup/Fault/InvalidUserPass"),
        @FaultAction(className = InvalidRole_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/removeStorageBackup/Fault/InvalidRole")
    })
    public void removeStorageBackup(
        @WebParam(name = "roleId", targetNamespace = "")
        String roleId,
        @WebParam(name = "region", targetNamespace = "")
        String region,
        @WebParam(name = "storageBackupId", targetNamespace = "")
        String storageBackupId)
        throws CloudManagerFault_Exception, InvalidRole_Exception, InvalidUserPass_Exception
    ;

    /**
     * 
     * @param region
     * @param storageBackupId
     * @param roleId
     * @return
     *     returns com.clustercontrol.ws.cloud.CloudStorageBackup
     * @throws InvalidRole_Exception
     * @throws InvalidUserPass_Exception
     * @throws CloudManagerFault_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "getStorageBackup", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.GetStorageBackup")
    @ResponseWrapper(localName = "getStorageBackupResponse", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.GetStorageBackupResponse")
    @Action(input = "http://cloud.ws.clustercontrol.com/CloudEndpoint/getStorageBackupRequest", output = "http://cloud.ws.clustercontrol.com/CloudEndpoint/getStorageBackupResponse", fault = {
        @FaultAction(className = CloudManagerFault_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/getStorageBackup/Fault/CloudManagerFault"),
        @FaultAction(className = InvalidUserPass_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/getStorageBackup/Fault/InvalidUserPass"),
        @FaultAction(className = InvalidRole_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/getStorageBackup/Fault/InvalidRole")
    })
    public CloudStorageBackup getStorageBackup(
        @WebParam(name = "roleId", targetNamespace = "")
        String roleId,
        @WebParam(name = "region", targetNamespace = "")
        String region,
        @WebParam(name = "storageBackupId", targetNamespace = "")
        String storageBackupId)
        throws CloudManagerFault_Exception, InvalidRole_Exception, InvalidUserPass_Exception
    ;

    /**
     * 
     * @param region
     * @param roleId
     * @return
     *     returns java.util.List<com.clustercontrol.ws.cloud.CloudStorageBackup>
     * @throws InvalidRole_Exception
     * @throws InvalidUserPass_Exception
     * @throws CloudManagerFault_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "getStorageBackupsByRegion", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.GetStorageBackupsByRegion")
    @ResponseWrapper(localName = "getStorageBackupsByRegionResponse", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.GetStorageBackupsByRegionResponse")
    @Action(input = "http://cloud.ws.clustercontrol.com/CloudEndpoint/getStorageBackupsByRegionRequest", output = "http://cloud.ws.clustercontrol.com/CloudEndpoint/getStorageBackupsByRegionResponse", fault = {
        @FaultAction(className = CloudManagerFault_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/getStorageBackupsByRegion/Fault/CloudManagerFault"),
        @FaultAction(className = InvalidUserPass_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/getStorageBackupsByRegion/Fault/InvalidUserPass"),
        @FaultAction(className = InvalidRole_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/getStorageBackupsByRegion/Fault/InvalidRole")
    })
    public List<CloudStorageBackup> getStorageBackupsByRegion(
        @WebParam(name = "roleId", targetNamespace = "")
        String roleId,
        @WebParam(name = "region", targetNamespace = "")
        String region)
        throws CloudManagerFault_Exception, InvalidRole_Exception, InvalidUserPass_Exception
    ;

    /**
     * 
     * @param region
     * @param request
     * @param roleId
     * @return
     *     returns com.clustercontrol.ws.cloud.CloudInstanceBackup
     * @throws InvalidRole_Exception
     * @throws InvalidUserPass_Exception
     * @throws CloudManagerFault_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "addInstanceBackup", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.AddInstanceBackup")
    @ResponseWrapper(localName = "addInstanceBackupResponse", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.AddInstanceBackupResponse")
    @Action(input = "http://cloud.ws.clustercontrol.com/CloudEndpoint/addInstanceBackupRequest", output = "http://cloud.ws.clustercontrol.com/CloudEndpoint/addInstanceBackupResponse", fault = {
        @FaultAction(className = CloudManagerFault_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/addInstanceBackup/Fault/CloudManagerFault"),
        @FaultAction(className = InvalidUserPass_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/addInstanceBackup/Fault/InvalidUserPass"),
        @FaultAction(className = InvalidRole_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/addInstanceBackup/Fault/InvalidRole")
    })
    public CloudInstanceBackup addInstanceBackup(
        @WebParam(name = "roleId", targetNamespace = "")
        String roleId,
        @WebParam(name = "region", targetNamespace = "")
        String region,
        @WebParam(name = "request", targetNamespace = "")
        CreateInstanceBackupRequest request)
        throws CloudManagerFault_Exception, InvalidRole_Exception, InvalidUserPass_Exception
    ;

    /**
     * 
     * @param region
     * @param instanceBackupId
     * @param roleId
     * @throws InvalidRole_Exception
     * @throws InvalidUserPass_Exception
     * @throws CloudManagerFault_Exception
     */
    @WebMethod
    @RequestWrapper(localName = "removeInstanceBackup", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.RemoveInstanceBackup")
    @ResponseWrapper(localName = "removeInstanceBackupResponse", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.RemoveInstanceBackupResponse")
    @Action(input = "http://cloud.ws.clustercontrol.com/CloudEndpoint/removeInstanceBackupRequest", output = "http://cloud.ws.clustercontrol.com/CloudEndpoint/removeInstanceBackupResponse", fault = {
        @FaultAction(className = CloudManagerFault_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/removeInstanceBackup/Fault/CloudManagerFault"),
        @FaultAction(className = InvalidUserPass_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/removeInstanceBackup/Fault/InvalidUserPass"),
        @FaultAction(className = InvalidRole_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/removeInstanceBackup/Fault/InvalidRole")
    })
    public void removeInstanceBackup(
        @WebParam(name = "roleId", targetNamespace = "")
        String roleId,
        @WebParam(name = "region", targetNamespace = "")
        String region,
        @WebParam(name = "instanceBackupId", targetNamespace = "")
        String instanceBackupId)
        throws CloudManagerFault_Exception, InvalidRole_Exception, InvalidUserPass_Exception
    ;

    /**
     * 
     * @param region
     * @param instanceBackupId
     * @param roleId
     * @return
     *     returns com.clustercontrol.ws.cloud.CloudInstanceBackup
     * @throws InvalidRole_Exception
     * @throws InvalidUserPass_Exception
     * @throws CloudManagerFault_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "getInstanceBackup", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.GetInstanceBackup")
    @ResponseWrapper(localName = "getInstanceBackupResponse", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.GetInstanceBackupResponse")
    @Action(input = "http://cloud.ws.clustercontrol.com/CloudEndpoint/getInstanceBackupRequest", output = "http://cloud.ws.clustercontrol.com/CloudEndpoint/getInstanceBackupResponse", fault = {
        @FaultAction(className = CloudManagerFault_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/getInstanceBackup/Fault/CloudManagerFault"),
        @FaultAction(className = InvalidUserPass_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/getInstanceBackup/Fault/InvalidUserPass"),
        @FaultAction(className = InvalidRole_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/getInstanceBackup/Fault/InvalidRole")
    })
    public CloudInstanceBackup getInstanceBackup(
        @WebParam(name = "roleId", targetNamespace = "")
        String roleId,
        @WebParam(name = "region", targetNamespace = "")
        String region,
        @WebParam(name = "instanceBackupId", targetNamespace = "")
        String instanceBackupId)
        throws CloudManagerFault_Exception, InvalidRole_Exception, InvalidUserPass_Exception
    ;

    /**
     * 
     * @param region
     * @param roleId
     * @return
     *     returns java.util.List<com.clustercontrol.ws.cloud.CloudInstanceBackup>
     * @throws InvalidRole_Exception
     * @throws CloudManagerFault_Exception
     * @throws InvalidUserPass_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "getInstanceBackupsByRegion", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.GetInstanceBackupsByRegion")
    @ResponseWrapper(localName = "getInstanceBackupsByRegionResponse", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.GetInstanceBackupsByRegionResponse")
    @Action(input = "http://cloud.ws.clustercontrol.com/CloudEndpoint/getInstanceBackupsByRegionRequest", output = "http://cloud.ws.clustercontrol.com/CloudEndpoint/getInstanceBackupsByRegionResponse", fault = {
        @FaultAction(className = CloudManagerFault_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/getInstanceBackupsByRegion/Fault/CloudManagerFault"),
        @FaultAction(className = InvalidUserPass_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/getInstanceBackupsByRegion/Fault/InvalidUserPass"),
        @FaultAction(className = InvalidRole_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/getInstanceBackupsByRegion/Fault/InvalidRole")
    })
    public List<CloudInstanceBackup> getInstanceBackupsByRegion(
        @WebParam(name = "roleId", targetNamespace = "")
        String roleId,
        @WebParam(name = "region", targetNamespace = "")
        String region)
        throws CloudManagerFault_Exception, InvalidRole_Exception, InvalidUserPass_Exception
    ;

    /**
     * 
     * @param templateId
     * @param roleId
     * @throws InvalidRole_Exception
     * @throws CloudManagerFault_Exception
     * @throws InvalidUserPass_Exception
     */
    @WebMethod
    @RequestWrapper(localName = "removeTemplate", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.RemoveTemplate")
    @ResponseWrapper(localName = "removeTemplateResponse", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.RemoveTemplateResponse")
    @Action(input = "http://cloud.ws.clustercontrol.com/CloudEndpoint/removeTemplateRequest", output = "http://cloud.ws.clustercontrol.com/CloudEndpoint/removeTemplateResponse", fault = {
        @FaultAction(className = CloudManagerFault_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/removeTemplate/Fault/CloudManagerFault"),
        @FaultAction(className = InvalidUserPass_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/removeTemplate/Fault/InvalidUserPass"),
        @FaultAction(className = InvalidRole_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/removeTemplate/Fault/InvalidRole")
    })
    public void removeTemplate(
        @WebParam(name = "roleId", targetNamespace = "")
        String roleId,
        @WebParam(name = "templateId", targetNamespace = "")
        String templateId)
        throws CloudManagerFault_Exception, InvalidRole_Exception, InvalidUserPass_Exception
    ;

    /**
     * 
     * @param accountResourceId
     * @return
     *     returns java.util.List<com.clustercontrol.ws.cloud.CloudUser>
     * @throws InvalidRole_Exception
     * @throws InvalidUserPass_Exception
     * @throws CloudManagerFault_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "getCloudUsersByAccountResource", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.GetCloudUsersByAccountResource")
    @ResponseWrapper(localName = "getCloudUsersByAccountResourceResponse", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.GetCloudUsersByAccountResourceResponse")
    @Action(input = "http://cloud.ws.clustercontrol.com/CloudEndpoint/getCloudUsersByAccountResourceRequest", output = "http://cloud.ws.clustercontrol.com/CloudEndpoint/getCloudUsersByAccountResourceResponse", fault = {
        @FaultAction(className = CloudManagerFault_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/getCloudUsersByAccountResource/Fault/CloudManagerFault"),
        @FaultAction(className = InvalidUserPass_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/getCloudUsersByAccountResource/Fault/InvalidUserPass"),
        @FaultAction(className = InvalidRole_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/getCloudUsersByAccountResource/Fault/InvalidRole")
    })
    public List<CloudUser> getCloudUsersByAccountResource(
        @WebParam(name = "accountResourceId", targetNamespace = "")
        String accountResourceId)
        throws CloudManagerFault_Exception, InvalidRole_Exception, InvalidUserPass_Exception
    ;

    /**
     * 
     * @param region
     * @param request
     * @param roleId
     * @return
     *     returns com.clustercontrol.ws.cloud.CloudInstance
     * @throws InvalidRole_Exception
     * @throws CloudManagerFault_Exception
     * @throws InvalidUserPass_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "addInstanceByTemplate", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.AddInstanceByTemplate")
    @ResponseWrapper(localName = "addInstanceByTemplateResponse", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.AddInstanceByTemplateResponse")
    @Action(input = "http://cloud.ws.clustercontrol.com/CloudEndpoint/addInstanceByTemplateRequest", output = "http://cloud.ws.clustercontrol.com/CloudEndpoint/addInstanceByTemplateResponse", fault = {
        @FaultAction(className = CloudManagerFault_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/addInstanceByTemplate/Fault/CloudManagerFault"),
        @FaultAction(className = InvalidUserPass_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/addInstanceByTemplate/Fault/InvalidUserPass"),
        @FaultAction(className = InvalidRole_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/addInstanceByTemplate/Fault/InvalidRole")
    })
    public CloudInstance addInstanceByTemplate(
        @WebParam(name = "roleId", targetNamespace = "")
        String roleId,
        @WebParam(name = "region", targetNamespace = "")
        String region,
        @WebParam(name = "request", targetNamespace = "")
        CreateInstanceByTemplateRequest request)
        throws CloudManagerFault_Exception, InvalidRole_Exception, InvalidUserPass_Exception
    ;

    /**
     * 
     * @param region
     * @param request
     * @param roleId
     * @return
     *     returns com.clustercontrol.ws.cloud.CloudInstance
     * @throws InvalidRole_Exception
     * @throws CloudManagerFault_Exception
     * @throws InvalidUserPass_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "addInstance", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.AddInstance")
    @ResponseWrapper(localName = "addInstanceResponse", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.AddInstanceResponse")
    @Action(input = "http://cloud.ws.clustercontrol.com/CloudEndpoint/addInstanceRequest", output = "http://cloud.ws.clustercontrol.com/CloudEndpoint/addInstanceResponse", fault = {
        @FaultAction(className = CloudManagerFault_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/addInstance/Fault/CloudManagerFault"),
        @FaultAction(className = InvalidUserPass_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/addInstance/Fault/InvalidUserPass"),
        @FaultAction(className = InvalidRole_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/addInstance/Fault/InvalidRole")
    })
    public CloudInstance addInstance(
        @WebParam(name = "roleId", targetNamespace = "")
        String roleId,
        @WebParam(name = "region", targetNamespace = "")
        String region,
        @WebParam(name = "request", targetNamespace = "")
        CreateInstanceRequest request)
        throws CloudManagerFault_Exception, InvalidRole_Exception, InvalidUserPass_Exception
    ;

    /**
     * 
     * @param region
     * @param request
     * @param roleId
     * @return
     *     returns com.clustercontrol.ws.cloud.InstanceStateChange
     * @throws InvalidRole_Exception
     * @throws CloudManagerFault_Exception
     * @throws InvalidUserPass_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "stopInstance", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.StopInstance")
    @ResponseWrapper(localName = "stopInstanceResponse", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.StopInstanceResponse")
    @Action(input = "http://cloud.ws.clustercontrol.com/CloudEndpoint/stopInstanceRequest", output = "http://cloud.ws.clustercontrol.com/CloudEndpoint/stopInstanceResponse", fault = {
        @FaultAction(className = CloudManagerFault_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/stopInstance/Fault/CloudManagerFault"),
        @FaultAction(className = InvalidUserPass_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/stopInstance/Fault/InvalidUserPass"),
        @FaultAction(className = InvalidRole_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/stopInstance/Fault/InvalidRole")
    })
    public InstanceStateChange stopInstance(
        @WebParam(name = "roleId", targetNamespace = "")
        String roleId,
        @WebParam(name = "region", targetNamespace = "")
        String region,
        @WebParam(name = "request", targetNamespace = "")
        StopInstanceRequest request)
        throws CloudManagerFault_Exception, InvalidRole_Exception, InvalidUserPass_Exception
    ;

    /**
     * 
     * @param request
     * @return
     *     returns com.clustercontrol.ws.cloud.CloudUser
     * @throws InvalidRole_Exception
     * @throws InvalidUserPass_Exception
     * @throws CloudManagerFault_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "addCloudUser", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.AddCloudUser")
    @ResponseWrapper(localName = "addCloudUserResponse", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.AddCloudUserResponse")
    @Action(input = "http://cloud.ws.clustercontrol.com/CloudEndpoint/addCloudUserRequest", output = "http://cloud.ws.clustercontrol.com/CloudEndpoint/addCloudUserResponse", fault = {
        @FaultAction(className = CloudManagerFault_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/addCloudUser/Fault/CloudManagerFault"),
        @FaultAction(className = InvalidUserPass_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/addCloudUser/Fault/InvalidUserPass"),
        @FaultAction(className = InvalidRole_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/addCloudUser/Fault/InvalidRole")
    })
    public CloudUser addCloudUser(
        @WebParam(name = "request", targetNamespace = "")
        CreateCloudUserRequest request)
        throws CloudManagerFault_Exception, InvalidRole_Exception, InvalidUserPass_Exception
    ;

    /**
     * 
     * @param userId
     * @return
     *     returns com.clustercontrol.ws.cloud.CloudUser
     * @throws InvalidRole_Exception
     * @throws InvalidUserPass_Exception
     * @throws CloudManagerFault_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "getCloudUser", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.GetCloudUser")
    @ResponseWrapper(localName = "getCloudUserResponse", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.GetCloudUserResponse")
    @Action(input = "http://cloud.ws.clustercontrol.com/CloudEndpoint/getCloudUserRequest", output = "http://cloud.ws.clustercontrol.com/CloudEndpoint/getCloudUserResponse", fault = {
        @FaultAction(className = CloudManagerFault_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/getCloudUser/Fault/CloudManagerFault"),
        @FaultAction(className = InvalidUserPass_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/getCloudUser/Fault/InvalidUserPass"),
        @FaultAction(className = InvalidRole_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/getCloudUser/Fault/InvalidRole")
    })
    public CloudUser getCloudUser(
        @WebParam(name = "userId", targetNamespace = "")
        String userId)
        throws CloudManagerFault_Exception, InvalidRole_Exception, InvalidUserPass_Exception
    ;

    /**
     * 
     * @param region
     * @param roleId
     * @return
     *     returns java.util.List<com.clustercontrol.ws.cloud.Zone>
     * @throws InvalidRole_Exception
     * @throws CloudManagerFault_Exception
     * @throws InvalidUserPass_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "getZones", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.GetZones")
    @ResponseWrapper(localName = "getZonesResponse", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.GetZonesResponse")
    @Action(input = "http://cloud.ws.clustercontrol.com/CloudEndpoint/getZonesRequest", output = "http://cloud.ws.clustercontrol.com/CloudEndpoint/getZonesResponse", fault = {
        @FaultAction(className = CloudManagerFault_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/getZones/Fault/CloudManagerFault"),
        @FaultAction(className = InvalidUserPass_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/getZones/Fault/InvalidUserPass"),
        @FaultAction(className = InvalidRole_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/getZones/Fault/InvalidRole")
    })
    public List<Zone> getZones(
        @WebParam(name = "roleId", targetNamespace = "")
        String roleId,
        @WebParam(name = "region", targetNamespace = "")
        String region)
        throws CloudManagerFault_Exception, InvalidRole_Exception, InvalidUserPass_Exception
    ;

    /**
     * 
     * @param region
     * @param request
     * @param roleId
     * @return
     *     returns com.clustercontrol.ws.cloud.CloudStorage
     * @throws InvalidRole_Exception
     * @throws CloudManagerFault_Exception
     * @throws InvalidUserPass_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "addStorage", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.AddStorage")
    @ResponseWrapper(localName = "addStorageResponse", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.AddStorageResponse")
    @Action(input = "http://cloud.ws.clustercontrol.com/CloudEndpoint/addStorageRequest", output = "http://cloud.ws.clustercontrol.com/CloudEndpoint/addStorageResponse", fault = {
        @FaultAction(className = CloudManagerFault_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/addStorage/Fault/CloudManagerFault"),
        @FaultAction(className = InvalidUserPass_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/addStorage/Fault/InvalidUserPass"),
        @FaultAction(className = InvalidRole_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/addStorage/Fault/InvalidRole")
    })
    public CloudStorage addStorage(
        @WebParam(name = "roleId", targetNamespace = "")
        String roleId,
        @WebParam(name = "region", targetNamespace = "")
        String region,
        @WebParam(name = "request", targetNamespace = "")
        CreateStorageRequest request)
        throws CloudManagerFault_Exception, InvalidRole_Exception, InvalidUserPass_Exception
    ;

    /**
     * 
     * @param region
     * @param storageId
     * @param roleId
     * @return
     *     returns com.clustercontrol.ws.cloud.CloudStorage
     * @throws InvalidRole_Exception
     * @throws InvalidUserPass_Exception
     * @throws CloudManagerFault_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "getStorage", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.GetStorage")
    @ResponseWrapper(localName = "getStorageResponse", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.GetStorageResponse")
    @Action(input = "http://cloud.ws.clustercontrol.com/CloudEndpoint/getStorageRequest", output = "http://cloud.ws.clustercontrol.com/CloudEndpoint/getStorageResponse", fault = {
        @FaultAction(className = CloudManagerFault_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/getStorage/Fault/CloudManagerFault"),
        @FaultAction(className = InvalidUserPass_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/getStorage/Fault/InvalidUserPass"),
        @FaultAction(className = InvalidRole_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/getStorage/Fault/InvalidRole")
    })
    public CloudStorage getStorage(
        @WebParam(name = "roleId", targetNamespace = "")
        String roleId,
        @WebParam(name = "region", targetNamespace = "")
        String region,
        @WebParam(name = "storageId", targetNamespace = "")
        String storageId)
        throws CloudManagerFault_Exception, InvalidRole_Exception, InvalidUserPass_Exception
    ;

    /**
     * 
     * @param region
     * @param request
     * @param roleId
     * @return
     *     returns com.clustercontrol.ws.cloud.CloudInstance
     * @throws InvalidRole_Exception
     * @throws InvalidUserPass_Exception
     * @throws CloudManagerFault_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "registNode", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.RegistNode")
    @ResponseWrapper(localName = "registNodeResponse", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.RegistNodeResponse")
    @Action(input = "http://cloud.ws.clustercontrol.com/CloudEndpoint/registNodeRequest", output = "http://cloud.ws.clustercontrol.com/CloudEndpoint/registNodeResponse", fault = {
        @FaultAction(className = InvalidUserPass_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/registNode/Fault/InvalidUserPass"),
        @FaultAction(className = InvalidRole_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/registNode/Fault/InvalidRole"),
        @FaultAction(className = CloudManagerFault_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/registNode/Fault/CloudManagerFault")
    })
    public CloudInstance registNode(
        @WebParam(name = "roleId", targetNamespace = "")
        String roleId,
        @WebParam(name = "region", targetNamespace = "")
        String region,
        @WebParam(name = "request", targetNamespace = "")
        RegistNodeRequest request)
        throws CloudManagerFault_Exception, InvalidRole_Exception, InvalidUserPass_Exception
    ;

    /**
     * 
     * @param region
     * @param instanceId
     * @param roleId
     * @throws InvalidRole_Exception
     * @throws CloudManagerFault_Exception
     * @throws InvalidUserPass_Exception
     */
    @WebMethod
    @RequestWrapper(localName = "unregistNode", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.UnregistNode")
    @ResponseWrapper(localName = "unregistNodeResponse", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.UnregistNodeResponse")
    @Action(input = "http://cloud.ws.clustercontrol.com/CloudEndpoint/unregistNodeRequest", output = "http://cloud.ws.clustercontrol.com/CloudEndpoint/unregistNodeResponse", fault = {
        @FaultAction(className = InvalidUserPass_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/unregistNode/Fault/InvalidUserPass"),
        @FaultAction(className = InvalidRole_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/unregistNode/Fault/InvalidRole"),
        @FaultAction(className = CloudManagerFault_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/unregistNode/Fault/CloudManagerFault")
    })
    public void unregistNode(
        @WebParam(name = "roleId", targetNamespace = "")
        String roleId,
        @WebParam(name = "region", targetNamespace = "")
        String region,
        @WebParam(name = "instanceId", targetNamespace = "")
        String instanceId)
        throws CloudManagerFault_Exception, InvalidRole_Exception, InvalidUserPass_Exception
    ;

    /**
     * 
     * @param request
     * @param roleId
     * @return
     *     returns com.clustercontrol.ws.cloud.CloudTemplate
     * @throws InvalidRole_Exception
     * @throws InvalidUserPass_Exception
     * @throws CloudManagerFault_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "addTemplate", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.AddTemplate")
    @ResponseWrapper(localName = "addTemplateResponse", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.AddTemplateResponse")
    @Action(input = "http://cloud.ws.clustercontrol.com/CloudEndpoint/addTemplateRequest", output = "http://cloud.ws.clustercontrol.com/CloudEndpoint/addTemplateResponse", fault = {
        @FaultAction(className = CloudManagerFault_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/addTemplate/Fault/CloudManagerFault"),
        @FaultAction(className = InvalidUserPass_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/addTemplate/Fault/InvalidUserPass"),
        @FaultAction(className = InvalidRole_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/addTemplate/Fault/InvalidRole")
    })
    public CloudTemplate addTemplate(
        @WebParam(name = "roleId", targetNamespace = "")
        String roleId,
        @WebParam(name = "request", targetNamespace = "")
        CreateTemplateRequest request)
        throws CloudManagerFault_Exception, InvalidRole_Exception, InvalidUserPass_Exception
    ;

    /**
     * 
     * @param templateId
     * @param roleId
     * @return
     *     returns com.clustercontrol.ws.cloud.CloudTemplate
     * @throws InvalidRole_Exception
     * @throws CloudManagerFault_Exception
     * @throws InvalidUserPass_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "getTemplate", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.GetTemplate")
    @ResponseWrapper(localName = "getTemplateResponse", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.GetTemplateResponse")
    @Action(input = "http://cloud.ws.clustercontrol.com/CloudEndpoint/getTemplateRequest", output = "http://cloud.ws.clustercontrol.com/CloudEndpoint/getTemplateResponse", fault = {
        @FaultAction(className = CloudManagerFault_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/getTemplate/Fault/CloudManagerFault"),
        @FaultAction(className = InvalidUserPass_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/getTemplate/Fault/InvalidUserPass"),
        @FaultAction(className = InvalidRole_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/getTemplate/Fault/InvalidRole")
    })
    public CloudTemplate getTemplate(
        @WebParam(name = "roleId", targetNamespace = "")
        String roleId,
        @WebParam(name = "templateId", targetNamespace = "")
        String templateId)
        throws CloudManagerFault_Exception, InvalidRole_Exception, InvalidUserPass_Exception
    ;

    /**
     * 
     * @param roleId
     * @return
     *     returns java.util.List<com.clustercontrol.ws.cloud.CloudTemplate>
     * @throws InvalidRole_Exception
     * @throws CloudManagerFault_Exception
     * @throws InvalidUserPass_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "getTemplates", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.GetTemplates")
    @ResponseWrapper(localName = "getTemplatesResponse", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.GetTemplatesResponse")
    @Action(input = "http://cloud.ws.clustercontrol.com/CloudEndpoint/getTemplatesRequest", output = "http://cloud.ws.clustercontrol.com/CloudEndpoint/getTemplatesResponse", fault = {
        @FaultAction(className = CloudManagerFault_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/getTemplates/Fault/CloudManagerFault"),
        @FaultAction(className = InvalidUserPass_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/getTemplates/Fault/InvalidUserPass"),
        @FaultAction(className = InvalidRole_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/getTemplates/Fault/InvalidRole")
    })
    public List<CloudTemplate> getTemplates(
        @WebParam(name = "roleId", targetNamespace = "")
        String roleId)
        throws CloudManagerFault_Exception, InvalidRole_Exception, InvalidUserPass_Exception
    ;

    /**
     * 
     * @param request
     * @param roleId
     * @return
     *     returns com.clustercontrol.ws.cloud.CloudTemplate
     * @throws InvalidRole_Exception
     * @throws CloudManagerFault_Exception
     * @throws InvalidUserPass_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "modifyTemplate", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.ModifyTemplate")
    @ResponseWrapper(localName = "modifyTemplateResponse", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.ModifyTemplateResponse")
    @Action(input = "http://cloud.ws.clustercontrol.com/CloudEndpoint/modifyTemplateRequest", output = "http://cloud.ws.clustercontrol.com/CloudEndpoint/modifyTemplateResponse", fault = {
        @FaultAction(className = CloudManagerFault_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/modifyTemplate/Fault/CloudManagerFault"),
        @FaultAction(className = InvalidUserPass_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/modifyTemplate/Fault/InvalidUserPass"),
        @FaultAction(className = InvalidRole_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/modifyTemplate/Fault/InvalidRole")
    })
    public CloudTemplate modifyTemplate(
        @WebParam(name = "roleId", targetNamespace = "")
        String roleId,
        @WebParam(name = "request", targetNamespace = "")
        ModifyTemplateRequest request)
        throws CloudManagerFault_Exception, InvalidRole_Exception, InvalidUserPass_Exception
    ;

    /**
     * 
     * @param roleId
     * @return
     *     returns java.util.List<java.lang.String>
     * @throws CloudManagerFault_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "getTemplateScripts", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.GetTemplateScripts")
    @ResponseWrapper(localName = "getTemplateScriptsResponse", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.GetTemplateScriptsResponse")
    @Action(input = "http://cloud.ws.clustercontrol.com/CloudEndpoint/getTemplateScriptsRequest", output = "http://cloud.ws.clustercontrol.com/CloudEndpoint/getTemplateScriptsResponse", fault = {
        @FaultAction(className = CloudManagerFault_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/getTemplateScripts/Fault/CloudManagerFault")
    })
    public List<String> getTemplateScripts(
        @WebParam(name = "roleId", targetNamespace = "")
        String roleId)
        throws CloudManagerFault_Exception
    ;

    /**
     * 
     * @param request
     * @return
     *     returns com.clustercontrol.ws.cloud.CloudAccountResource
     * @throws InvalidRole_Exception
     * @throws CloudManagerFault_Exception
     * @throws InvalidUserPass_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "addAccountResource", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.AddAccountResource")
    @ResponseWrapper(localName = "addAccountResourceResponse", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.AddAccountResourceResponse")
    @Action(input = "http://cloud.ws.clustercontrol.com/CloudEndpoint/addAccountResourceRequest", output = "http://cloud.ws.clustercontrol.com/CloudEndpoint/addAccountResourceResponse", fault = {
        @FaultAction(className = CloudManagerFault_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/addAccountResource/Fault/CloudManagerFault"),
        @FaultAction(className = InvalidUserPass_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/addAccountResource/Fault/InvalidUserPass"),
        @FaultAction(className = InvalidRole_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/addAccountResource/Fault/InvalidRole")
    })
    public CloudAccountResource addAccountResource(
        @WebParam(name = "request", targetNamespace = "")
        CreateAccountResourceRequest request)
        throws CloudManagerFault_Exception, InvalidRole_Exception, InvalidUserPass_Exception
    ;

    /**
     * 
     * @param request
     * @return
     *     returns com.clustercontrol.ws.cloud.CloudAccountResource
     * @throws InvalidRole_Exception
     * @throws CloudManagerFault_Exception
     * @throws InvalidUserPass_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "modifyAccountResource", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.ModifyAccountResource")
    @ResponseWrapper(localName = "modifyAccountResourceResponse", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.ModifyAccountResourceResponse")
    @Action(input = "http://cloud.ws.clustercontrol.com/CloudEndpoint/modifyAccountResourceRequest", output = "http://cloud.ws.clustercontrol.com/CloudEndpoint/modifyAccountResourceResponse", fault = {
        @FaultAction(className = CloudManagerFault_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/modifyAccountResource/Fault/CloudManagerFault"),
        @FaultAction(className = InvalidUserPass_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/modifyAccountResource/Fault/InvalidUserPass"),
        @FaultAction(className = InvalidRole_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/modifyAccountResource/Fault/InvalidRole")
    })
    public CloudAccountResource modifyAccountResource(
        @WebParam(name = "request", targetNamespace = "")
        ModifyAccountResourceRequest request)
        throws CloudManagerFault_Exception, InvalidRole_Exception, InvalidUserPass_Exception
    ;

    /**
     * 
     * @param request
     * @return
     *     returns com.clustercontrol.ws.cloud.CloudAccountResource
     * @throws InvalidRole_Exception
     * @throws InvalidUserPass_Exception
     * @throws CloudManagerFault_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "modifyAccountBillingDetail", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.ModifyAccountBillingDetail")
    @ResponseWrapper(localName = "modifyAccountBillingDetailResponse", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.ModifyAccountBillingDetailResponse")
    @Action(input = "http://cloud.ws.clustercontrol.com/CloudEndpoint/modifyAccountBillingDetailRequest", output = "http://cloud.ws.clustercontrol.com/CloudEndpoint/modifyAccountBillingDetailResponse", fault = {
        @FaultAction(className = CloudManagerFault_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/modifyAccountBillingDetail/Fault/CloudManagerFault"),
        @FaultAction(className = InvalidUserPass_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/modifyAccountBillingDetail/Fault/InvalidUserPass"),
        @FaultAction(className = InvalidRole_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/modifyAccountBillingDetail/Fault/InvalidRole")
    })
    public CloudAccountResource modifyAccountBillingDetail(
        @WebParam(name = "request", targetNamespace = "")
        ModifyAccountBillingDetailRequest request)
        throws CloudManagerFault_Exception, InvalidRole_Exception, InvalidUserPass_Exception
    ;

    /**
     * 
     * @param accountResourceId
     * @throws InvalidRole_Exception
     * @throws InvalidUserPass_Exception
     * @throws CloudManagerFault_Exception
     */
    @WebMethod
    @RequestWrapper(localName = "removeAccountResource", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.RemoveAccountResource")
    @ResponseWrapper(localName = "removeAccountResourceResponse", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.RemoveAccountResourceResponse")
    @Action(input = "http://cloud.ws.clustercontrol.com/CloudEndpoint/removeAccountResourceRequest", output = "http://cloud.ws.clustercontrol.com/CloudEndpoint/removeAccountResourceResponse", fault = {
        @FaultAction(className = CloudManagerFault_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/removeAccountResource/Fault/CloudManagerFault"),
        @FaultAction(className = InvalidUserPass_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/removeAccountResource/Fault/InvalidUserPass"),
        @FaultAction(className = InvalidRole_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/removeAccountResource/Fault/InvalidRole")
    })
    public void removeAccountResource(
        @WebParam(name = "accountResourceId", targetNamespace = "")
        String accountResourceId)
        throws CloudManagerFault_Exception, InvalidRole_Exception, InvalidUserPass_Exception
    ;

    /**
     * 
     * @param accountResourceId
     * @return
     *     returns com.clustercontrol.ws.cloud.CloudAccountResource
     * @throws InvalidRole_Exception
     * @throws InvalidUserPass_Exception
     * @throws CloudManagerFault_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "getAccountResource", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.GetAccountResource")
    @ResponseWrapper(localName = "getAccountResourceResponse", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.GetAccountResourceResponse")
    @Action(input = "http://cloud.ws.clustercontrol.com/CloudEndpoint/getAccountResourceRequest", output = "http://cloud.ws.clustercontrol.com/CloudEndpoint/getAccountResourceResponse", fault = {
        @FaultAction(className = CloudManagerFault_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/getAccountResource/Fault/CloudManagerFault"),
        @FaultAction(className = InvalidUserPass_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/getAccountResource/Fault/InvalidUserPass"),
        @FaultAction(className = InvalidRole_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/getAccountResource/Fault/InvalidRole")
    })
    public CloudAccountResource getAccountResource(
        @WebParam(name = "accountResourceId", targetNamespace = "")
        String accountResourceId)
        throws CloudManagerFault_Exception, InvalidRole_Exception, InvalidUserPass_Exception
    ;

    /**
     * 
     * @return
     *     returns java.util.List<com.clustercontrol.ws.cloud.CloudAccountResource>
     * @throws InvalidRole_Exception
     * @throws CloudManagerFault_Exception
     * @throws InvalidUserPass_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "getAllAccountResources", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.GetAllAccountResources")
    @ResponseWrapper(localName = "getAllAccountResourcesResponse", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.GetAllAccountResourcesResponse")
    @Action(input = "http://cloud.ws.clustercontrol.com/CloudEndpoint/getAllAccountResourcesRequest", output = "http://cloud.ws.clustercontrol.com/CloudEndpoint/getAllAccountResourcesResponse", fault = {
        @FaultAction(className = CloudManagerFault_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/getAllAccountResources/Fault/CloudManagerFault"),
        @FaultAction(className = InvalidUserPass_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/getAllAccountResources/Fault/InvalidUserPass"),
        @FaultAction(className = InvalidRole_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/getAllAccountResources/Fault/InvalidRole")
    })
    public List<CloudAccountResource> getAllAccountResources()
        throws CloudManagerFault_Exception, InvalidRole_Exception, InvalidUserPass_Exception
    ;

    /**
     * 
     * @param cloudServiceId
     * @return
     *     returns com.clustercontrol.ws.cloud.CloudService
     * @throws InvalidRole_Exception
     * @throws CloudManagerFault_Exception
     * @throws InvalidUserPass_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "getCloudService", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.GetCloudService")
    @ResponseWrapper(localName = "getCloudServiceResponse", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.GetCloudServiceResponse")
    @Action(input = "http://cloud.ws.clustercontrol.com/CloudEndpoint/getCloudServiceRequest", output = "http://cloud.ws.clustercontrol.com/CloudEndpoint/getCloudServiceResponse", fault = {
        @FaultAction(className = CloudManagerFault_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/getCloudService/Fault/CloudManagerFault"),
        @FaultAction(className = InvalidUserPass_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/getCloudService/Fault/InvalidUserPass"),
        @FaultAction(className = InvalidRole_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/getCloudService/Fault/InvalidRole")
    })
    public CloudService getCloudService(
        @WebParam(name = "cloudServiceId", targetNamespace = "")
        String cloudServiceId)
        throws CloudManagerFault_Exception, InvalidRole_Exception, InvalidUserPass_Exception
    ;

    /**
     * 
     * @return
     *     returns java.util.List<com.clustercontrol.ws.cloud.CloudService>
     * @throws InvalidRole_Exception
     * @throws InvalidUserPass_Exception
     * @throws CloudManagerFault_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "getAllCloudServices", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.GetAllCloudServices")
    @ResponseWrapper(localName = "getAllCloudServicesResponse", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.GetAllCloudServicesResponse")
    @Action(input = "http://cloud.ws.clustercontrol.com/CloudEndpoint/getAllCloudServicesRequest", output = "http://cloud.ws.clustercontrol.com/CloudEndpoint/getAllCloudServicesResponse", fault = {
        @FaultAction(className = CloudManagerFault_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/getAllCloudServices/Fault/CloudManagerFault"),
        @FaultAction(className = InvalidUserPass_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/getAllCloudServices/Fault/InvalidUserPass"),
        @FaultAction(className = InvalidRole_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/getAllCloudServices/Fault/InvalidRole")
    })
    public List<CloudService> getAllCloudServices()
        throws CloudManagerFault_Exception, InvalidRole_Exception, InvalidUserPass_Exception
    ;

    /**
     * 
     * @param cloudServiceId
     * @return
     *     returns java.util.List<com.clustercontrol.ws.cloud.CloudRegion>
     * @throws InvalidRole_Exception
     * @throws CloudManagerFault_Exception
     * @throws InvalidUserPass_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "getCloudRegionsByService", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.GetCloudRegionsByService")
    @ResponseWrapper(localName = "getCloudRegionsByServiceResponse", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.GetCloudRegionsByServiceResponse")
    @Action(input = "http://cloud.ws.clustercontrol.com/CloudEndpoint/getCloudRegionsByServiceRequest", output = "http://cloud.ws.clustercontrol.com/CloudEndpoint/getCloudRegionsByServiceResponse", fault = {
        @FaultAction(className = CloudManagerFault_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/getCloudRegionsByService/Fault/CloudManagerFault"),
        @FaultAction(className = InvalidUserPass_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/getCloudRegionsByService/Fault/InvalidUserPass"),
        @FaultAction(className = InvalidRole_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/getCloudRegionsByService/Fault/InvalidRole")
    })
    public List<CloudRegion> getCloudRegionsByService(
        @WebParam(name = "cloudServiceId", targetNamespace = "")
        String cloudServiceId)
        throws CloudManagerFault_Exception, InvalidRole_Exception, InvalidUserPass_Exception
    ;

    /**
     * 
     * @param cloudServiceId
     * @return
     *     returns java.util.List<java.lang.String>
     * @throws InvalidRole_Exception
     * @throws InvalidUserPass_Exception
     * @throws CloudManagerFault_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "getStorageFlavorsByService", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.GetStorageFlavorsByService")
    @ResponseWrapper(localName = "getStorageFlavorsByServiceResponse", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.GetStorageFlavorsByServiceResponse")
    @Action(input = "http://cloud.ws.clustercontrol.com/CloudEndpoint/getStorageFlavorsByServiceRequest", output = "http://cloud.ws.clustercontrol.com/CloudEndpoint/getStorageFlavorsByServiceResponse", fault = {
        @FaultAction(className = CloudManagerFault_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/getStorageFlavorsByService/Fault/CloudManagerFault"),
        @FaultAction(className = InvalidUserPass_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/getStorageFlavorsByService/Fault/InvalidUserPass"),
        @FaultAction(className = InvalidRole_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/getStorageFlavorsByService/Fault/InvalidRole")
    })
    public List<String> getStorageFlavorsByService(
        @WebParam(name = "cloudServiceId", targetNamespace = "")
        String cloudServiceId)
        throws CloudManagerFault_Exception, InvalidRole_Exception, InvalidUserPass_Exception
    ;

    /**
     * 
     * @param accountResourceId
     * @return
     *     returns java.util.List<java.lang.String>
     * @throws InvalidRole_Exception
     * @throws InvalidUserPass_Exception
     * @throws CloudManagerFault_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "getCloudServicesForBilling", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.GetCloudServicesForBilling")
    @ResponseWrapper(localName = "getCloudServicesForBillingResponse", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.GetCloudServicesForBillingResponse")
    @Action(input = "http://cloud.ws.clustercontrol.com/CloudEndpoint/getCloudServicesForBillingRequest", output = "http://cloud.ws.clustercontrol.com/CloudEndpoint/getCloudServicesForBillingResponse", fault = {
        @FaultAction(className = CloudManagerFault_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/getCloudServicesForBilling/Fault/CloudManagerFault"),
        @FaultAction(className = InvalidUserPass_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/getCloudServicesForBilling/Fault/InvalidUserPass"),
        @FaultAction(className = InvalidRole_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/getCloudServicesForBilling/Fault/InvalidRole")
    })
    public List<String> getCloudServicesForBilling(
        @WebParam(name = "accountResourceId", targetNamespace = "")
        String accountResourceId)
        throws CloudManagerFault_Exception, InvalidRole_Exception, InvalidUserPass_Exception
    ;

    /**
     * 
     * @param facilityId
     * @throws InvalidRole_Exception
     * @throws CloudManagerFault_Exception
     * @throws InvalidUserPass_Exception
     */
    @WebMethod
    @RequestWrapper(localName = "establishAgentConnection", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.EstablishAgentConnection")
    @ResponseWrapper(localName = "establishAgentConnectionResponse", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.EstablishAgentConnectionResponse")
    @Action(input = "http://cloud.ws.clustercontrol.com/CloudEndpoint/establishAgentConnectionRequest", output = "http://cloud.ws.clustercontrol.com/CloudEndpoint/establishAgentConnectionResponse", fault = {
        @FaultAction(className = CloudManagerFault_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/establishAgentConnection/Fault/CloudManagerFault"),
        @FaultAction(className = InvalidUserPass_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/establishAgentConnection/Fault/InvalidUserPass"),
        @FaultAction(className = InvalidRole_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/establishAgentConnection/Fault/InvalidRole")
    })
    public void establishAgentConnection(
        @WebParam(name = "facilityId", targetNamespace = "")
        String facilityId)
        throws CloudManagerFault_Exception, InvalidRole_Exception, InvalidUserPass_Exception
    ;

    /**
     * 
     * @return
     *     returns java.util.List<com.clustercontrol.ws.cloud.AvailableRole>
     * @throws InvalidRole_Exception
     * @throws CloudManagerFault_Exception
     * @throws InvalidUserPass_Exception
     */
    @WebMethod
    @WebResult(targetNamespace = "")
    @RequestWrapper(localName = "getAvailableRoles", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.GetAvailableRoles")
    @ResponseWrapper(localName = "getAvailableRolesResponse", targetNamespace = "http://cloud.ws.clustercontrol.com", className = "com.clustercontrol.ws.cloud.GetAvailableRolesResponse")
    @Action(input = "http://cloud.ws.clustercontrol.com/CloudEndpoint/getAvailableRolesRequest", output = "http://cloud.ws.clustercontrol.com/CloudEndpoint/getAvailableRolesResponse", fault = {
        @FaultAction(className = CloudManagerFault_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/getAvailableRoles/Fault/CloudManagerFault"),
        @FaultAction(className = InvalidUserPass_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/getAvailableRoles/Fault/InvalidUserPass"),
        @FaultAction(className = InvalidRole_Exception.class, value = "http://cloud.ws.clustercontrol.com/CloudEndpoint/getAvailableRoles/Fault/InvalidRole")
    })
    public List<AvailableRole> getAvailableRoles()
        throws CloudManagerFault_Exception, InvalidRole_Exception, InvalidUserPass_Exception
    ;

}
