/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.dao;

import java.sql.Timestamp;

import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.Table;

/**
 * インスタンス情報のBMP Entity Bean クラス<BR>
 */
@Entity
@Table(name="cc_cloud_template")
public class CloudTemplateDao  extends HinemosObjectDao {
	private String templateId;
	private String cloudServiceId;
	private String region;
	private String accountResourceId;
	private String templateName;
	private String cloudUserId;
	private String imageId;
	private String jobUnitId;
	private String launchJobId;
	private String startJobId;
	private String stopJobId;
	private Timestamp regDate;
	private Timestamp updateDate;
	private String regUser;
	private String updateUser;

	public CloudTemplateDao()
	{
	}

	public CloudTemplateDao( String templateId,String templateName,String cloudServiceId,String cloudAccountId,String cloudUserId,String imageId,String jobUnitId,String launchJobId,String startJobId,String stopJobId,String region,Timestamp regDate,Timestamp updateDate,String regUser,String updateUser )
	{
		super(regDate, updateDate, regUser, updateUser);
		setTemplateId(templateId);
		setCloudServiceId(cloudServiceId);
		setRegion(region);
		setAccountResourceId(cloudAccountId);
		setTemplateName(templateName);
		setCloudUserId(cloudUserId);
		setImageId(imageId);
		setJobUnitId(jobUnitId);
		setLaunchJobId(launchJobId);
		setStartJobId(startJobId);
		setStopJobId(stopJobId);
	}

	public CloudTemplateDao( CloudTemplateDao otherData )
	{
		super(otherData);
		setTemplateId(otherData.getTemplateId());
		setCloudServiceId(otherData.getCloudServiceId());
		setRegion(otherData.getRegion());
		setAccountResourceId(otherData.getAccountResourceId());
		setTemplateName(otherData.getTemplateName());
		setCloudUserId(otherData.getCloudUserId());
		setImageId(otherData.getImageId());
		setJobUnitId(otherData.getJobUnitId());
		setLaunchJobId(otherData.getLaunchJobId());
		setStartJobId(otherData.getStartJobId());
		setStopJobId(otherData.getStopJobId());
	}

	@Column(name="template_id")
	@Id
	public String getTemplateId()
	{
		return this.templateId;
	}
	public void setTemplateId( String templateId )
	{
		this.templateId = templateId;
	}

	@Column(name="cloud_service_id")
	public String getCloudServiceId()
	{
		return this.cloudServiceId;
	}
	public void setCloudServiceId( String cloudServiceId )
	{
		this.cloudServiceId = cloudServiceId;
	}

	@Column(name="region")
	public String getRegion()
	{
		return this.region;
	}
	public void setRegion( String region )
	{
		this.region = region;
	}

	@Column(name="account_resource_id")
	public String getAccountResourceId()
	{
		return this.accountResourceId;
	}
	public void setAccountResourceId( String accountResourceId )
	{
		this.accountResourceId = accountResourceId;
	}

	@Column(name="template_name")
	public String getTemplateName()
	{
		return this.templateName;
	}
	public void setTemplateName( String templateName )
	{
		this.templateName = templateName;
	}

	@Column(name="cloud_user_id")
	public String getCloudUserId()
	{
		return this.cloudUserId;
	}
	public void setCloudUserId( String cloudUserId )
	{
		this.cloudUserId = cloudUserId;
	}

	@Column(name="image_id")
	public String getImageId()
	{
		return this.imageId;
	}
	public void setImageId( String imageId )
	{
		this.imageId = imageId;
	}

	@Column(name="jobunit_id")
	public String getJobUnitId()
	{
		return this.jobUnitId;
	}
	public void setJobUnitId( String jobUnitId )
	{
		this.jobUnitId = jobUnitId;
	}

	@Column(name="launch_job_id")
	public String getLaunchJobId()
	{
		return this.launchJobId;
	}
	public void setLaunchJobId( String launchJobId )
	{
		this.launchJobId = launchJobId;
	}

	@Column(name="start_job_id")
	public String getStartJobId()
	{
		return this.startJobId;
	}
	public void setStartJobId( String startJobId )
	{
		this.startJobId = startJobId;
	}

	@Column(name="stop_job_id")
	public String getStopJobId()
	{
		return this.stopJobId;
	}
	public void setStopJobId( String stopJobId )
	{
		this.stopJobId = stopJobId;
	}

	@Override
	public String toString() {
		return "CloudTemplateDao [templateId=" + templateId + ", templateName="
				+ templateName + ", region=" + region + ", accountResourceId="
				+ accountResourceId + ", cloudUserId=" + cloudUserId
				+ ", imageId=" + imageId + ", jobUnitId=" + jobUnitId
				+ ", launchJobId=" + launchJobId + ", startJobId=" + startJobId
				+ ", stopJobId=" + stopJobId + ", regDate=" + regDate
				+ ", updateDate=" + updateDate + ", regUser=" + regUser
				+ ", updateUser=" + updateUser + "]";
	}

	@Override
	public boolean equals(Object obj) {
		if (this == obj)
			return true;
		if (!super.equals(obj))
			return false;
		if (getClass() != obj.getClass())
			return false;
		CloudTemplateDao other = (CloudTemplateDao) obj;
		if (accountResourceId == null) {
			if (other.accountResourceId != null)
				return false;
		} else if (!accountResourceId.equals(other.accountResourceId))
			return false;
		if (cloudUserId == null) {
			if (other.cloudUserId != null)
				return false;
		} else if (!cloudUserId.equals(other.cloudUserId))
			return false;
		if (imageId == null) {
			if (other.imageId != null)
				return false;
		} else if (!imageId.equals(other.imageId))
			return false;
		if (jobUnitId == null) {
			if (other.jobUnitId != null)
				return false;
		} else if (!jobUnitId.equals(other.jobUnitId))
			return false;
		if (launchJobId == null) {
			if (other.launchJobId != null)
				return false;
		} else if (!launchJobId.equals(other.launchJobId))
			return false;
		if (regDate == null) {
			if (other.regDate != null)
				return false;
		} else if (!regDate.equals(other.regDate))
			return false;
		if (regUser == null) {
			if (other.regUser != null)
				return false;
		} else if (!regUser.equals(other.regUser))
			return false;
		if (region == null) {
			if (other.region != null)
				return false;
		} else if (!region.equals(other.region))
			return false;
		if (startJobId == null) {
			if (other.startJobId != null)
				return false;
		} else if (!startJobId.equals(other.startJobId))
			return false;
		if (stopJobId == null) {
			if (other.stopJobId != null)
				return false;
		} else if (!stopJobId.equals(other.stopJobId))
			return false;
		if (templateId == null) {
			if (other.templateId != null)
				return false;
		} else if (!templateId.equals(other.templateId))
			return false;
		if (templateName == null) {
			if (other.templateName != null)
				return false;
		} else if (!templateName.equals(other.templateName))
			return false;
		if (updateDate == null) {
			if (other.updateDate != null)
				return false;
		} else if (!updateDate.equals(other.updateDate))
			return false;
		if (updateUser == null) {
			if (other.updateUser != null)
				return false;
		} else if (!updateUser.equals(other.updateUser))
			return false;
		return true;
	}

	@Override
	public int hashCode() {
		final int prime = 31;
		int result = super.hashCode();
		result = prime
				* result
				+ ((accountResourceId == null) ? 0 : accountResourceId
						.hashCode());
		result = prime * result
				+ ((cloudUserId == null) ? 0 : cloudUserId.hashCode());
		result = prime * result + ((imageId == null) ? 0 : imageId.hashCode());
		result = prime * result
				+ ((jobUnitId == null) ? 0 : jobUnitId.hashCode());
		result = prime * result
				+ ((launchJobId == null) ? 0 : launchJobId.hashCode());
		result = prime * result + ((regDate == null) ? 0 : regDate.hashCode());
		result = prime * result + ((regUser == null) ? 0 : regUser.hashCode());
		result = prime * result + ((region == null) ? 0 : region.hashCode());
		result = prime * result
				+ ((startJobId == null) ? 0 : startJobId.hashCode());
		result = prime * result
				+ ((stopJobId == null) ? 0 : stopJobId.hashCode());
		result = prime * result
				+ ((templateId == null) ? 0 : templateId.hashCode());
		result = prime * result
				+ ((templateName == null) ? 0 : templateName.hashCode());
		result = prime * result
				+ ((updateDate == null) ? 0 : updateDate.hashCode());
		result = prime * result
				+ ((updateUser == null) ? 0 : updateUser.hashCode());
		return result;
	}

	@Override
	public Object getId() {
		return getTemplateId();
	}
}
