/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.bean;

import java.io.Serializable;
import java.util.List;

import javax.xml.bind.annotation.XmlType;

import com.clustercontrol.cloud.IResourceManagement;
import com.clustercontrol.cloud.dao.CloudInstanceBackupDao;

public class CloudInstanceBackup implements Serializable {	
	/**
	 * 
	 */
	private static final long serialVersionUID = 6230403498595911981L;
	
	@XmlType(name="InstanceBackupedData")
	public static class BackupedData implements Serializable {
		/**
		 * 
		 */
		private static final long serialVersionUID = -5701186171059463746L;
		private CloudInstanceBackupDao.BackupedData dao;
		private IResourceManagement.InstanceBackup.BackupedData backup;

		public BackupedData() {
		}

		public BackupedData(com.clustercontrol.cloud.dao.CloudInstanceBackupDao.BackupedData dao, IResourceManagement.InstanceBackup.BackupedData backup) {
			super();
			this.dao = dao;
			this.backup = backup;
		}

		public String getFacilityId() {
			return dao.getFacilityId();
		}

		public void setFacilityId(String facilityId) {
			throw new UnsupportedOperationException();
		}

		public String getFacilityName() {
			return dao.getFacilityName();
		}

		public void setFacilityName(String facilityName) {
			throw new UnsupportedOperationException();
		}

		public String getFacilityDescription() {
			return dao.getFacilityDescription();
		}

		public void setFacilityDescription(String facilityDescription) {
			throw new UnsupportedOperationException();
		}

		public String getNodeName() {
			return dao.getNodeName();
		}

		public void setNodeName(String nodeName) {
			throw new UnsupportedOperationException();
		}

		public String getInstanceId() {
			return dao.getInstanceId();
		}

		public void setInstanceId(String instanceId) {
			throw new UnsupportedOperationException();
		}

		public String getFlavor() {
			return backup != null ? backup.getFlavor(): null;
		}

		public void setFlavor(String flavor) {
			throw new UnsupportedOperationException();
		}

		public String getZone() {
			return backup != null ? backup.getZone(): null;
		}

		public void setZone(String zone) {
			throw new UnsupportedOperationException();
		}

		public List<Tag> getTags() {
			return backup != null ? backup.getTags(): null;
		}

		public void setTags(List<Tag> tags) {
			throw new UnsupportedOperationException();
		}

		public String getInstanceDetail() {
			return backup != null ? backup.getInstanceDetail(): null;
		}

		public void setInstanceDetail(String instanceDetail) {
			throw new UnsupportedOperationException();
		}
	}
	
	private CloudInstanceBackupDao dao;
	private IResourceManagement.InstanceBackup backup;

	public CloudInstanceBackup() {
		super();
	}

	public CloudInstanceBackup(CloudInstanceBackupDao dao, IResourceManagement.InstanceBackup backup) {
		super();
		this.dao = dao;
		this.backup = backup;
	}

	public String getInstanceBackupId() {
		return dao.getInstanceBackupId();
	}

	public void setInstanceBackupId(String instanceBackup) {
		throw new UnsupportedOperationException();
	}

	public String getRegion() {
		return dao.getRegion();
	}
	public void setRegion(String region) {
		throw new UnsupportedOperationException();
	}
	
	public String getAccountResourceId() {
		return dao.getAccountResourceId();
	}
	public void setAccountResourceId(String accountResourceId) {
		throw new UnsupportedOperationException();
	}

	public String getName() {
		return dao.getName();
	}

	public void setName(String name) {
		throw new UnsupportedOperationException();
	}

	public String getCloudUserId() {
		return dao.getCloudUserId();
	}

	public void setCloudUserId(String accessKey) {
		throw new UnsupportedOperationException();
	}

	public String getDescription() {
		return dao.getDescription();
	}

	public void setDescription(String description) {
		throw new UnsupportedOperationException();
	}

	public BackupedData getBackupedData() {
		return dao.getBackupedData() == null ? null: new BackupedData(dao.getBackupedData(), backup == null ? null: backup.getBackupedData());
	}
	public void setBackupedData(BackupedData data) {
		throw new UnsupportedOperationException();
	}

	public RestoreStatus getRestoreStatus() {
		if (dao.getRestoreStatus() == null) {
			return null;
		}
		return RestoreStatus.valueOf(dao.getRestoreStatus().name());
	}

	public void setRestoreStatus(RestoreStatus registState) {
		throw new UnsupportedOperationException();
	}

	public String getPlatform() {
		return backup != null ? (backup.getPlatform() != null ? backup.getPlatform().label(): null): null;
	}

	public void setPlatform(String platform) {
		throw new UnsupportedOperationException();
	}

	public Long getRegDate() {
		return dao.getRegDate() != null ? dao.getRegDate().getTime(): null;
	}

	public void setRegDate(Long regDate) {
		throw new UnsupportedOperationException();
	}

	public String getRegUser() {
		return dao.getRegUser();
	}

	public void setRegUser(String regUser) {
		throw new UnsupportedOperationException();
	}
}