/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.aws.factory;

import com.amazonaws.AmazonServiceException;
import com.amazonaws.services.identitymanagement.AmazonIdentityManagement;
import com.amazonaws.services.identitymanagement.model.GetUserResult;
import com.clustercontrol.cloud.CloudManagerFault;
import com.clustercontrol.cloud.IResourceManagement;
import com.clustercontrol.cloud.IUserManagement;
import com.clustercontrol.cloud.InternalManagerError;
import com.clustercontrol.cloud.aws.util.AWSUtil;
import com.clustercontrol.cloud.util.CloudCredential;

public class AWSUserManagement
implements IUserManagement {
    private IUserManagement.ICredential credential;

    public void setCredential(IUserManagement.ICredential credential) {
        this.credential = credential;
    }

    public IUserManagement.User getCurrentUser() throws CloudManagerFault {
        try {
            AmazonIdentityManagement aim = AWSUtil.createIAM((IResourceManagement.ICredential)new CloudCredential(this.credential.getAccessKey(), this.credential.getSecretKey()));
            GetUserResult result = aim.getUser();
            AWSUtil.AMIArn arn = new AWSUtil.AMIArn(result.getUser().getArn());
            return new IUserManagement.User(arn.userName, arn.isRoot() ? IUserManagement.User.UserKind.account : IUserManagement.User.UserKind.user);
        }
        catch (AmazonServiceException e) {
            throw new CloudManagerFault(e.getMessage(), e.getErrorCode(), (Throwable)e);
        }
        catch (Exception e) {
            throw new InternalManagerError((Throwable)e);
        }
    }
}

