/*
 * Decompiled with CFR 0.152.
 */
package com.clustercontrol.cloud.validation;

import com.clustercontrol.cloud.CloudManagerFault;
import com.clustercontrol.cloud.ErrorCode;
import com.clustercontrol.cloud.IMessagesHolder;
import com.clustercontrol.cloud.SessionService;
import com.clustercontrol.cloud.persistence.EntityManagerEx;
import com.clustercontrol.cloud.validation.ValidationFault;
import com.clustercontrol.cloud.validation.ValidationUtil;
import com.clustercontrol.cloud.validation.annotation.ValidatedBy;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import javax.persistence.NoResultException;
import javax.persistence.Query;

@Retention(value=RetentionPolicy.RUNTIME)
@Target(value={ElementType.METHOD, ElementType.PARAMETER})
@ValidatedBy(value=Validator.class)
public @interface ModifiableAccountResource {
    public String elementId() default "";

    public String validationId() default "com.clustercontrol.cloud.validation.AccountResourceAccessibleValidator";

    public String[] groups() default {};

    public static class Validator
    extends ValidationUtil.AbstractValidator<ModifiableAccountResource, String> {
        public void init(ModifiableAccountResource annotation) {
            this.setElementId(annotation.elementId());
            this.setValidationId(annotation.validationId());
            this.setGroups(annotation.groups());
        }

        protected void internalValidate(String property, String group, IMessagesHolder messages) throws ValidationFault {
            if (property == null || property.isEmpty()) {
                return;
            }
            EntityManagerEx em = SessionService.current().getEntityManagerEx();
            Query query1 = em.createQuery("SELECT DISTINCT u.accountResource FROM CloudUserDao u, UserEntity h, RoleEntity r WHERE u.accountResource.accountResourceId = :accountResourceId AND h.userId = :userId AND h MEMBER OF r.userEntities AND r.roleId = u.roleId");
            query1.setParameter("accountResourceId", (Object)property);
            query1.setParameter("userId", (Object)SessionService.current().getHinemosCredential().getUserId());
            try {
                query1.getSingleResult();
            }
            catch (NoResultException e1) {
                Query query2 = em.createQuery("SELECT DISTINCT h FROM UserEntity h, RoleEntity r WHERE h.userId = :userId AND h MEMBER OF r.userEntities AND r.roleId = :ADMINISTRATORS");
                query2.setParameter("userId", (Object)SessionService.current().getHinemosCredential().getUserId());
                query2.setParameter("ADMINISTRATORS", (Object)"ADMINISTRATORS");
                try {
                    query2.getSingleResult();
                }
                catch (NoResultException e2) {
                    CloudManagerFault f = ErrorCode.ACCOUNTRESOURCE_INVALID_ACCOUNTRESOURCE_NOT_FOUND.cloudManagerFault(property);
                    throw new ValidationFault(f.getMessage(), f.getErrorCode(), (Throwable)((Object)f));
                }
            }
        }
    }
}

