/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.simpleworkflow.flow.core;

import com.amazonaws.services.simpleworkflow.flow.core.AndPromise;
import com.amazonaws.services.simpleworkflow.flow.core.AsyncParentContext;
import com.amazonaws.services.simpleworkflow.flow.core.AsyncStackTrace;
import com.amazonaws.services.simpleworkflow.flow.core.AsyncTaskInfo;
import com.amazonaws.services.simpleworkflow.flow.core.Promise;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
abstract class AsyncContextBase
implements Runnable,
AsyncParentContext {
    private static final ThreadLocal<AsyncParentContext> currentContext = new ThreadLocal();
    private final boolean daemon;
    protected final AsyncParentContext parent;
    protected AsyncStackTrace stackTrace;
    private final Promise<?>[] waitFor;
    private String name;

    static AsyncParentContext current() {
        AsyncParentContext result = currentContext.get();
        if (result == null) {
            throw new IllegalStateException("Attempt to execute asynchronous code outside of AsyncScope.doAsync() method");
        }
        return result;
    }

    static void setCurrent(AsyncParentContext newCurrent) {
        currentContext.set(newCurrent);
    }

    public AsyncContextBase(Boolean daemon, Promise<?>[] waitFor, int skipStackLines) {
        this(AsyncContextBase.current(), daemon, waitFor, skipStackLines);
    }

    public AsyncContextBase(AsyncParentContext parent, Boolean daemon, Promise<?>[] waitFor, int skipStackLines) {
        this.parent = parent;
        this.daemon = daemon == null ? parent.getDaemonFlagForHeir() : daemon.booleanValue();
        this.waitFor = waitFor;
        this.name = parent == null ? null : parent.getName();
        AsyncStackTrace parentStack = parent.getStackTrace();
        if (parentStack != null) {
            this.stackTrace = new AsyncStackTrace(parentStack, Thread.currentThread().getStackTrace(), skipStackLines);
            this.stackTrace.setStartFrom(parent.getParentTaskMethodName());
            this.stackTrace.setHideStartFromMethod(parent.getHideStartFromMethod());
        }
        this.parent.add(this, waitFor == null || waitFor.length == 0 ? null : new AndPromise(waitFor));
    }

    public boolean isDaemon() {
        return this.daemon;
    }

    @Override
    public AsyncStackTrace getStackTrace() {
        return this.stackTrace;
    }

    public AsyncTaskInfo getTaskInfo() {
        return new AsyncTaskInfo(this.name, this.stackTrace == null ? null : this.stackTrace.getStackTrace(), this.daemon, this.waitFor);
    }

    @Override
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public abstract void cancel(Throwable var1);

    public String getAsynchronousStackTraceDumpAsString() {
        ArrayList<AsyncTaskInfo> infos = new ArrayList<AsyncTaskInfo>();
        this.getAsynchronousStackTraceDump(infos);
        StringBuffer sb = new StringBuffer();
        for (int j = 0; j < infos.size(); ++j) {
            AsyncTaskInfo info = (AsyncTaskInfo)infos.get(j);
            if (j > 0) {
                sb.append("-----------------------------------------------------\n");
            }
            sb.append(info);
        }
        return sb.toString();
    }

    @Override
    public boolean getHideStartFromMethod() {
        return false;
    }

    protected void getAsynchronousStackTraceDump(List<AsyncTaskInfo> result) {
        result.add(this.getTaskInfo());
    }
}

