/*
 * Decompiled with CFR 0.152.
 */
package com.amazonaws.services.rds.model;

import com.amazonaws.AmazonWebServiceRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class CreateDBInstanceRequest
extends AmazonWebServiceRequest {
    private String dBName;
    private String dBInstanceIdentifier;
    private Integer allocatedStorage;
    private String dBInstanceClass;
    private String engine;
    private String masterUsername;
    private String masterUserPassword;
    private List<String> dBSecurityGroups;
    private String availabilityZone;
    private String dBSubnetGroupName;
    private String preferredMaintenanceWindow;
    private String dBParameterGroupName;
    private Integer backupRetentionPeriod;
    private String preferredBackupWindow;
    private Integer port;
    private Boolean multiAZ;
    private String engineVersion;
    private Boolean autoMinorVersionUpgrade;
    private String licenseModel;
    private String optionGroupName;
    private String characterSetName;

    public CreateDBInstanceRequest() {
    }

    public CreateDBInstanceRequest(String dBInstanceIdentifier, Integer allocatedStorage, String dBInstanceClass, String engine, String masterUsername, String masterUserPassword) {
        this.dBInstanceIdentifier = dBInstanceIdentifier;
        this.allocatedStorage = allocatedStorage;
        this.dBInstanceClass = dBInstanceClass;
        this.engine = engine;
        this.masterUsername = masterUsername;
        this.masterUserPassword = masterUserPassword;
    }

    public String getDBName() {
        return this.dBName;
    }

    public void setDBName(String dBName) {
        this.dBName = dBName;
    }

    public CreateDBInstanceRequest withDBName(String dBName) {
        this.dBName = dBName;
        return this;
    }

    public String getDBInstanceIdentifier() {
        return this.dBInstanceIdentifier;
    }

    public void setDBInstanceIdentifier(String dBInstanceIdentifier) {
        this.dBInstanceIdentifier = dBInstanceIdentifier;
    }

    public CreateDBInstanceRequest withDBInstanceIdentifier(String dBInstanceIdentifier) {
        this.dBInstanceIdentifier = dBInstanceIdentifier;
        return this;
    }

    public Integer getAllocatedStorage() {
        return this.allocatedStorage;
    }

    public void setAllocatedStorage(Integer allocatedStorage) {
        this.allocatedStorage = allocatedStorage;
    }

    public CreateDBInstanceRequest withAllocatedStorage(Integer allocatedStorage) {
        this.allocatedStorage = allocatedStorage;
        return this;
    }

    public String getDBInstanceClass() {
        return this.dBInstanceClass;
    }

    public void setDBInstanceClass(String dBInstanceClass) {
        this.dBInstanceClass = dBInstanceClass;
    }

    public CreateDBInstanceRequest withDBInstanceClass(String dBInstanceClass) {
        this.dBInstanceClass = dBInstanceClass;
        return this;
    }

    public String getEngine() {
        return this.engine;
    }

    public void setEngine(String engine) {
        this.engine = engine;
    }

    public CreateDBInstanceRequest withEngine(String engine) {
        this.engine = engine;
        return this;
    }

    public String getMasterUsername() {
        return this.masterUsername;
    }

    public void setMasterUsername(String masterUsername) {
        this.masterUsername = masterUsername;
    }

    public CreateDBInstanceRequest withMasterUsername(String masterUsername) {
        this.masterUsername = masterUsername;
        return this;
    }

    public String getMasterUserPassword() {
        return this.masterUserPassword;
    }

    public void setMasterUserPassword(String masterUserPassword) {
        this.masterUserPassword = masterUserPassword;
    }

    public CreateDBInstanceRequest withMasterUserPassword(String masterUserPassword) {
        this.masterUserPassword = masterUserPassword;
        return this;
    }

    public List<String> getDBSecurityGroups() {
        if (this.dBSecurityGroups == null) {
            this.dBSecurityGroups = new ArrayList<String>();
        }
        return this.dBSecurityGroups;
    }

    public void setDBSecurityGroups(Collection<String> dBSecurityGroups) {
        if (dBSecurityGroups == null) {
            this.dBSecurityGroups = null;
            return;
        }
        ArrayList<String> dBSecurityGroupsCopy = new ArrayList<String>(dBSecurityGroups.size());
        dBSecurityGroupsCopy.addAll(dBSecurityGroups);
        this.dBSecurityGroups = dBSecurityGroupsCopy;
    }

    public CreateDBInstanceRequest withDBSecurityGroups(String ... dBSecurityGroups) {
        if (this.getDBSecurityGroups() == null) {
            this.setDBSecurityGroups(new ArrayList<String>(dBSecurityGroups.length));
        }
        for (String value : dBSecurityGroups) {
            this.getDBSecurityGroups().add(value);
        }
        return this;
    }

    public CreateDBInstanceRequest withDBSecurityGroups(Collection<String> dBSecurityGroups) {
        if (dBSecurityGroups == null) {
            this.dBSecurityGroups = null;
        } else {
            ArrayList<String> dBSecurityGroupsCopy = new ArrayList<String>(dBSecurityGroups.size());
            dBSecurityGroupsCopy.addAll(dBSecurityGroups);
            this.dBSecurityGroups = dBSecurityGroupsCopy;
        }
        return this;
    }

    public String getAvailabilityZone() {
        return this.availabilityZone;
    }

    public void setAvailabilityZone(String availabilityZone) {
        this.availabilityZone = availabilityZone;
    }

    public CreateDBInstanceRequest withAvailabilityZone(String availabilityZone) {
        this.availabilityZone = availabilityZone;
        return this;
    }

    public String getDBSubnetGroupName() {
        return this.dBSubnetGroupName;
    }

    public void setDBSubnetGroupName(String dBSubnetGroupName) {
        this.dBSubnetGroupName = dBSubnetGroupName;
    }

    public CreateDBInstanceRequest withDBSubnetGroupName(String dBSubnetGroupName) {
        this.dBSubnetGroupName = dBSubnetGroupName;
        return this;
    }

    public String getPreferredMaintenanceWindow() {
        return this.preferredMaintenanceWindow;
    }

    public void setPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
        this.preferredMaintenanceWindow = preferredMaintenanceWindow;
    }

    public CreateDBInstanceRequest withPreferredMaintenanceWindow(String preferredMaintenanceWindow) {
        this.preferredMaintenanceWindow = preferredMaintenanceWindow;
        return this;
    }

    public String getDBParameterGroupName() {
        return this.dBParameterGroupName;
    }

    public void setDBParameterGroupName(String dBParameterGroupName) {
        this.dBParameterGroupName = dBParameterGroupName;
    }

    public CreateDBInstanceRequest withDBParameterGroupName(String dBParameterGroupName) {
        this.dBParameterGroupName = dBParameterGroupName;
        return this;
    }

    public Integer getBackupRetentionPeriod() {
        return this.backupRetentionPeriod;
    }

    public void setBackupRetentionPeriod(Integer backupRetentionPeriod) {
        this.backupRetentionPeriod = backupRetentionPeriod;
    }

    public CreateDBInstanceRequest withBackupRetentionPeriod(Integer backupRetentionPeriod) {
        this.backupRetentionPeriod = backupRetentionPeriod;
        return this;
    }

    public String getPreferredBackupWindow() {
        return this.preferredBackupWindow;
    }

    public void setPreferredBackupWindow(String preferredBackupWindow) {
        this.preferredBackupWindow = preferredBackupWindow;
    }

    public CreateDBInstanceRequest withPreferredBackupWindow(String preferredBackupWindow) {
        this.preferredBackupWindow = preferredBackupWindow;
        return this;
    }

    public Integer getPort() {
        return this.port;
    }

    public void setPort(Integer port) {
        this.port = port;
    }

    public CreateDBInstanceRequest withPort(Integer port) {
        this.port = port;
        return this;
    }

    public Boolean isMultiAZ() {
        return this.multiAZ;
    }

    public void setMultiAZ(Boolean multiAZ) {
        this.multiAZ = multiAZ;
    }

    public CreateDBInstanceRequest withMultiAZ(Boolean multiAZ) {
        this.multiAZ = multiAZ;
        return this;
    }

    public Boolean getMultiAZ() {
        return this.multiAZ;
    }

    public String getEngineVersion() {
        return this.engineVersion;
    }

    public void setEngineVersion(String engineVersion) {
        this.engineVersion = engineVersion;
    }

    public CreateDBInstanceRequest withEngineVersion(String engineVersion) {
        this.engineVersion = engineVersion;
        return this;
    }

    public Boolean isAutoMinorVersionUpgrade() {
        return this.autoMinorVersionUpgrade;
    }

    public void setAutoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
        this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
    }

    public CreateDBInstanceRequest withAutoMinorVersionUpgrade(Boolean autoMinorVersionUpgrade) {
        this.autoMinorVersionUpgrade = autoMinorVersionUpgrade;
        return this;
    }

    public Boolean getAutoMinorVersionUpgrade() {
        return this.autoMinorVersionUpgrade;
    }

    public String getLicenseModel() {
        return this.licenseModel;
    }

    public void setLicenseModel(String licenseModel) {
        this.licenseModel = licenseModel;
    }

    public CreateDBInstanceRequest withLicenseModel(String licenseModel) {
        this.licenseModel = licenseModel;
        return this;
    }

    public String getOptionGroupName() {
        return this.optionGroupName;
    }

    public void setOptionGroupName(String optionGroupName) {
        this.optionGroupName = optionGroupName;
    }

    public CreateDBInstanceRequest withOptionGroupName(String optionGroupName) {
        this.optionGroupName = optionGroupName;
        return this;
    }

    public String getCharacterSetName() {
        return this.characterSetName;
    }

    public void setCharacterSetName(String characterSetName) {
        this.characterSetName = characterSetName;
    }

    public CreateDBInstanceRequest withCharacterSetName(String characterSetName) {
        this.characterSetName = characterSetName;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        if (this.dBName != null) {
            sb.append("DBName: " + this.dBName + ", ");
        }
        if (this.dBInstanceIdentifier != null) {
            sb.append("DBInstanceIdentifier: " + this.dBInstanceIdentifier + ", ");
        }
        if (this.allocatedStorage != null) {
            sb.append("AllocatedStorage: " + this.allocatedStorage + ", ");
        }
        if (this.dBInstanceClass != null) {
            sb.append("DBInstanceClass: " + this.dBInstanceClass + ", ");
        }
        if (this.engine != null) {
            sb.append("Engine: " + this.engine + ", ");
        }
        if (this.masterUsername != null) {
            sb.append("MasterUsername: " + this.masterUsername + ", ");
        }
        if (this.masterUserPassword != null) {
            sb.append("MasterUserPassword: " + this.masterUserPassword + ", ");
        }
        if (this.dBSecurityGroups != null) {
            sb.append("DBSecurityGroups: " + this.dBSecurityGroups + ", ");
        }
        if (this.availabilityZone != null) {
            sb.append("AvailabilityZone: " + this.availabilityZone + ", ");
        }
        if (this.dBSubnetGroupName != null) {
            sb.append("DBSubnetGroupName: " + this.dBSubnetGroupName + ", ");
        }
        if (this.preferredMaintenanceWindow != null) {
            sb.append("PreferredMaintenanceWindow: " + this.preferredMaintenanceWindow + ", ");
        }
        if (this.dBParameterGroupName != null) {
            sb.append("DBParameterGroupName: " + this.dBParameterGroupName + ", ");
        }
        if (this.backupRetentionPeriod != null) {
            sb.append("BackupRetentionPeriod: " + this.backupRetentionPeriod + ", ");
        }
        if (this.preferredBackupWindow != null) {
            sb.append("PreferredBackupWindow: " + this.preferredBackupWindow + ", ");
        }
        if (this.port != null) {
            sb.append("Port: " + this.port + ", ");
        }
        if (this.multiAZ != null) {
            sb.append("MultiAZ: " + this.multiAZ + ", ");
        }
        if (this.engineVersion != null) {
            sb.append("EngineVersion: " + this.engineVersion + ", ");
        }
        if (this.autoMinorVersionUpgrade != null) {
            sb.append("AutoMinorVersionUpgrade: " + this.autoMinorVersionUpgrade + ", ");
        }
        if (this.licenseModel != null) {
            sb.append("LicenseModel: " + this.licenseModel + ", ");
        }
        if (this.optionGroupName != null) {
            sb.append("OptionGroupName: " + this.optionGroupName + ", ");
        }
        if (this.characterSetName != null) {
            sb.append("CharacterSetName: " + this.characterSetName + ", ");
        }
        sb.append("}");
        return sb.toString();
    }

    public int hashCode() {
        int prime = 31;
        int hashCode = 1;
        hashCode = 31 * hashCode + (this.getDBName() == null ? 0 : this.getDBName().hashCode());
        hashCode = 31 * hashCode + (this.getDBInstanceIdentifier() == null ? 0 : this.getDBInstanceIdentifier().hashCode());
        hashCode = 31 * hashCode + (this.getAllocatedStorage() == null ? 0 : this.getAllocatedStorage().hashCode());
        hashCode = 31 * hashCode + (this.getDBInstanceClass() == null ? 0 : this.getDBInstanceClass().hashCode());
        hashCode = 31 * hashCode + (this.getEngine() == null ? 0 : this.getEngine().hashCode());
        hashCode = 31 * hashCode + (this.getMasterUsername() == null ? 0 : this.getMasterUsername().hashCode());
        hashCode = 31 * hashCode + (this.getMasterUserPassword() == null ? 0 : this.getMasterUserPassword().hashCode());
        hashCode = 31 * hashCode + (this.getDBSecurityGroups() == null ? 0 : ((Object)this.getDBSecurityGroups()).hashCode());
        hashCode = 31 * hashCode + (this.getAvailabilityZone() == null ? 0 : this.getAvailabilityZone().hashCode());
        hashCode = 31 * hashCode + (this.getDBSubnetGroupName() == null ? 0 : this.getDBSubnetGroupName().hashCode());
        hashCode = 31 * hashCode + (this.getPreferredMaintenanceWindow() == null ? 0 : this.getPreferredMaintenanceWindow().hashCode());
        hashCode = 31 * hashCode + (this.getDBParameterGroupName() == null ? 0 : this.getDBParameterGroupName().hashCode());
        hashCode = 31 * hashCode + (this.getBackupRetentionPeriod() == null ? 0 : this.getBackupRetentionPeriod().hashCode());
        hashCode = 31 * hashCode + (this.getPreferredBackupWindow() == null ? 0 : this.getPreferredBackupWindow().hashCode());
        hashCode = 31 * hashCode + (this.getPort() == null ? 0 : this.getPort().hashCode());
        hashCode = 31 * hashCode + (this.isMultiAZ() == null ? 0 : this.isMultiAZ().hashCode());
        hashCode = 31 * hashCode + (this.getEngineVersion() == null ? 0 : this.getEngineVersion().hashCode());
        hashCode = 31 * hashCode + (this.isAutoMinorVersionUpgrade() == null ? 0 : this.isAutoMinorVersionUpgrade().hashCode());
        hashCode = 31 * hashCode + (this.getLicenseModel() == null ? 0 : this.getLicenseModel().hashCode());
        hashCode = 31 * hashCode + (this.getOptionGroupName() == null ? 0 : this.getOptionGroupName().hashCode());
        hashCode = 31 * hashCode + (this.getCharacterSetName() == null ? 0 : this.getCharacterSetName().hashCode());
        return hashCode;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof CreateDBInstanceRequest)) {
            return false;
        }
        CreateDBInstanceRequest other = (CreateDBInstanceRequest)obj;
        if (other.getDBName() == null ^ this.getDBName() == null) {
            return false;
        }
        if (other.getDBName() != null && !other.getDBName().equals(this.getDBName())) {
            return false;
        }
        if (other.getDBInstanceIdentifier() == null ^ this.getDBInstanceIdentifier() == null) {
            return false;
        }
        if (other.getDBInstanceIdentifier() != null && !other.getDBInstanceIdentifier().equals(this.getDBInstanceIdentifier())) {
            return false;
        }
        if (other.getAllocatedStorage() == null ^ this.getAllocatedStorage() == null) {
            return false;
        }
        if (other.getAllocatedStorage() != null && !other.getAllocatedStorage().equals(this.getAllocatedStorage())) {
            return false;
        }
        if (other.getDBInstanceClass() == null ^ this.getDBInstanceClass() == null) {
            return false;
        }
        if (other.getDBInstanceClass() != null && !other.getDBInstanceClass().equals(this.getDBInstanceClass())) {
            return false;
        }
        if (other.getEngine() == null ^ this.getEngine() == null) {
            return false;
        }
        if (other.getEngine() != null && !other.getEngine().equals(this.getEngine())) {
            return false;
        }
        if (other.getMasterUsername() == null ^ this.getMasterUsername() == null) {
            return false;
        }
        if (other.getMasterUsername() != null && !other.getMasterUsername().equals(this.getMasterUsername())) {
            return false;
        }
        if (other.getMasterUserPassword() == null ^ this.getMasterUserPassword() == null) {
            return false;
        }
        if (other.getMasterUserPassword() != null && !other.getMasterUserPassword().equals(this.getMasterUserPassword())) {
            return false;
        }
        if (other.getDBSecurityGroups() == null ^ this.getDBSecurityGroups() == null) {
            return false;
        }
        if (other.getDBSecurityGroups() != null && !((Object)other.getDBSecurityGroups()).equals(this.getDBSecurityGroups())) {
            return false;
        }
        if (other.getAvailabilityZone() == null ^ this.getAvailabilityZone() == null) {
            return false;
        }
        if (other.getAvailabilityZone() != null && !other.getAvailabilityZone().equals(this.getAvailabilityZone())) {
            return false;
        }
        if (other.getDBSubnetGroupName() == null ^ this.getDBSubnetGroupName() == null) {
            return false;
        }
        if (other.getDBSubnetGroupName() != null && !other.getDBSubnetGroupName().equals(this.getDBSubnetGroupName())) {
            return false;
        }
        if (other.getPreferredMaintenanceWindow() == null ^ this.getPreferredMaintenanceWindow() == null) {
            return false;
        }
        if (other.getPreferredMaintenanceWindow() != null && !other.getPreferredMaintenanceWindow().equals(this.getPreferredMaintenanceWindow())) {
            return false;
        }
        if (other.getDBParameterGroupName() == null ^ this.getDBParameterGroupName() == null) {
            return false;
        }
        if (other.getDBParameterGroupName() != null && !other.getDBParameterGroupName().equals(this.getDBParameterGroupName())) {
            return false;
        }
        if (other.getBackupRetentionPeriod() == null ^ this.getBackupRetentionPeriod() == null) {
            return false;
        }
        if (other.getBackupRetentionPeriod() != null && !other.getBackupRetentionPeriod().equals(this.getBackupRetentionPeriod())) {
            return false;
        }
        if (other.getPreferredBackupWindow() == null ^ this.getPreferredBackupWindow() == null) {
            return false;
        }
        if (other.getPreferredBackupWindow() != null && !other.getPreferredBackupWindow().equals(this.getPreferredBackupWindow())) {
            return false;
        }
        if (other.getPort() == null ^ this.getPort() == null) {
            return false;
        }
        if (other.getPort() != null && !other.getPort().equals(this.getPort())) {
            return false;
        }
        if (other.isMultiAZ() == null ^ this.isMultiAZ() == null) {
            return false;
        }
        if (other.isMultiAZ() != null && !other.isMultiAZ().equals(this.isMultiAZ())) {
            return false;
        }
        if (other.getEngineVersion() == null ^ this.getEngineVersion() == null) {
            return false;
        }
        if (other.getEngineVersion() != null && !other.getEngineVersion().equals(this.getEngineVersion())) {
            return false;
        }
        if (other.isAutoMinorVersionUpgrade() == null ^ this.isAutoMinorVersionUpgrade() == null) {
            return false;
        }
        if (other.isAutoMinorVersionUpgrade() != null && !other.isAutoMinorVersionUpgrade().equals(this.isAutoMinorVersionUpgrade())) {
            return false;
        }
        if (other.getLicenseModel() == null ^ this.getLicenseModel() == null) {
            return false;
        }
        if (other.getLicenseModel() != null && !other.getLicenseModel().equals(this.getLicenseModel())) {
            return false;
        }
        if (other.getOptionGroupName() == null ^ this.getOptionGroupName() == null) {
            return false;
        }
        if (other.getOptionGroupName() != null && !other.getOptionGroupName().equals(this.getOptionGroupName())) {
            return false;
        }
        if (other.getCharacterSetName() == null ^ this.getCharacterSetName() == null) {
            return false;
        }
        return other.getCharacterSetName() == null || other.getCharacterSetName().equals(this.getCharacterSetName());
    }
}

