/*
Copyright (C) 2013 NTT DATA Corporation

This program is free software; you can redistribute it and/or
Modify it under the terms of the GNU General Public License
as published by the Free Software Foundation, version 2.

This program is distributed in the hope that it will be
useful, but WITHOUT ANY WARRANTY; without even the implied
warranty of MERCHANTABILITY or FITNESS FOR A PARTICULAR
PURPOSE.  See the GNU General Public License for more details.
 */
package com.clustercontrol.cloud.ui.views.actions;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;

import org.apache.log4j.Logger;
import org.eclipse.jface.action.IAction;
import org.eclipse.jface.dialogs.MessageDialog;

import com.clustercontrol.cloud.presenter.CloudModelException;
import com.clustercontrol.util.Messages;

public abstract class ErrorHandler {
	public void execute(IAction action) {
		try {
			invoke(action);
		}
		catch (Exception e) {
			Throwable t = e;
			if (e instanceof InvocationException) {
				if (e.getCause() != null) {
					t = e.getCause();
				}
			}
			
			if (e instanceof CloudModelException) {
				if (e.getCause() != null) {
					t = e.getCause();
				}
			}
			else if (e instanceof IllegalStateException) {
				if (e.getCause() != null) {
					t = e.getCause();
				}
			}
			
			Logger logger = Logger.getLogger(ErrorHandler.class);
			logger.error(t.getMessage(), t);

			String message = t.getMessage();

			if (message == null) {
				ByteArrayOutputStream bos = new ByteArrayOutputStream();
				PrintStream ps = new PrintStream(bos, true);
				t.printStackTrace(ps);
				
				message = bos.toString();
			}
			
			// 失敗報告ダイアログを生成
			MessageDialog.openError(null, Messages.getString("failed"), message);
		}
	}

	protected abstract void invoke(IAction action) throws InvocationException;
}
